/* 

=========================================================================

  #- SKYZBOT 
   Telegram: https://t.me/SpeedyCode_Robot
   
  👥 Team:
  - Developer: @KyzzXyz
  - Partner: Kalz, Felix, Tepz, Jooo, Fahz, Xin
  - Friends: Khafa, MalzXyz
  - Support: All Buyers
  
  ⚠️ HAK CIPTA DILINDUNGI:
  Script ini dijual resmi oleh SKYZBOT.
  Dilarang keras membagikan secara gratis.
  © 2024 - 2026 SKYZBOTZ. All Rights Reserved.

=========================================================================

*/



process.on('unhandledRejection', () => {});
process.on('uncaughtException', () => {});
process.on('warning', () => {});
console.error = () => {};
console.warn = () => {};
const axios = require('axios');
const fs = require('fs');
const path = require('path');
const fsAsync = require('fs').promises;
const archiver = require('archiver');
const QRCode = require('qrcode');
const chalk = require("chalk");
const api = require('./api/x-apikey.js');
const withdrawApi = require('./api/x-apikeyv3.js');
const config = require('./settings/config.js');
const TelegramBot = require('node-telegram-bot-api');

const {
    deposit_fee, 
    nokos_fee, 
    product_fee,
    khafaService, 
    royaltySystem,
    notifiedNewUsers, 
    productLocks, 
    userLastMessage,
    balanceLocks, 
    userSelections, 
    userDepositMessages,
    userPendingCommands, 
    balanceCache, 
    transactionCache,
    priceCache, 
    lastDepositRequestTime, 
    sentNotifications,
    orderProcessing, 
    depositProcessing,
    loadVouchers, 
    saveVouchers, 
    generateVoucherCode,
    createVoucher, 
    deleteVoucher, 
    listVouchers, 
    claimVoucher,
    getUserVoucher, 
    calculateDiscountedPrice,
    loadDataProduct, 
    saveDataProduct, 
    generateProductId,
    decreaseProductStock,
    loadSettings, 
    saveSettings, 
    escapeHtml,
    getPaymentMethod, 
    setPaymentMethod,
    loadBalances, 
    saveBalances, 
    getUserBalance, 
    addUserBalance, 
    deductUserBalance,
    getTransactionById, 
    validateAmount, 
    validateUserId,
    loadTransactions, 
    addTransaction, 
    saveTransactions,
    updateTransactionStatus, 
    cleanExpiredDeposits,
    saveJSON, 
    loadJSON, 
    loadData, 
    saveData, 
    saveUser,
    isOrderProcessing, 
    setOrderProcessing,
    formatCurrency, 
    editMessage, 
    getRandomImage, 
    sendNewMessage,
    createProgressBar,
    checkAutoMaintenance,
    isMaintenance, 
    getMaintenanceInfo, 
    setMaintenance,
    searchServices, 
    searchCountries, 
    checkChannelMembership,
    getCountryCode, 
    getFlagEmoji, 
    maskPhoneNumber, 
    balanceFile,
    datafile, 
    transactionsFile,
    settingsFile,
    dataProduct,
    getStatusText,
    startBot
} = require('./index.js');

const bot = new TelegramBot(config.bot_token, {
  polling: { 
    interval: 3000,
    params: { 
      timeout: 60,
      allowed_updates: ['message', 'callback_query']
    }
  }
})
    
global.bot = bot;

const startTime = new Date();
const startTimeJakarta = new Date(startTime.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));

setInterval(() => {
    scheduledAutoBackup();
}, 2 * 60 * 60 * 1000);

setTimeout(() => {
    scheduledAutoBackup();
}, 5 * 60 * 1000);

setInterval(() => {
    const now = Date.now();
    const oneMinute = 60 * 1000;
    
    for (const [key, timestamp] of balanceLocks.entries()) {
        if (now - timestamp > oneMinute) {
            balanceLocks.delete(key);
        }
    }
    
    for (const [key, timestamp] of orderProcessing.entries()) {
        if (now - timestamp > oneMinute) {
            orderProcessing.delete(key);
        }
    }
    
    for (const [key, timestamp] of depositProcessing.entries()) {
        if (now - timestamp > oneMinute) {
            depositProcessing.delete(key);
        }
    }
    
    for (const [key, timestamp] of userSelections.entries()) {
        if (now - timestamp > 30 * 60 * 1000) {
            userSelections.delete(key);
        }
    }
}, 30000);

const x_apikey = config.apikey;
const x_domain = config.domain;
const owner_ids = config.owner_ids;
const channel = config.channel;
const usernamelu = config.username_owner;
const fee_settings = config.fee_settings;

async function checkMaintenance(msg) {
  const userId = msg.from.id.toString();
  const chatId = msg.chat.id;
  
  const maintenance = getMaintenanceInfo();
  
  if (maintenance.active && !owner_ids.includes(userId)) {
    await bot.sendMessage(chatId,
`<b>🛠️ BOT SEDANG MAINTENANCE</b>

⚙️ Status: <b>Tidak Tersedia</b>
📝 Alasan: ${maintenance.reason}

⚠️ Mohon tunggu hingga maintenance selesai.

<b>📞 Kontak Owner</b>
@${usernamelu.replace('@','')}`,
      { 
        parse_mode: 'HTML',
        reply_markup: {
          inline_keyboard: [
            [{ 
              text: '🔄 Refresh Status', 
              callback_data: 'refresh_maintenance' 
            }]
          ]
        },
        disable_web_page_preview: true
      }
    );
    return false;
  }
  return true;
}

async function notifyChannelMaintenance(status, reason = '') {
    try {
        const now = new Date();
        const nowJakarta = new Date(now.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
        const waktu = nowJakarta.toLocaleString('id-ID');
        
        if (status === 'on') {
            await bot.sendMessage(channel,
`🚨 <b>BOT SEDANG MAINTENANCE</b> 🚨

📅 Tanggal: ${nowJakarta.toLocaleDateString('id-ID')}
🕐 Waktu: ${nowJakarta.toLocaleTimeString('id-ID')}
⚙️ Status: <b>TIDAK TERSEDIA</b>
📝 Alasan: ${reason || 'Perbaikan sistem'}

⚠️ <b>INFORMASI</b>
• Bot sementara tidak dapat digunakan
• Semua fitur dinonaktifkan
• Harap tunggu hingga maintenance selesai

🔧 <b>ESTIMASI</b>
Maintenance akan selesai dalam waktu dekat.

📢 <b>UPDATE</b>
Info lebih lanjut akan diumumkan di channel ini.`,
                {
                    parse_mode: 'HTML',
                    disable_web_page_preview: true
                }
            );
        } else if (status === 'off') {
            await bot.sendMessage(channel,
`✅ <b>MAINTENANCE SELESAI</b> ✅

📅 Tanggal: ${nowJakarta.toLocaleDateString('id-ID')}
🕐 Waktu: ${nowJakarta.toLocaleTimeString('id-ID')}
⚙️ Status: <b>TERSEDIA KEMBALI</b>

🎉 <b>INFORMASI</b>
• Bot sudah aktif kembali
• Semua fitur sudah berjalan normal
• User dapat menggunakan bot seperti biasa

🚀 <b>FITUR YANG TERSEDIA</b>
• Order nokos
• Deposit saldo
• Beli produk
• Voucher system

Terima kasih atas kesabaran Anda! 🙏`,
                {
                    parse_mode: 'HTML',
                    disable_web_page_preview: true
                }
            );
        }
    } catch (error) {
    }
}

function withRequireJoin(handler) {
  return async (msg, match) => {
    const ok = await requireJoin(msg);
    if (!ok) return;
    return handler(msg, match);
  };
}

async function requireJoin(msg) {
  const userId = msg.from.id;
  const isMember = await checkChannelMembership(userId);

  if (!isMember) {
    const originalCommand = msg.text || "/start";
    userPendingCommands.set(userId, originalCommand);

    await sendNewMessage(msg.chat.id, 
`<b>🔐 VERIFIKASI KEANGGOTAAN</b>

👤 Nama: ${msg.from.first_name || 'User'}
🆔 ID: <code>${userId}</code>
📊 Status: <b>Belum Bergabung</b>

<b>⚠️ AKSES DITOLAK</b>
Anda harus bergabung ke channel terlebih dahulu.

<b>🔰 PETUNJUK</b>
Klik tombol dibawah untuk bergabung`,
    {
      reply_markup: {
        inline_keyboard: [
          [{ 
            text: "📢 Join Channel", 
            url: `https://t.me/${channel.replace('@','')}` 
          }]
        ]
      },
      parse_mode: 'HTML',
      disable_web_page_preview: true
    });
    return false;
  }
  
  if (userPendingCommands.has(userId)) {
    userPendingCommands.delete(userId);
  }
  
  return true;
}

bot.onText(/\/start/, withRequireJoin(async (msg) => {
  const chatId = msg.chat.id;
  const userId = msg.from.id;
  const user = msg.from;
  const text = msg.text || '';
  
  if (!(await checkMaintenance(msg))) return;
  
  const data = loadData();
  const isExistingUser = data.users && data.users.includes(String(userId));
  
  if (!isExistingUser) {
    saveUser(userId);
    balanceCache.delete(userId.toString());
    
    if (!notifiedNewUsers.has(userId.toString())) {
      await NotifyNewUser(user, getUserBalance(userId), chatId);
      notifiedNewUsers.add(userId.toString());
    }
  } else {
    saveUser(userId);
    balanceCache.delete(userId.toString());
  }
  
  await showMainMenu(chatId, userId, user);
}));

bot.onText(/^\/broadcast$/, async (msg) => {
  const senderId = msg.from.id.toString();
  const chatId = msg.chat.id;
  
  if (senderId !== owner_ids[0]) {
    return await bot.sendMessage(chatId, 
`<b>❌ No Permission</b>`,
      { 
        parse_mode: "HTML",
        disable_web_page_preview: true 
      }
    ).catch(() => {});
  }

  if (!msg.reply_to_message) {
    return await bot.sendMessage(chatId, 
`<b>📢 BROADCAST MESSAGE</b>

Reply pesan yang ingin di broadcast
Ketik command /broadcast

<b>📋 JENIS PESAN YANG DIDUKUNG</b>
📝 Text Message
🖼️ Photo with Caption
📎 Document with Caption
🎥 Video with Caption`,
      { 
        parse_mode: "HTML",
        disable_web_page_preview: true 
      }
    ).catch(() => {});
  }

  const keyboard = {
    inline_keyboard: [
      [
        { 
          text: "📤 COPY", 
          callback_data: `broadcast_copy_${chatId}_${msg.reply_to_message.message_id}_${senderId}` 
        },
        { 
          text: "📎 FORWARD", 
          callback_data: `broadcast_forward_${chatId}_${msg.reply_to_message.message_id}_${senderId}` 
        }
      ]
    ]
  };

  await bot.sendMessage(
    chatId,
    `<b>📢 PILIH METODE BROADCAST</b>

📤 <b>Copy Pesan</b>
• Tanpa label "Forwarded"
• Pesan akan tampil dari bot

📎 <b>Forward Pesan</b>  
• Dengan label asli
• Pesan akan tampil sebagai forwarded message

<i>Pilih metode pengiriman:</i>`,
    { 
      parse_mode: "HTML", 
      reply_markup: keyboard,
      disable_web_page_preview: true
    }
  );
});

bot.onText(/^\/withdraw(?:\s+(.+))?$/, async (msg, match) => {
    const chatId = msg.chat.id;
    const userId = msg.from.id.toString();
    
    if (!owner_ids.includes(userId)) {
        await sendNewMessage(chatId,
`<b>❌ No Permission</b>`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }
    
    const args = match[1];
    if (!args) {
        await sendNewMessage(chatId,
`<b>📋 MENU WITHDRAW</b>

Format: <code>/withdraw nomor,nominal</code>
Contoh: <code>/withdraw 08123456789,50000</code>

<b>📋 ATURAN</b>
• Minimal withdraw: Rp 1.000
• Metode: DANA

<b>🔰 CONTOH</b>
<code>/withdraw 08123456789,100000</code>`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }
    
    const parts = args.split(',');
    if (parts.length !== 2) {
        await sendNewMessage(chatId,
`<b>❌ FORMAT SALAH</b>

Format: <code>/withdraw nomor,nominal</code>
Contoh: <code>/withdraw 08123456789,50000</code>

<b>🔰 PENJELASAN</b>
1. Nomor: Nomor DANA tujuan (contoh: 08123456789)
2. Nominal: Jumlah yang akan di withdraw (contoh: 50000)`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }
    
    const targetNumber = parts[0].trim();
    const nominalRaw = parts[1].trim();
    const nominal = parseInt(nominalRaw.replace(/\./g, ''));
    
    if (!targetNumber.match(/^08[0-9]{8,}$/)) {
        await sendNewMessage(chatId,
`<b>❌ NOMOR TIDAK VALID</b>

Nomor: ${targetNumber}
Format: 08xxxxxxxx (minimal 10 digit)

<b>⚠️ CONTOH YANG BENAR</b>
• 08123456789 (11 digit)
• 085712345678 (12 digit)`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }
    
    if (isNaN(nominal) || nominal < 1000) {
        await sendNewMessage(chatId,
`<b>❌ NOMINAL TIDAK VALID</b>

Nominal: ${nominalRaw}
Minimal: Rp 1.000`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }
    
    if (nominal % 1000 !== 0) {
        await sendNewMessage(chatId,
`<b>❌ NOMINAL TIDAK VALID</b>

Nominal: Rp ${nominal.toLocaleString('id-ID')}
Error: Nominal harus kelipatan 1.000

<b>⚠️ CONTOH YANG BENAR</b>
• 10000
• 25000
• 50000`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }
    
    const confirmMessage = await sendNewMessage(chatId,
`<b>✅ KONFIRMASI WITHDRAW</b>

━━━━━━━━━━━━━━━━━━━

<b>📱 PENERIMA</b>
Nomor: <code>${targetNumber}</code>

<b>💰 JUMLAH</b>
Nominal: <b>Rp ${nominal.toLocaleString('id-ID')}</b>

<b>📋 INFORMASI</b>
• Minimal: Rp 1.000
• Metode: DANA
• Saldo akan dicek otomatis

━━━━━━━━━━━━━━━━━━━

<b>⚠️ KONFIRMASI</b>
Apakah Anda yakin ingin melanjutkan?`,
        { 
            parse_mode: 'HTML',
            reply_markup: {
                inline_keyboard: [
                    [
                        { 
                            text: '✅ Ya, Lanjutkan', 
                            callback_data: `confirm_withdraw_${targetNumber}_${nominal}` 
                        }
                    ],
                    [
                        { 
                            text: '❌ Batalkan', 
                            callback_data: 'main_menu' 
                        }
                    ]
                ]
            }
        }
    );
});

async function processWithdraw(chatId, userId, targetNumber, nominal, messageId, callbackQueryId) {
    try {
        await editMessage(chatId, messageId, callbackQueryId,
`<b>⏳ MEMULAI PROSES WITHDRAW...</b>

Nomor: ${targetNumber}
Nominal: Rp ${nominal.toLocaleString('id-ID')}
Status: ⏳ Mengecek saldo...`,
            { parse_mode: 'HTML' }
        );
        
        const saldoResult = await withdrawApi.getRumahOTPSaldo();
        
        if (!saldoResult.success) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MENGECEK SALDO</b>

Error: Tidak dapat terhubung ke server RumahOTP

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        const saldo = saldoResult.balance;
        const formattedSaldo = saldoResult.formatted;
        
        await editMessage(chatId, messageId, callbackQueryId,
`<b>🔍 MENCARI PRODUK DANA...</b>

Nomor: ${targetNumber}
Nominal: Rp ${nominal.toLocaleString('id-ID')}
Saldo Tersedia: ${formattedSaldo}
Status: ⏳ Mencari produk...`,
            { parse_mode: 'HTML' }
        );
        
        await new Promise(resolve => setTimeout(resolve, 2000));
        
        const productResult = await withdrawApi.getDanaProduct(nominal);
        
        if (!productResult.success) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ PRODUK TIDAK TERSEDIA</b>

Error: ${productResult.message || 'Tidak ada produk DANA yang sesuai'}

<b>⚠️ TINDAKAN</b>
Coba nominal yang berbeda (minimal 10.000).`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        const product = productResult.data;
        const productPrice = product.price; 
        const productFee = productPrice - nominal; 
        
        if (saldo < productPrice) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ SALDO TIDAK CUKUP</b>

Saldo RumahOTP: ${formattedSaldo}
Dibutuhkan: Rp ${productPrice.toLocaleString('id-ID')} (termasuk fee)
Nominal Withdraw: Rp ${nominal.toLocaleString('id-ID')}
Fee: Rp ${productFee.toLocaleString('id-ID')}
Kekurangan: Rp ${(productPrice - saldo).toLocaleString('id-ID')}

<b>⚠️ TINDAKAN</b>
Topup saldo RumahOTP terlebih dahulu.`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        await editMessage(chatId, messageId, callbackQueryId,
`<b>🚀 MEMBUAT TRANSAKSI...</b>

Nomor: ${targetNumber}
Produk: DANA ${product.denom || product.name}
Nominal User: Rp ${nominal.toLocaleString('id-ID')}
Fee: Rp ${productFee.toLocaleString('id-ID')}
Total Dipotong: Rp ${productPrice.toLocaleString('id-ID')}
Kode: ${product.code}
Status: ⏳ Membuat transaksi...`,
            { parse_mode: 'HTML' }
        );
        
        const txResult = await withdrawApi.createTransaction(targetNumber, product.code);
        
        if (!txResult.success) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MEMBUAT TRANSAKSI</b>

Error: ${txResult.message || 'Transaksi gagal dibuat'}

<b>⚠️ TINDAKAN</b>
Silakan coba lagi.`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        const transaction = txResult.data;
        
        await editMessage(chatId, messageId, callbackQueryId,
`<b>📡 MEMERIKSA STATUS...</b>

ID Transaksi: ${transaction.id}
Nomor: ${targetNumber}
Nominal User: Rp ${nominal.toLocaleString('id-ID')}
Fee: Rp ${productFee.toLocaleString('id-ID')}
Total Dipotong: Rp ${productPrice.toLocaleString('id-ID')}
Status: ⏳ Menunggu konfirmasi...`,
            { parse_mode: 'HTML' }
        );
        
        await new Promise(resolve => setTimeout(resolve, 3000));
        
        const statusResult = await withdrawApi.checkTransaction(transaction.id);
        
        let statusText = 'PROSES';
        if (statusResult.success) {
            statusText = statusResult.data?.status || 'PROSES';
        }
        
        const now = new Date();
        const timeStr = now.toLocaleTimeString('id-ID', {
            hour: '2-digit',
            minute: '2-digit',
            second: '2-digit'
        });
        
        const remainingBalance = saldo - productPrice;
        
        await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ WITHDRAW BERHASIL DIPROSES</b>

━━━━━━━━━━━━━━━━━━━

<b>📱 INFORMASI PENERIMA</b>
Nomor: <code>${targetNumber}</code>
Metode: DANA

<b>💰 INFORMASI TRANSAKSI</b>
Nominal User: <b>Rp ${nominal.toLocaleString('id-ID')}</b>
Fee System: <b>Rp ${productFee.toLocaleString('id-ID')}</b>
Total Dipotong: <b>Rp ${productPrice.toLocaleString('id-ID')}</b>
Status: <b>${statusText}</b>
ID Transaksi: <code>${transaction.id}</code>
Waktu: ${timeStr}

<b>💳 INFORMASI SALDO RUMAHOTP</b>
Saldo Sebelum: ${formattedSaldo}
Total Dipotong: Rp ${productPrice.toLocaleString('id-ID')}
Saldo Sesudah: Rp ${remainingBalance.toLocaleString('id-ID')}

━━━━━━━━━━━━━━━━━━━

<b>📊 RINCIAN</b>
• User terima: Rp ${nominal.toLocaleString('id-ID')}
• Fee sistem: Rp ${productFee.toLocaleString('id-ID')}
• Total keluar dari saldo: Rp ${productPrice.toLocaleString('id-ID')}

<b>⚠️ CATATAN</b>
• Transaksi akan diproses oleh sistem
• Biasanya memakan waktu 1-5 menit
• Jika gagal, saldo akan dikembalikan otomatis`,
            { parse_mode: 'HTML' }
        );
        
    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ TERJADI KESALAHAN</b>

Error: ${error.message || 'Internal server error'}

<b>⚠️ TINDAKAN</b>
Silakan hubungi developer.`,
            { parse_mode: 'HTML' }
        );
    }
}

bot.onText(/^\/setpay$/, async (msg) => {
  const chatId = msg.chat.id;
  const userId = msg.from.id.toString();
  
  if (!owner_ids.includes(userId)) {
    return bot.sendMessage(chatId, 
`<b>❌ No Permission</b>`,
      { 
        parse_mode: 'HTML',
        disable_web_page_preview: true 
      }
    );
  }
  
  const currentMethod = getPaymentMethod();
  const isRumahOTP = currentMethod === 'rumahotp';
  const isKhafa = currentMethod === 'khafa';
  const message = `<b>⚙️ SETTING METODE PEMBAYARAN</b>

🏦 Rumah OTP: ${isRumahOTP ? '✅ Aktif' : '❌ Nonaktif'}
💳 Khafa: ${isKhafa ? '✅ Aktif' : '❌ Nonaktif'}

<b>📋 PILIH METODE</b>
Klik tombol untuk mengganti metode:`;
  
  await bot.sendMessage(chatId, message, {
    parse_mode: 'HTML',
    reply_markup: {
      inline_keyboard: [
        [
          { 
            text: isRumahOTP ? '✅ RUMAH OTP' : '🏦 RUMAH OTP', 
            callback_data: 'setpay_rumahotp' 
          },
          { 
            text: isKhafa ? '✅ KHAFA' : '💳 KHAFA', 
            callback_data: 'setpay_khafa' 
          }
        ]
      ]
    },
    disable_web_page_preview: true
  });
});

bot.onText(/^\/backup$/, async (msg) => {
    const chatId = msg.chat.id;
    const userId = msg.from.id.toString();
    
    if (!owner_ids.includes(userId)) {
        await bot.sendMessage(chatId,
            `<b>❌ No Permission</b>`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }
    
    try {
        const now = new Date();
        const dateStr = now.toISOString().split('T')[0];
        const timeStr = now.getHours().toString().padStart(2, '0') + '-' + 
                       now.getMinutes().toString().padStart(2, '0') + '-' +
                       now.getSeconds().toString().padStart(2, '0');
        
        const backupFileName = `manual_backup_${dateStr}_${timeStr}.zip`;
        const processingMsg = await bot.sendMessage(chatId,
            `<b>📦 MEMBUAT BACKUP MANUAL</b>

Status: ⏳ Menyiapkan data...
Nama File: ${backupFileName}
Owner: ${userId}`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        
        const archive = archiver('zip', { zlib: { level: 9 } });
        const chunks = [];
        
        archive.on('data', (chunk) => chunks.push(chunk));
        archive.on('error', (err) => {
            console.error('Archive error:', err);
            throw err;
        });
        
        const backupFiles = [
            { 
                name: 'database/balances.json', 
                path: balanceFile 
            },
            { 
                name: 'database/users.json', 
                path: datafile 
            },
            { 
                name: 'database/transactions.json', 
                path: transactionsFile 
            },
            { 
                name: 'database/settings.json', 
                path: settingsFile 
            },
            { 
                name: 'database/dataproduct.json', 
                path: dataProduct  
            },
            { 
                name: 'library/points.json', 
                path: path.join(__dirname, 'library', 'points.json') 
            }
        ];
        
        let fileCount = 0;
        let successCount = 0;
        
        for (const file of backupFiles) {
            fileCount++;
            
            try {
                if (file.isDirectory) {
                    if (fs.existsSync(file.path)) {
                        archive.directory(file.path, file.name);
                        successCount++;
                    }
                } else {
                    if (fs.existsSync(file.path)) {
                        const fileBuffer = fs.readFileSync(file.path);
                        archive.append(fileBuffer, { name: file.name });
                        successCount++;
                    } else {
                        console.warn(`File not found: ${file.path}`);
                    }
                }
            } catch (fileError) {
                console.error(`Error adding ${file.name}:`, fileError);
            }
        }
        
        await new Promise((resolve, reject) => {
            archive.on('end', resolve);
            archive.on('error', reject);
            archive.finalize();
        });
        
        const zipBuffer = Buffer.concat(chunks);
        const fileSizeKB = (zipBuffer.length / 1024).toFixed(2);
        
        await bot.deleteMessage(chatId, processingMsg.message_id).catch(() => {});

        await bot.sendDocument(chatId, zipBuffer, {
            caption: `<b>✅ BACKUP MANUAL BERHASIL</b>

📁 Nama File: ${backupFileName}
📊 File Success: ${successCount}/${fileCount}
💾 Size ZIP: ${fileSizeKB} KB
👤 Owner: ${userId}
📅 Waktu: ${new Date().toLocaleString('id-ID')}

<b>📋 FILE YANG DIBACKUP:</b>
1. database/balances.json ${fs.existsSync(balanceFile) ? '✅' : '❌'}
2. database/users.json ${fs.existsSync(datafile) ? '✅' : '❌'}
3. database/transactions.json ${fs.existsSync(transactionsFile) ? '✅' : '❌'}
4. database/settings.json ${fs.existsSync(settingsFile) ? '✅' : '❌'}
5. database/dataproduct.json ${fs.existsSync(dataProduct) ? '✅' : '❌'}
6. library/points.json ${fs.existsSync(path.join(__dirname, 'library', 'points.json')) ? '✅' : '❌'}

<b>⚠️ CATATAN:</b>
File dengan tanda ❌ tidak ditemukan atau error.`,
            parse_mode: 'HTML',
            filename: backupFileName
        });
        
    } catch (error) {
        console.error('Backup error:', error);
        
        try {
            await bot.sendMessage(chatId,
                `<b>❌ GAGAL MEMBUAT BACKUP</b>

Error: ${error.message || 'Unknown error'}

<b>📋 DETAIL ERROR:</b>
<code>${error.stack || 'No stack trace'}</code>`,
                { 
                    parse_mode: 'HTML',
                    disable_web_page_preview: true 
                }
            );
        } catch (sendError) {
            console.error('Failed to send error message:', sendError);
        }
    }
});

bot.onText(/^\/maintenance/, async (msg) => {
  const chatId = msg.chat.id;
  const userId = msg.from.id.toString();
  
  if (!owner_ids.includes(userId)) {
    return bot.sendMessage(chatId, 
`<b>❌ No Permission</b>`,
      { 
        parse_mode: 'HTML',
        disable_web_page_preview: true 
      }
    );
  }
  
  const text = msg.text || '';
  const args = text.trim().split(/\s+/);
  
  if (args.length === 1) {
    const maintenance = getMaintenanceInfo();
    const statusEmoji = maintenance.active ? '⛔' : '✅';
    const statusText = maintenance.active ? 'ON (Aktif)' : 'OFF (Nonaktif)';
    
    return bot.sendMessage(chatId,
`<b>🛠️ STATUS MAINTENANCE</b>

Status: ${statusEmoji} ${statusText}
${maintenance.reason ? `Alasan: ${maintenance.reason}` : ''}

<b>📋 FORMAT COMMAND</b>
/maintenance on (reply pesan untuk alasan)
/maintenance off`,
      { 
        parse_mode: 'HTML',
        disable_web_page_preview: true 
      }
    );
  }
  
  const command = args[1].toLowerCase();
  
  if (command === 'off') {
    setMaintenance(false);
    
    await notifyChannelMaintenance('off');
    
    return bot.sendMessage(chatId,
`<b>✅ MAINTENANCE MODE DIMATIKAN</b>

Status: ✅ Nonaktif

<b>📢 NOTIFIKASI</b>
Pemberitahuan telah dikirim ke channel.`,
      { 
        parse_mode: 'HTML',
        disable_web_page_preview: true 
      }
    );
  }
  
  if (command === 'on') {
    if (!msg.reply_to_message) {
      return bot.sendMessage(chatId,
`<b>⚠️ PERLU ALASAN MAINTENANCE</b>

Ketik alasan maintenance
Reply pesan tersebut
Kirim /maintenance on`,
        { 
          parse_mode: 'HTML',
          disable_web_page_preview: true 
        }
      );
    }
    
    const reason = msg.reply_to_message.text || 'Bot sedang dalam perbaikan';
    setMaintenance(true, reason);
    
    await notifyChannelMaintenance('on', reason);
    
    return bot.sendMessage(chatId,
`<b>⛔ MAINTENANCE MODE DIAKTIFKAN</b>

Status: ⛔ Aktif
Alasan: ${reason}

<b>📢 NOTIFIKASI</b>
Pemberitahuan telah dikirim ke channel.`,
      { 
        parse_mode: 'HTML',
        disable_web_page_preview: true 
      }
    );
  }
  
  bot.sendMessage(chatId,
`<b>❌ FORMAT SALAH</b>

/maintenance on
/maintenance off`,
    { 
      parse_mode: 'HTML',
      disable_web_page_preview: true 
    }
  );
});

bot.onText(/^\/addsaldo(\s|$)/, async (msg) => {
    const chatId = msg.chat.id;
    const userId = msg.from.id.toString();
    
    if (!owner_ids.includes(userId)) {
        await bot.sendMessage(chatId,
            `<b>❌ No Permission</b>`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    await addBalanceAdmin(chatId, userId, msg.text);
});

bot.onText(/^\/delsaldo(\s|$)/, async (msg) => {
    const chatId = msg.chat.id;
    const userId = msg.from.id.toString();
    
    if (!owner_ids.includes(userId)) {
        await bot.sendMessage(chatId,
            `<b>❌ No Permission</b>`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    const parts = msg.text.split(' ');
    if (parts.length < 3) {
        await bot.sendMessage(chatId,
`<b>❌ FORMAT SALAH</b>

Format: /delsaldo [user_id] [jumlah]
Contoh: /delsaldo 727281 50000`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    const targetUserId = parts[1];
    const amount = parseInt(parts[2]);
    
    if (isNaN(amount) || amount <= 0) {
        await bot.sendMessage(chatId,
`<b>❌ JUMLAH TIDAK VALID</b>

Jumlah harus angka positif`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    const currentBalance = getUserBalance(targetUserId);
    if (currentBalance < amount) {
        await bot.sendMessage(chatId,
`<b>❌ SALDO TIDAK CUKUP</b>

Saldo user: ${formatCurrency(currentBalance)}
Jumlah yang akan dikurangi: ${formatCurrency(amount)}`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    const success = deductUserBalance(targetUserId, amount);
    if (!success) {
        await bot.sendMessage(chatId,
`<b>❌ GAGAL MENGURANGI SALDO</b>

Terjadi kesalahan sistem`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    const newBalance = getUserBalance(targetUserId);
    
    await bot.sendMessage(chatId,
`<b>✅ SALDO BERHASIL DIKURANGI</b>

User ID: ${targetUserId}
➖ Dikurangi: ${formatCurrency(amount)}
💰 Saldo Lama: ${formatCurrency(currentBalance)}
💰 Saldo Baru: ${formatCurrency(newBalance)}
👤 Admin: ${userId}`,
        { parse_mode: 'HTML' }
    );
});

bot.onText(/^\/topsaldo$/, async (msg) => {
    const chatId = msg.chat.id;
    const userId = msg.from.id.toString();
    
    if (!owner_ids.includes(userId)) {
        await bot.sendMessage(chatId,
            `<b>❌ No Permission</b>`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    const balances = loadBalances();
    const transactions = loadTransactions();
    
    const allUsers = Object.entries(balances)
        .sort((a, b) => b[1] - a[1])
        .slice(0, 50);
    
    if (allUsers.length === 0) {
        await bot.sendMessage(chatId,
            `<b>📋 DAFTAR SALDO</b>
Belum ada user dengan saldo`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    let message = `<b>📋 DAFTAR SALDO (TOP 50)</b>\n\n`;
    
    for (let i = 0; i < allUsers.length; i++) {
        const [userId, balance] = allUsers[i];
        
        const userOrders = (transactions.nokos_orders || []).filter(order => 
            String(order.userId) === String(userId)
        ).length;
        
        const userDeposits = [
            ...(transactions.rumahotp_deposits?.filter(deposit => 
                String(deposit.userId) === String(userId) && 
                (deposit.status === 'success' || deposit.status === 'paid')
            ) || []),
            ...(transactions.khafa_deposits?.filter(deposit => 
                String(deposit.userId) === String(userId) && 
                (deposit.status === 'success' || deposit.status === 'paid')
            ) || [])
        ].length;
        
        try {
            const user = await bot.getChat(userId);
            const username = user.username ? `@${user.username}` : 'No username';
            
            message += `${i + 1}. ${username} (${userId})\n`;
            message += `   ${formatCurrency(balance)} / ${userOrders}x order / ${userDeposits}x deposit\n\n`;
            
        } catch {
            message += `${i + 1}. User ${userId}\n`;
            message += `   ${formatCurrency(balance)} / ${userOrders}x order / ${userDeposits}x deposit\n\n`;
        }
        
        if (i >= 49) break;
    }
    
    const totalBalance = Object.values(balances).reduce((sum, b) => sum + (Number(b) || 0), 0);
    message += `<b>📊 TOTAL: ${formatCurrency(totalBalance)}</b>`;
    
    await bot.sendMessage(chatId, message, { 
        parse_mode: 'HTML',
        disable_web_page_preview: true 
    });
});

bot.onText(/^\/stats$/, async (msg) => {
    const chatId = msg.chat.id;
    const userId = msg.from.id.toString();
    
    if (!owner_ids.includes(userId)) {
        await bot.sendMessage(chatId,
            "<b>❌ No Permission</b>",
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    try {
        const data = loadData();
        const balances = loadBalances();
        const transactions = loadTransactions();
        
        const fetchRumahOTPBalance = async () => {
            try {
                const response = await axios.get(`${config.domain}/v1/user/balance`, {
                    headers: {
                        'x-apikey': config.apikey,
                        'Accept': 'application/json'
                    },
                    timeout: 10000
                });
                
                if (response.data && response.data.success) {
                    return Number(response.data.data?.balance || response.data.data?.saldo || 0);
                }
                return 0;
            } catch (error) {
                console.error('Gagal mengambil saldo Rumah OTP:', error.message);
                return -1; 
            }
        };

        const fetchKhafaBalance = async () => {
            try {
                const response = await axios.get('https://khafatopup.my.id/h2h/profile', {
                    headers: {
                        'X-APIKEY': config.khafa_apikey,
                        'Content-Type': 'application/json'
                    },
                    timeout: 10000
                });

                if (response.data && response.data.success) {
                    return Number(response.data.user?.saldo || response.data.data?.saldo || 0);
                }
                return 0;
            } catch (error) {
                console.error('Gagal mengambil saldo Khafa:', error.message);
                return -1;
            }
        };

        const balancePromises = [
            fetchRumahOTPBalance(),
            fetchKhafaBalance()
        ];
        
        const timeoutPromise = (promise, ms) => {
            return Promise.race([
                promise,
                new Promise((_, reject) => 
                    setTimeout(() => reject(new Error('Timeout')), ms)
                )
            ]);
        };
        
        let rumahOTPBalance = -1;
        let khafaBalance = -1;
        
        try {
            const [rumahOTPResult, khafaResult] = await Promise.allSettled([
                timeoutPromise(balancePromises[0], 8000),
                timeoutPromise(balancePromises[1], 8000)
            ]);
            
            rumahOTPBalance = rumahOTPResult.status === 'fulfilled' ? rumahOTPResult.value : -1;
            khafaBalance = khafaResult.status === 'fulfilled' ? khafaResult.value : -1;
            
        } catch (error) {
            console.error('Error fetching balances:', error);
        }
        
        const totalUsers = data.users?.length || 0;
        const totalOrders = transactions.nokos_orders?.length || 0;
        const rumahOTPDeposits = transactions.rumahotp_deposits || [];
        const khafaDeposits = transactions.khafa_deposits || [];      
        const successfulRumahOTPDeposits = rumahOTPDeposits.filter(deposit => 
            deposit.status === 'success' || deposit.status === 'paid'
        ).length;
        
        const successfulKhafaDeposits = khafaDeposits.filter(deposit => 
            deposit.status === 'success' || deposit.status === 'paid'
        ).length;
        
        const totalSuccessfulDeposits = successfulRumahOTPDeposits + successfulKhafaDeposits;
        
        const calculateTotalDepositAmount = (deposits) => {
            return deposits.reduce((sum, deposit) => {
                if (deposit.status === 'success' || deposit.status === 'paid') {
                    const amount = Number(deposit.data?.amount) || 
                                   Number(deposit.data?.nominal) || 
                                   Number(deposit.data?.total) || 
                                   0;
                    return sum + amount;
                }
                return sum;
            }, 0);
        };
        
        const rumahOTPTotalDeposit = calculateTotalDepositAmount(rumahOTPDeposits);
        const khafaTotalDeposit = calculateTotalDepositAmount(khafaDeposits);
        const totalDepositAmount = rumahOTPTotalDeposit + khafaTotalDeposit;
        const totalOrderAmount = (transactions.nokos_orders || []).reduce((sum, order) => {
            if (order.status === 'completed' || order.status === 'success' || 
                order.data?.otp_received === true || 
                (order.data?.otp_code && order.data?.otp_code !== '-' && order.data?.otp_code !== '')) {
                return sum + (Number(order.data?.total || order.data?.price || 0));
            }
            return sum;
        }, 0);
        
        const totalBalance = Object.values(balances).reduce((sum, balance) => sum + (Number(balance) || 0), 0);
        
        const formatBalanceDisplay = (balance, gatewayName) => {
            if (balance === -1) return `❌ ${gatewayName}: Gagal fetch`;
            return `${formatCurrency(balance)}`;
        };
        
        const formatDepositCount = (count) => {
            return count > 0 ? `${count}x` : '-';
        };

        let totalGatewayBalance = 0;
        let gatewayCount = 0;
        
        if (rumahOTPBalance >= 0) {
            totalGatewayBalance += rumahOTPBalance;
            gatewayCount++;
        }
        if (khafaBalance >= 0) {
            totalGatewayBalance += khafaBalance;
            gatewayCount++;
        }
        
        const message = `<b>📊 STATISTIK BOT</b>

📅 ${new Date().toLocaleDateString('id-ID')}
🕐 ${new Date().toLocaleTimeString('id-ID')}

<b>📈 OVERVIEW SISTEM</b>
• Total User: ${totalUsers.toLocaleString('id-ID')}
• Total Order: ${totalOrders.toLocaleString('id-ID')}
• Deposit Sukses: ${totalSuccessfulDeposits.toLocaleString('id-ID')}
• Saldo User: ${formatCurrency(totalBalance)}

<b>🌐 SALDO GATEWAY (SALDO ASLI)</b>
${rumahOTPBalance >= 0 ? `• Rumah OTP: ${formatCurrency(rumahOTPBalance)}` : '• Rumah OTP: ❌ Gagal fetch'}
${khafaBalance >= 0 ? `• Khafa: ${formatCurrency(khafaBalance)}` : '• Khafa: ❌ Gagal fetch'}
${gatewayCount > 0 ? `• Total Gateway: ${formatCurrency(totalGatewayBalance)} (${gatewayCount}/2 berhasil)` : '• Total Gateway: ❌ Semua gateway gagal'}

<b>💵 STATISTIK KEUANGAN</b>
• Total Deposit: ${formatCurrency(totalDepositAmount)}
• Total Order: ${formatCurrency(totalOrderAmount)}
• Profit: ${formatCurrency(totalDepositAmount - totalOrderAmount)}

<b>📊 DEPOSIT PER GATEWAY</b>
• Rumah OTP: ${formatDepositCount(successfulRumahOTPDeposits)} (${formatCurrency(rumahOTPTotalDeposit)})
• Khafa: ${formatDepositCount(successfulKhafaDeposits)} (${formatCurrency(khafaTotalDeposit)})

<b>⚙️ STATUS SISTEM</b>
• Maintenance: ${isMaintenance() ? '⛔ Aktif' : '✅ Normal'}
• Payment Method: ${getPaymentMethod().toUpperCase()}
• Last Update: ${new Date().toLocaleString('id-ID')}`;

        await bot.sendMessage(chatId, message, { 
            parse_mode: 'HTML',
            disable_web_page_preview: true 
        });
        
    } catch (error) {
        console.error('Error in /stats command:', error);
        await bot.sendMessage(chatId,
            `<b>❌ GAGAL MENGAMBIL STATISTIK</b>\n\nError: ${error.message || 'Unknown error'}`,
            { parse_mode: 'HTML' }
        );
    }
});

bot.onText(/^\/addvc(?:\s+(.+))?$/, async (msg, match) => {
  const chatId = msg.chat.id;
  const userId = msg.from.id.toString();
 
  if (!config.owner_ids.includes(userId)) {
    return bot.sendMessage(chatId, "❌ No Permission");
  }
  
  if (!match[1]) {
    return bot.sendMessage(chatId,
`📝 <b>CARA BUAT VOUCHER</b>

<b>Format:</b> <code>/addvc NAMA DISKON LIMIT EXPIRED</code>

<b>Contoh:</b>
<code>/addvc DISKON50 50 10 60</code>`,
      { parse_mode: 'HTML' }
    );
  }
  
  const args = match[1].split(' ');
  
  if (args.length < 4) {
    return bot.sendMessage(chatId,
`❌ <b>Parameter kurang!</b>

<b>Format:</b> <code>/addvc NAMA DISKON LIMIT EXPIRED</code>
<b>Contoh:</b> <code>/addvc DISKON50 50 10 60</code>

<b>Anda:</b> <code>/addvc ${match[1]}</code>`,
      { parse_mode: 'HTML' }
    );
  }
  
  const name = args[0];
  const discount = parseInt(args[1]);
  const limit = parseInt(args[2]);
  const expiredMinutes = parseInt(args[3]);

  if (isNaN(discount) || discount < 1 || discount > 100) {
    return bot.sendMessage(chatId, `❌ Diskon harus 1-100% (anda: ${args[1]})`);
  }
  
  if (isNaN(limit) || limit < 1) {
    return bot.sendMessage(chatId, `❌ Limit minimal 1 user (anda: ${args[2]})`);
  }
  
  if (isNaN(expiredMinutes) || expiredMinutes < 0) {
    return bot.sendMessage(chatId, `❌ Expired tidak valid (anda: ${args[3]})`);
  }
  
  const code = name.toUpperCase();
  const result = await createVoucher(code, discount, limit);
  
  if (result.success) {
    if (expiredMinutes > 0) {
      const voucherDB = loadVouchers();
      if (voucherDB.vouchers[code]) {
        const expiredTime = new Date();
        expiredTime.setMinutes(expiredTime.getMinutes() + expiredMinutes);
        voucherDB.vouchers[code].expired_at = expiredTime.toISOString();
        saveVouchers(voucherDB);
      }
    }
    
    let message = `✅ <b>Voucher Berhasil Dibuat!</b>\n\n`;
    message += `<b>Kode:</b> <code>${code}</code>\n`;
    message += `<b>Diskon:</b> ${discount}%\n`;
    message += `<b>Limit:</b> ${limit} user\n`;
    
    if (expiredMinutes > 0) {
      message += `<b>Expired:</b> ${expiredMinutes} menit\n`;
      const expiredTime = new Date();
      expiredTime.setMinutes(expiredTime.getMinutes() + expiredMinutes);
      message += `<b>Hingga:</b> ${expiredTime.toLocaleTimeString('id-ID')}`;
    } else {
      message += `<b>Expired:</b> Tidak ada`;
    }
    
    bot.sendMessage(chatId, message, { parse_mode: 'HTML' });
  } else {
    bot.sendMessage(chatId, `❌ <b>Gagal:</b> ${result.error}`, { parse_mode: 'HTML' });
  }
});

bot.onText(/^\/delvc(?:\s+(.+))?$/, async (msg, match) => {
  const chatId = msg.chat.id;
  const userId = msg.from.id.toString();
  
  if (!config.owner_ids.includes(userId)) {
    return bot.sendMessage(chatId, "❌ No Permission");
  }
  
  if (!match[1]) {
    return bot.sendMessage(chatId,
`🗑️ <b>CARA HAPUS VOUCHER</b>

<b>Format:</b> <code>/delvc KODE</code>

<b>Contoh:</b>
<code>/delvc DISKON50</code>`,
      { parse_mode: 'HTML' }
    );
  }
  
  const code = match[1].toUpperCase();
  const result = await deleteVoucher(code);
  
  if (result.success) {
    bot.sendMessage(chatId, `✅ <b>Voucher dihapus:</b> <code>${code}</code>`, { parse_mode: 'HTML' });
  } else {
    bot.sendMessage(chatId, `❌ <b>Gagal:</b> ${result.error}`, { parse_mode: 'HTML' });
  }
});

bot.onText(/^\/listvc$/, async (msg) => {
  const chatId = msg.chat.id;
  const userId = msg.from.id.toString();
  
  if (!config.owner_ids.includes(userId)) {
    return bot.sendMessage(chatId, "❌ No Permission");
  }
  
  const result = listVouchers();
  
  if (!result.success || result.total === 0) {
    return bot.sendMessage(chatId,
`📭 <b>Tidak Ada Voucher</b>

Belum ada voucher yang dibuat.
Buat voucher dengan <code>/addvc</code>`,
      { parse_mode: 'HTML' }
    );
  }
  
  let message = `📋 <b>DAFTAR VOUCHER</b>\n`;
  message += `Total: <b>${result.total}</b> voucher\n\n`;
  
  result.vouchers.forEach((v, i) => {
    const status = v.active ? '✅' : '❌';
    const expiredText = v.expired_at ? 
      `Exp: ${Math.ceil((new Date(v.expired_at) - new Date()) / (1000 * 60))}m` : 
      'No exp';
    
    message += `${status} <b>${v.code}</b>\n`;
    message += `├ Diskon: ${v.discount}%\n`;
    message += `├ Digunakan: ${v.used}/${v.limit}\n`;
    message += `├ Sisa: ${v.remaining}\n`;
    message += `└ ${expiredText}\n`;
    
    if (i < result.vouchers.length - 1) message += '─\n';
  });
  
  bot.sendMessage(chatId, message, { parse_mode: 'HTML' });
});

bot.onText(/^\/claim(?:\s+(.+))?$/, async (msg, match) => {
  const chatId = msg.chat.id;
  const userId = msg.from.id.toString();
  
  if (!match[1]) {
    return bot.sendMessage(chatId,
`🎫 <b>CARA KLAIM VOUCHER</b>

<b>Format:</b> <code>/claim KODE</code>

<b>Contoh:</b>
<code>/claim DISKON50</code>

<b>Manfaat:</b>
• Potongan harga order nokos
• Potongan harga beli produk
• Harga lebih murah!`,
      { parse_mode: 'HTML' }
    );
  }
  
  const code = match[1].toUpperCase();
  const result = await claimVoucher(userId, code);
  
  if (result.success) {
    bot.sendMessage(chatId,
`✅ <b>Voucher Berhasil Diklaim!</b>

<b>Kode:</b> <code>${code}</code>
<b>Diskon:</b> ${result.data.discount}%
<b>Sisa kuota:</b> ${result.data.remaining} user

<b>Voucher otomatis aktif untuk order berikutnya!</b>`,
      { parse_mode: 'HTML' }
    );
  } else {
    bot.sendMessage(chatId, `❌ <b>Gagal klaim:</b> ${result.error}`, { parse_mode: 'HTML' });
  }
});

bot.onText(/^\/addproduct(?:\s+(.+))?$/, async (msg, match) => {
    const chatId = msg.chat.id;
    const senderId = msg.from.id.toString();
    
    const mainOwnerId = owner_ids[0];
    if (senderId !== mainOwnerId) {
        return await sendNewMessage(chatId, 
            "<b>❌ No Permission</b>",
            { parse_mode: "HTML" }
        );
    }

    if (!msg.reply_to_message) {
        return await sendNewMessage(chatId,
            `<b>❌ FORMAT SALAH</b>

<b>📝 Format yang benar:</b>
1. Reply file dengan command /addproduct
2. Format: <code>/addproduct nama|harga|stock|deskripsi|code</code>

<b>💡 Contoh:</b>
<code>/addproduct Bot Premium|2000|999|Script Telegram Bot Premium|scvip1</code>

<b>⚠️ Note:</b> Reply file yang ingin diupload`,
            { parse_mode: "HTML" }
        );
    }

    const hasDocument = msg.reply_to_message.document;
    const hasPhoto = msg.reply_to_message.photo;
    const hasText = msg.reply_to_message.text;

    if (!hasDocument && !hasPhoto && !hasText) {
        return await sendNewMessage(chatId,
            "<b>❌ FILE TIDAK DIDUKUNG</b>\n\nHanya support: Document, Photo, Text file",
            { parse_mode: "HTML" }
        );
    }

    const paramsText = match[1];
    
    if (!paramsText) {
        return await sendNewMessage(chatId,
            `<b>❌ PARAMETER TIDAK LENGKAP</b>

<b>📝 Format:</b>
<code>/addproduct nama|harga|stock|deskripsi|code</code>

<b>🔢 Parameter yang dibutuhkan:</b>
1. Nama produk
2. Harga (angka)
3. Stock (angka)  
4. Deskripsi
5. Kode pembelian

<b>💡 Contoh:</b>
<code>/addproduct Bot Premium|2000|999|Script Telegram Bot Premium|scvip1</code>`,
            { parse_mode: "HTML" }
        );
    }

    const params = paramsText.split('|');
    if (params.length !== 5) {
        return await sendNewMessage(chatId,
            `<b>❌ PARAMETER TIDAK LENGKAP</b>

<b>📝 Format:</b>
<code>/addproduct nama|harga|stock|deskripsi|code</code>

<b>🔢 Parameter yang dibutuhkan:</b>
1. Nama produk
2. Harga (angka)
3. Stock (angka)  
4. Deskripsi
5. Kode pembelian

<b>💡 Contoh:</b>
<code>/addproduct Bot Premium|2000|999|Script Telegram Bot Premium|scvip1</code>`,
            { parse_mode: "HTML" }
        );
    }

    const [name, priceStr, stockStr, description, code] = params;
    const price = parseInt(priceStr.replace(/\./g, ''));
    const stock = parseInt(stockStr);

    if (isNaN(price) || price < 2000) {
        return await sendNewMessage(chatId,
            "<b>❌ HARGA TIDAK VALID</b>\n\nHarga minimal Rp 1,000",
            { parse_mode: "HTML" }
        );
    }

    if (isNaN(stock) || stock < 0) {
        return await sendNewMessage(chatId,
            "<b>❌ STOCK TIDAK VALID</b>",
            { parse_mode: "HTML" }
        );
    }

    try {
        const productId = generateProductId(name);
        
        let fileData = {
            fileId: '',
            fileName: '',
            fileType: '',
            textContent: ''
        };

        if (msg.reply_to_message.document) {
            const document = msg.reply_to_message.document;
            const fileStream = bot.getFileStream(document.file_id);
            const chunks = [];
            for await (const chunk of fileStream) {
                chunks.push(chunk);
            }
            const fileBuffer = Buffer.concat(chunks);
            const uploadsDir = path.join(__dirname, 'database', 'uploads');
            if (!fs.existsSync(uploadsDir)) {
                fs.mkdirSync(uploadsDir, { recursive: true });
            }
            const fileName = `${productId}_${Date.now()}${path.extname(document.file_name || '.bin')}`;
            const filePath = path.join(uploadsDir, fileName);
            fs.writeFileSync(filePath, fileBuffer);
            
            fileData.filePath = filePath;
            fileData.fileId = document.file_id;
            fileData.fileName = document.file_name || fileName;
            fileData.fileType = 'document';
            
        } else if (msg.reply_to_message.photo) {
            const photo = msg.reply_to_message.photo[msg.reply_to_message.photo.length - 1];
            const fileStream = bot.getFileStream(photo.file_id);
            const chunks = [];
            for await (const chunk of fileStream) {
                chunks.push(chunk);
            }
            const fileBuffer = Buffer.concat(chunks);
            const uploadsDir = path.join(__dirname, 'database', 'uploads');
            if (!fs.existsSync(uploadsDir)) {
                fs.mkdirSync(uploadsDir, { recursive: true });
            }
            const fileName = `${productId}_${Date.now()}.jpg`;
            const filePath = path.join(uploadsDir, fileName);
            fs.writeFileSync(filePath, fileBuffer);
            
            fileData.filePath = filePath;
            fileData.fileId = photo.file_id;
            fileData.fileName = fileName;
            fileData.fileType = 'photo';
            
        } else if (msg.reply_to_message.text) {
            const uploadsDir = path.join(__dirname, 'database', 'uploads');
            if (!fs.existsSync(uploadsDir)) {
                fs.mkdirSync(uploadsDir, { recursive: true });
            }
            const fileName = `${productId}_${Date.now()}.txt`;
            const filePath = path.join(uploadsDir, fileName);
            const sanitizedText = msg.reply_to_message.text.substring(0, 50000);
            fs.writeFileSync(filePath, sanitizedText);
        
            fileData.filePath = filePath;
            fileData.fileId = 'text';
            fileData.fileName = fileName;
            fileData.fileType = 'text';
            fileData.textContent = sanitizedText;
        }

        const productDB = loadDataProduct();
        
        const existingProduct = Object.values(productDB.products).find(p => p.buyCode.toLowerCase() === code.toLowerCase());
        if (existingProduct) {
            return await sendNewMessage(chatId,
                `<b>❌ KODE SUDAH DIGUNAKAN</b>\n\nKode <code>${code}</code> sudah digunakan oleh produk lain.`,
                { parse_mode: "HTML" }
            );
        }

        productDB.products[productId] = {
            id: productId,
            name: name,
            price: price,
            stock: stock,
            buyCode: code,
            desc: description,
            fileData: fileData,
            type: 'digital',
            createdAt: new Date().toISOString(),
            status: stock > 0 ? 'active' : 'out_of_stock'
        };

        const saved = saveDataProduct(productDB);

        if (!saved) {
            throw new Error('Gagal menyimpan produk');
        }

        await notifyChannelNewProduct(name, price, stock, description, code);

        await sendNewMessage(chatId,
            `<b>✅ PRODUK BERHASIL DITAMBAHKAN!</b>

<b>Nama:</b> ${name}
<b>Harga:</b> ${formatCurrency(price)}
<b>Stock:</b> ${stock}
<b>Kode:</b> <code>${code}</code>
<b>Deskripsi:</b> ${description}
<b>File:</b> ${fileData.fileName} (${fileData.fileType})
<b>ID Produk:</b> <code>${productId}</code>

<b>🎯 User bisa beli dengan:</b>
<code>/buy ${code}</code> atau tombol di menu produk`,
            {
                parse_mode: "HTML",
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🛒 Lihat Produk", callback_data: "menu_products" }]
                    ]
                }
            }
        );

    } catch (error) {
        await sendNewMessage(chatId,
            `<b>❌ GAGAL MENAMBAH PRODUK</b>\n\nError: ${error.message}`,
            { parse_mode: "HTML" }
        );
    }
});

bot.onText(/^\/cariuser(?:\s+(.+))?$/, async (msg, match) => {
    const chatId = msg.chat.id;
    const userId = msg.from.id.toString();
    
    if (!owner_ids.includes(userId)) {
        await sendNewMessage(chatId,
            "<b>❌ No Permission</b>",
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    const searchQuery = match[1] ? match[1].trim() : null;
    
    if (!searchQuery) {
        await sendNewMessage(chatId,
`<b>🔍 CARI USER</b>

<b>Format:</b> <code>/cariuser [username/id]</code>

<b>Contoh:</b>
<code>/cariuser 123456789</code>
<code>/cariuser @username</code>
<code>/cariuser username</code>

<b>Catatan:</b>
• Username bisa dengan @ atau tanpa
• ID berupa angka user Telegram
• Akan mencari di database bot`,
            { parse_mode: 'HTML' }
        );
        return;
    }
    
    const processingMsg = await sendNewMessage(chatId,
        "<b>🔍 Mencari user...</b>",
        { parse_mode: 'HTML' }
    );
    
    try {
        const data = loadData();
        const balances = loadBalances();
        const transactions = loadTransactions();
        
        let targetUser = null;
        let targetUserId = null;
        let foundBy = '';
        
        const cleanSearchQuery = searchQuery.replace('@', '').toLowerCase();
        
        if (/^\d+$/.test(cleanSearchQuery)) {
            targetUserId = cleanSearchQuery;
            foundBy = 'ID';
        } else {
            foundBy = 'Username';
        }
        
        const allUsers = data.users || [];
        
        for (const uid of allUsers) {
            const userIdStr = String(uid);
            
            if (foundBy === 'ID' && userIdStr === targetUserId) {
                targetUserId = userIdStr;
                break;
            }
            
            if (foundBy === 'Username') {
                try {
                    const user = await bot.getChat(userIdStr);
                    const username = user.username ? user.username.toLowerCase() : '';
                    
                    if (username === cleanSearchQuery) {
                        targetUserId = userIdStr;
                        break;
                    }
                } catch (error) {
                    continue;
                }
            }
        }
        
        if (!targetUserId) {
            await editMessage(chatId, processingMsg.message_id, null,
`<b>❌ USER TIDAK DITEMUKAN</b>

Pencarian: <code>${searchQuery}</code>
Metode: ${foundBy}

<b>⚠️ CATATAN:</b>
1. User harus pernah menggunakan bot
2. Username harus sesuai di Telegram
3. ID harus benar`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        let userInfo = {};
        try {
            const user = await bot.getChat(targetUserId);
            userInfo = {
                id: user.id,
                first_name: user.first_name || 'Tidak ada',
                last_name: user.last_name || '',
                username: user.username ? `@${user.username}` : 'Tidak ada',
                is_bot: user.is_bot || false
            };
        } catch (error) {
            userInfo = {
                id: targetUserId,
                first_name: 'Tidak diketahui',
                last_name: '',
                username: 'Tidak diketahui',
                is_bot: false
            };
        }
        
        const userBalance = getUserBalance(targetUserId) || 0;
        
        const userPoints = royaltySystem.getUserPoints(targetUserId);
        
        const allOrders = transactions.nokos_orders || [];
        const userOrders = allOrders.filter(order => 
            String(order.userId) === String(targetUserId)
        );
        
        const successfulOrders = userOrders.filter(order => {
            const status = order.status || order.data?.status;
            const otpReceived = order.data?.otp_received === true;
            const otpCode = order.data?.otp_code;
            
            return (
                status === 'success' || 
                status === 'completed' ||
                otpReceived ||
                (otpCode && otpCode !== '-' && otpCode !== '')
            );
        });
        
        const allDeposits = [
            ...(transactions.rumahotp_deposits || []),
            ...(transactions.khafa_deposits || [])
        ];
        
        const userDeposits = allDeposits.filter(deposit => 
            String(deposit.userId) === String(targetUserId)
        );
        
        const successfulDeposits = userDeposits.filter(deposit => {
            const status = deposit.status || deposit.data?.status;
            return (
                status === 'success' || 
                status === 'paid' ||
                deposit.data?.status === 'success' ||
                deposit.data?.status === 'paid'
            );
        });
        
        const totalDepositAmount = successfulDeposits.reduce((sum, deposit) => {
            const amount = deposit.data?.saldo_didapat || 
                          deposit.data?.amount || 
                          deposit.data?.total || 
                          0;
            return sum + (Number(amount) || 0);
        }, 0);
        
        const totalOrderAmount = successfulOrders.reduce((sum, order) => {
            return sum + (Number(order.data?.total || order.data?.price || 0));
        }, 0);
        
        const lastOrder = userOrders.length > 0 
            ? new Date(userOrders[userOrders.length - 1].timestamp).toLocaleString('id-ID')
            : 'Belum ada';
        
        const lastDeposit = successfulDeposits.length > 0
            ? new Date(successfulDeposits[successfulDeposits.length - 1].timestamp).toLocaleString('id-ID')
            : 'Belum ada';
        
        const message = `<b>📋 PROFIL USER</b>

<b>👤 INFORMASI USER</b>
• Nama: ${userInfo.first_name} ${userInfo.last_name}
• Username: ${userInfo.username}
• User ID: <code>${userInfo.id}</code>
• Bot: ${userInfo.is_bot ? '✅ Ya' : '❌ Tidak'}

<b>💰 INFORMASI SALDO & POINT</b>
• Saldo: ${formatCurrency(userBalance)}
• Points: ${userPoints.points}
• Total Deposit: ${userPoints.depositCount || 0}x

<b>📊 STATISTIK TRANSAKSI</b>
• Total Order: ${userOrders.length}x
• Order Sukses: ${successfulOrders.length}x
• Total Deposit: ${successfulDeposits.length}x
• Total Deposit Amount: ${formatCurrency(totalDepositAmount)}
• Total Order Amount: ${formatCurrency(totalOrderAmount)}

<b>⏰ AKTIVITAS TERAKHIR</b>
• Order Terakhir: ${lastOrder}
• Deposit Terakhir: ${lastDeposit}

<b>📈 RINCIAN</b>
• Profit dari User: ${formatCurrency(totalDepositAmount - totalOrderAmount)}
• Ratio Order/Saldo: ${userBalance > 0 ? ((totalOrderAmount / userBalance).toFixed(2)) : '0'}`;

        await editMessage(chatId, processingMsg.message_id, null, message, {
            parse_mode: 'HTML',
            reply_markup: {
                inline_keyboard: [
                    [
                        { 
                            text: '🔙 Kembali', 
                            callback_data: 'main_menu' 
                        }
                    ]
                ]
            }
        });
        
    } catch (error) {
        console.error('Error in /cariuser:', error);
        await editMessage(chatId, processingMsg.message_id, null,
`<b>❌ GAGAL MENCARI USER</b>

Error: ${error.message || 'Unknown error'}

Silakan coba lagi dengan parameter yang berbeda.`,
            { parse_mode: 'HTML' }
        );
    }
});

async function showProductsMenu(chatId, userId, messageId, callbackQueryId) {
    const productDB = loadDataProduct();
    const products = Object.values(productDB.products || {});
    
    if (products.length === 0) {
        return await editMessage(chatId, messageId, callbackQueryId,
            `<b>📦 DAFTAR PRODUK</b>

❌ Belum ada produk tersedia

Admin sedang mempersiapkan produk terbaik!`,
            {
                parse_mode: "HTML",
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔙 Menu Utama", callback_data: "main_menu" }]
                    ]
                }
            }
        );
    }

    let message = `<b>🛍️ DAFTAR PRODUK SCRIPT</b>

━━━━━━━━━━━━━━━━━━━

<b>PILIH PRODUK YANG DIINGINKAN</b>
━━━━━━━━━━━━━━━━━━━\n`;

    products.forEach((product, index) => {
        const stockStatus = product.stock > 0 ? `✅ TERSEDIA` : `❌ HABIS`;
        const stockCount = product.stock > 0 ? product.stock : 0;
        
        message += `<b>[ ${index + 1} ] ${product.name}</b>\n`;
        message += `╰┈➤ ${formatCurrency(product.price)}\n`;
        message += `━━━━━━━━━━━━━━━━━━━\n`;
        message += `<b>Deskripsi:</b> ${product.desc}\n`;
        message += `<b>Kode:</b> <code>${product.buyCode}</code>\n`;
        message += `<b>Stok:</b> ${stockStatus} (${stockCount})\n\n`;
    });

    message += `━━━━━━━━━━━━━━━━━━━\n`;
    message += `<b>📋 CARA PEMBELIAN:</b>\n`;
    message += `1. Klik tombol BELI di bawah\n`;
    message += `2. Pilih metode pembayaran\n`;
    message += `3. File akan dikirim otomatis\n`;

    const keyboard = [];
    
    products.forEach((product, index) => {
        if (product.status === 'active' && product.stock > 0) {
            keyboard.push([
                { 
                    text: `🛒 Beli ${product.name}`,
                    callback_data: `buy_${product.buyCode}`
                }
            ]);
        } else {
            keyboard.push([
                { 
                    text: `❌ ${product.name} - Habis`,
                    callback_data: "no_action"
                }
            ]);
        }
    });

    keyboard.push([
        { text: "💰 Deposit", callback_data: "deposit_main" },
        { text: "🔙 Menu Utama", callback_data: "main_menu" }
    ]);

    await editMessage(chatId, messageId, callbackQueryId, message, {
        reply_markup: { inline_keyboard: keyboard },
        parse_mode: "HTML"
    });
}

async function showProductPaymentOptions(chatId, userId, productCode, messageId, callbackQueryId) {
    const productDB = loadDataProduct();
    
    let productFound = null;
    
    for (const product of Object.values(productDB.products)) {
        if (product.buyCode.toLowerCase() === productCode.toLowerCase()) {
            productFound = product;
            break;
        }
    }

    if (!productFound) {
        return await editMessage(chatId, messageId, callbackQueryId,
            `<b>❌ PRODUK TIDAK DITEMUKAN</b>

Kode produk <code>${productCode}</code> tidak ditemukan.`,
            {
                parse_mode: "HTML",
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🛒 Produk Lain", callback_data: "menu_products" }]
                    ]
                }
            }
        );
    }

    if (productFound.stock <= 0) {
        return await editMessage(chatId, messageId, callbackQueryId,
            `<b>❌ STOK HABIS</b>

Produk <b>${productFound.name}</b> sedang tidak tersedia.`,
            {
                parse_mode: "HTML",
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🛒 Produk Lain", callback_data: "menu_products" }]
                    ]
                }
            }
        );
    }

    const userVoucher = getUserVoucher(userId);
    let discountAmount = 0;
    let finalPrice = productFound.price;
    let voucherInfo = '';
    
    if (userVoucher) {
        discountAmount = (productFound.price * userVoucher.discount) / 100;
        finalPrice = productFound.price - discountAmount;
        voucherInfo = `\n🎟️ Diskon Voucher: -${formatCurrency(discountAmount)} (${userVoucher.discount}%)`;
    }

    userSelections.set(userId, {
        step: 'product_payment',
        productCode: productFound.buyCode,
        productId: productFound.id,
        productName: productFound.name,
        productPrice: productFound.price,
        discountAmount: discountAmount,
        finalPrice: finalPrice
    });

    const userBalance = getUserBalance(userId);
    const canUseBalance = userBalance >= finalPrice;

    const message = `<b>🛒 KONFIRMASI PEMBELIAN</b>

━━━━━━━━━━━━━━━━━━━

<b>Produk:</b> ${productFound.name}
<b>Harga Asli:</b> ${formatCurrency(productFound.price)}${voucherInfo}
<b>Harga Final:</b> ${formatCurrency(finalPrice)}
<b>Kode:</b> <code>${productFound.buyCode}</code>
<b>Deskripsi:</b> ${productFound.desc}

━━━━━━━━━━━━━━━━━━━

<b>💳 METODE PEMBAYARAN</b>
• Saldo Bot (${canUseBalance ? '✅ Cukup' : '❌ Kurang'})
• QRIS (Pembayaran instan)

<b>💰 SALDO ANDA</b>
${formatCurrency(userBalance)}
${canUseBalance ? '✅ Cukup untuk membeli dengan saldo' : '❌ Tidak cukup, gunakan QRIS'}

━━━━━━━━━━━━━━━━━━━

<b>📋 KONFIRMASI</b>
Pilih metode pembayaran untuk melanjutkan:`;

    const keyboard = [
        [
            { 
                text: canUseBalance ? "💳 Bayar Saldo" : "❌ Saldo Tidak Cukup", 
                callback_data: canUseBalance ? `pay_product_${productFound.buyCode}_saldo` : "no_action"
            }
        ],
        [
            { 
                text: "📱 Bayar QRIS", 
                callback_data: `pay_product_${productFound.buyCode}_qris`
            }
        ],
        [
            { text: "🔙 Kembali", callback_data: "menu_products" },
            { text: "🏠 Menu Utama", callback_data: "main_menu" }
        ]
    ];

    await editMessage(chatId, messageId, callbackQueryId, message, {
        reply_markup: { inline_keyboard: keyboard },
        parse_mode: "HTML"
    });
}

async function showProductOrderConfirmation(chatId, userId, productCode, paymentMethod, messageId, callbackQueryId) {
    const productDB = loadDataProduct();
    
    let productFound = null;
    
    for (const product of Object.values(productDB.products)) {
        if (product.buyCode.toLowerCase() === productCode.toLowerCase()) {
            productFound = product;
            break;
        }
    }

    if (!productFound) {
        return await editMessage(chatId, messageId, callbackQueryId,
            `<b>❌ PRODUK TIDAK DITEMUKAN</b>`,
            { parse_mode: "HTML" }
        );
    }

    if (productFound.stock <= 0) {
        return await editMessage(chatId, messageId, callbackQueryId,
            `<b>❌ STOK HABIS</b>`,
            { parse_mode: "HTML" }
        );
    }

    const userBalance = getUserBalance(userId);
    const paymentMethodName = paymentMethod === 'saldo' ? 'Saldo Bot' : 'QRIS';
    
    const message = `<b>✅ KONFIRMASI PEMESANAN</b>

━━━━━━━━━━━━━━━━━━━

<b>Produk:</b> ${productFound.name}
<b>Harga:</b> ${formatCurrency(productFound.price)}
<b>Kode:</b> <code>${productFound.buyCode}</code>
<b>Metode:</b> ${paymentMethodName}

━━━━━━━━━━━━━━━━━━━

<b>💰 INFORMASI SALDO</b>
Saldo Anda: ${formatCurrency(userBalance)}
${paymentMethod === 'saldo' ? 
    `Sisa saldo: ${formatCurrency(userBalance - productFound.price)}` : 
    `Total bayar: ${formatCurrency(productFound.price)}`}

━━━━━━━━━━━━━━━━━━━

<b>⚠️ PERHATIAN</b>
• Pastikan data sudah benar
• Pembelian tidak dapat dibatalkan
• File akan dikirim otomatis setelah pembayaran

━━━━━━━━━━━━━━━━━━━

<b>Apakah Anda yakin ingin membeli produk ini?</b>`;

    const keyboard = [
        [
            { 
                text: "✅ Ya, Lanjutkan Pembayaran", 
                callback_data: `confirm_product_${productFound.buyCode}_${paymentMethod}`
            }
        ],
        [
            { 
                text: "❌ Batalkan", 
                callback_data: `pay_product_${productFound.buyCode}_${paymentMethod}`
            }
        ]
    ];

    await editMessage(chatId, messageId, callbackQueryId, message, {
        reply_markup: { inline_keyboard: keyboard },
        parse_mode: "HTML"
    });
}

async function processProductPayment(chatId, userId, productCode, paymentMethod, messageId, callbackQueryId) {
    const productLockKey = `product_pay_${userId}`;
    
    if (balanceLocks.has(productLockKey)) {
        const lockTime = balanceLocks.get(productLockKey);
        if (Date.now() - lockTime < 15000) {
            await editMessage(
                chatId,
                messageId,
                callbackQueryId,
                '<b>⏳ Pembayaran produk sedang diproses...</b>',
                { parse_mode: 'HTML' }
            );
            return;
        } else {
            balanceLocks.delete(productLockKey);
        }
    }
    
    balanceLocks.set(productLockKey, Date.now());

    const productDB = loadDataProduct();

    let productFound = null;
    let productId = null;

    for (const [id, product] of Object.entries(productDB.products)) {
        if (product.buyCode.toLowerCase() === productCode.toLowerCase()) {
            productFound = product;
            productId = id;
            break;
        }
    }

    if (!productFound || productFound.stock <= 0) {
        setTimeout(() => {
            balanceLocks.delete(productLockKey);
        }, 5000);
        return await editMessage(
            chatId,
            messageId,
            callbackQueryId,
            `<b>❌ PRODUK TIDAK TERSEDIA</b>`,
            { parse_mode: "HTML" }
        );
    }

    const userSelection = userSelections.get(userId);
    const discountAmount = userSelection?.discountAmount || 0;
    const finalPrice = userSelection?.finalPrice || productFound.price;

    if (paymentMethod === 'saldo') {
        const productPrice = Number(finalPrice); 
        const additionalFee = Number(product_fee) || 0;
        const totalPrice = productPrice + additionalFee;
        const userBalance = Number(getUserBalance(userId));

        if (isNaN(productPrice) || isNaN(totalPrice)) {
            setTimeout(() => {
                balanceLocks.delete(productLockKey);
            }, 5000);
            return await editMessage(
                chatId,
                messageId,
                callbackQueryId,
                `<b>❌ ERROR HARGA</b>\n\nSilakan ulangi transaksi.`,
                { parse_mode: "HTML" }
            );
        }

        if (userBalance < totalPrice) {
            setTimeout(() => {
                balanceLocks.delete(productLockKey);
            }, 5000);
            return await editMessage(
                chatId,
                messageId,
                callbackQueryId,
`<b>❌ SALDO TIDAK CUKUP</b>

Saldo Anda  : ${formatCurrency(userBalance)}
${discountAmount > 0 ? `Harga Asli : ${formatCurrency(productFound.price)}\nDiskon      : -${formatCurrency(discountAmount)}\n` : ''}Harga Final : ${formatCurrency(productPrice)}
Admin Fee   : ${formatCurrency(additionalFee)}
Total Bayar : ${formatCurrency(totalPrice)}
Kekurangan  : ${formatCurrency(totalPrice - userBalance)}

━━━━━━━━━━━━━━━━━━━

<b>📋 TINDAKAN</b>
Silakan deposit terlebih dahulu.`,
                {
                    parse_mode: "HTML",
                    reply_markup: {
                        inline_keyboard: [
                            [{ text: "💰 Deposit", callback_data: "deposit_main" }],
                            [{ text: "🔙 Kembali", callback_data: `pay_product_${productCode}_qris` }]
                        ]
                    }
                }
            );
        }

        const stockSuccess = await decreaseProductStock(productId);
        if (!stockSuccess) {
            setTimeout(() => {
                balanceLocks.delete(productLockKey);
            }, 5000);
            return await editMessage(
                chatId,
                messageId,
                callbackQueryId,
                `<b>❌ STOK TIDAK TERSEDIA</b>`,
                { parse_mode: "HTML" }
            );
        }

        const deductionSuccess = deductUserBalance(userId, totalPrice);
        if (!deductionSuccess) {
            addUserBalance(userId, totalPrice);
            setTimeout(() => {
                balanceLocks.delete(productLockKey);
            }, 5000);
            return await editMessage(
                chatId,
                messageId,
                callbackQueryId,
                `<b>❌ GAGAL MEMOTONG SALDO</b>`,
                { parse_mode: "HTML" }
            );
        }

        const orderId = `SALDO_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`;

        await notifyOwnerProductCreated(
            userId,
            productFound.name,
            productPrice,
            totalPrice,
            orderId,
            productFound.buyCode,
            discountAmount
        );
        
        await notifyChannelProductSuccess(
            userId,
            productFound,
            orderId,
            productPrice
        );

        const discountInfo = discountAmount > 0 ? 
            `\n🎟️ Diskon Voucher: -${formatCurrency(discountAmount)}` : '';

        await editMessage(chatId, messageId, callbackQueryId,
            `<b>✅ PEMBAYARAN BERHASIL</b>

━━━━━━━━━━━━━━━━━━━

<b>Produk:</b> ${productFound.name}
<b>Harga Asli:</b> ${formatCurrency(productFound.price)}${discountInfo}
<b>Harga Final:</b> ${formatCurrency(productPrice)}
<b>Kode:</b> <code>${productFound.buyCode}</code>
<b>Order ID:</b> <code>#${orderId}</code>

━━━━━━━━━━━━━━━━━━━

<b>💰 SALDO SEKARANG</b>
${formatCurrency(getUserBalance(userId))}

━━━━━━━━━━━━━━━━━━━

<b>🔄 Mengirim file...</b>`,
            { 
                parse_mode: "HTML",
                reply_markup: {
                    inline_keyboard: [
                        [
                            { text: "🛒 Belanja Lagi", callback_data: "menu_products" },
                            { text: "🏠 Menu Utama", callback_data: "main_menu" }
                        ]
                    ]
                }
            }
        );
        
        setTimeout(() => {
            transactionAutoBackup();
        }, 2000);

        await sendProductFileToUser(chatId, userId, productFound, orderId);

        setTimeout(() => {
            balanceLocks.delete(productLockKey);
        }, 5000);
        return;
    }

    if (paymentMethod === 'qris') {
        const reffId = `PROD_${productFound.buyCode}_${userId}_${Date.now()}`;

        userSelections.set(userId, {
            step: 'product_qris_payment',
            productCode: productFound.buyCode,
            productId,
            productName: productFound.name,
            productPrice: finalPrice,
            discountAmount: discountAmount,
            reffId
        });

        await editMessage(
            chatId,
            messageId,
            callbackQueryId,
            `<b>🔄 Membuat pembayaran QRIS...</b>`,
            { parse_mode: "HTML" }
        );

        try {
            const productPrice = Number(finalPrice); 
            const additionalFee = Number(product_fee) || 0;
            const gatewayFee = 71; 
            const totalFee = additionalFee + gatewayFee;
            const totalToGateway = productPrice + totalFee;

            if (isNaN(totalToGateway)) {
                throw new Error('Total pembayaran tidak valid');
            }

            const depositResult = await khafaService.createDeposit(
                reffId,
                totalToGateway
            );

            if (!depositResult || !depositResult.success) {
                throw new Error(depositResult?.message || 'Gagal membuat pembayaran');
            }

            const depositData = depositResult.data;
            const khafaDepositId = depositData.id;

            productDB.orders[khafaDepositId] = {
                id: khafaDepositId,
                reff_id: reffId,
                user_id: userId,
                product_id: productId,
                product_name: productFound.name,
                original_price: productFound.price,
                discount_amount: discountAmount,
                discounted_price: productPrice,
                additional_fee: additionalFee,
                gateway_fee: gatewayFee,
                total_fee: totalFee,
                total_price: totalToGateway,
                khafa_nominal: depositData.nominal || totalToGateway,
                khafa_fee: gatewayFee,
                khafa_get_balance: depositData.get_balance || productPrice,
                payment_method: 'qris',
                status: 'pending',
                created_at: new Date().toISOString(),
                delivered: false,
                qris_data: {
                    qr_string: depositData.qr_string,
                    qr_image: depositData.qr_image
                }
            };

            saveDataProduct(productDB);

            const discountInfo = discountAmount > 0 ? 
                `\n💎 Diskon Voucher: -${formatCurrency(discountAmount)}` : '';

            const message = `<b>💰 PEMBAYARAN PRODUK VIA QRIS</b>

━━━━━━━━━━━━━━━━━━━

<b>Produk:</b> ${productFound.name}
<b>Harga Asli:</b> ${formatCurrency(productFound.price)}${discountInfo}
<b>Harga Final:</b> ${formatCurrency(productPrice)}
<b>Fee Gateway:</b> ${formatCurrency(gatewayFee)}
<b>Admin Fee:</b> ${formatCurrency(additionalFee)}
<b>Total Bayar:</b> ${formatCurrency(totalToGateway)}
<b>ID Order:</b> <code>${khafaDepositId}</code>

━━━━━━━━━━━━━━━━━━━

<b>📋 CARA BAYAR</b>
1. Scan QR di bawah
2. Bayar sesuai nominal
3. File dikirim otomatis

<b>⏰ Batas waktu: 20 menit</b>`;

            const keyboard = {
                inline_keyboard: [
                    [{ text: "🔍 Cek Status", callback_data: `check_product_status_${khafaDepositId}` }],
                    [{ text: "❌ Batalkan", callback_data: `cancel_product_${khafaDepositId}` }],
                    [{ text: "🔙 Kembali", callback_data: "menu_products" }]
                ]
            };

            if (depositData.qr_string) {
                const qrBuffer = await QRCode.toBuffer(depositData.qr_string, {
                    errorCorrectionLevel: 'H',
                    margin: 1,
                    width: 300
                });

                await bot.sendPhoto(chatId, qrBuffer, {
                    caption: message,
                    parse_mode: 'HTML',
                    reply_markup: keyboard
                });

                await bot.deleteMessage(chatId, messageId);
            } else {
                await editMessage(chatId, messageId, callbackQueryId, message, {
                    parse_mode: 'HTML',
                    reply_markup: keyboard
                });
            }

            await notifyOwnerProductCreated(
                userId,
                productFound.name,
                productPrice,
                totalToGateway,
                khafaDepositId,
                productFound.buyCode,
                discountAmount
            );

            setTimeout(() => {
                checkProductPaymentStatus(chatId, khafaDepositId, productId, userId);
            }, 5000);

            setTimeout(() => {
                balanceLocks.delete(productLockKey);
            }, 5000);

        } catch (error) {
            await editMessage(
                chatId,
                messageId,
                callbackQueryId,
`<b>❌ GAGAL MEMBUAT PEMBAYARAN</b>

Error: ${error.message}`,
                {
                    parse_mode: "HTML",
                    reply_markup: {
                        inline_keyboard: [
                            [{ text: "🔄 Coba Lagi", callback_data: `pay_product_${productCode}_qris` }],
                            [{ text: "🔙 Kembali", callback_data: "menu_products" }]
                        ]
                    }
                }
            );
            setTimeout(() => {
                balanceLocks.delete(productLockKey);
            }, 5000);
        }

        return;
    }
    
    setTimeout(() => {
        balanceLocks.delete(productLockKey);
    }, 5000);
}

async function sendProductFileToUser(chatId, userId, product, orderId) {
    try {
        const fileData = product.fileData;
        
        const successMessage = `<b>✅ PEMBAYARAN BERHASIL!</b>

<b>Produk:</b> ${product.name}
<b>Harga:</b> ${formatCurrency(product.price)}
<b>Kode:</b> <code>${product.buyCode}</code>
<b>Order ID:</b> <code>#${orderId}</code>`;

        if (fileData.filePath && fs.existsSync(fileData.filePath)) {
            if (fileData.fileType === 'document') {
                await bot.sendDocument(chatId, fileData.filePath, {
                    caption: successMessage,
                    parse_mode: 'HTML'
                });
            } else if (fileData.fileType === 'photo') {
                await bot.sendPhoto(chatId, fileData.filePath, {
                    caption: successMessage,
                    parse_mode: 'HTML'
                });
            } else if (fileData.fileType === 'text') {
                const content = fs.readFileSync(fileData.filePath, 'utf8');
                await sendNewMessage(chatId,
                    `${successMessage}\n\n<b>📝 Konten:</b>\n<code>${content.substring(0, 1000)}</code>`,
                    { parse_mode: 'HTML' }
                );
            }
        } else if (fileData.fileType === 'text' && fileData.textContent) {
            await sendNewMessage(chatId,
                `${successMessage}\n\n<b>📝 Konten:</b>\n<code>${fileData.textContent.substring(0, 1000)}</code>`,
                { parse_mode: 'HTML' }
            );
        } else {
            throw new Error('File tidak tersedia');
        }

    } catch (fileError) {
        await sendNewMessage(chatId,
`<b>⚠️ FILE TIDAK DAPAT DIKIRIM</b>

<b>Produk:</b> ${product.name}
<b>Kode:</b> <code>${product.buyCode}</code>
<b>Order ID:</b> <code>#${orderId}</code>

Silakan hubungi admin dengan Order ID di atas.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [
                            { 
                                text: "💬 Hubungi Admin", 
                                url: `https://t.me/${usernamelu.replace('@','')}` 
                            }
                        ]
                    ]
                }
            }
        );
    }
}

async function checkProductPaymentStatus(chatId, khafaDepositId, productId, userId) {
    try {
        const statusResult = await khafaService.checkDepositStatus(khafaDepositId);
        
        if (!statusResult) {
            setTimeout(() => {
                checkProductPaymentStatus(chatId, khafaDepositId, productId, userId);
            }, 30000);
            return;
        }

        if (!statusResult.success) {
            const isServerError = statusResult.message?.includes('500') || statusResult.message?.includes('status code 500');
            
            if (isServerError) {
                setTimeout(() => {
                    checkProductPaymentStatus(chatId, khafaDepositId, productId, userId);
                }, 60000);
            } else {
                setTimeout(() => {
                    checkProductPaymentStatus(chatId, khafaDepositId, productId, userId);
                }, 30000);
            }
            return;
        }

        const productDB = loadDataProduct();
        
        let product = productDB.products[productId];
        
        if (!product) {
            const userSelection = userSelections.get(userId);
            if (userSelection && userSelection.productCode) {
                for (const [key, prod] of Object.entries(productDB.products)) {
                    if (prod.buyCode === userSelection.productCode) {
                        product = prod;
                        productId = key;
                        break;
                    }
                }
            }
        }

        if (!product) {
            await sendNewMessage(chatId,
                `<b>❌ PRODUK TIDAK DITEMUKAN</b>

━━━━━━━━━━━━━━━━━━━

Silakan hubungi admin dengan Order ID:
<code>${khafaDepositId}</code>`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: "💬 Hubungi Admin", 
                                    url: `https://t.me/${usernamelu.replace('@','')}` 
                                }
                            ]
                        ]
                    }
                }
            );
            return;
        }

        const statusData = statusResult.data;
        
        if (statusData.status === 'success' || statusData.status === 'paid') {
            product.stock -= 1;
            product.status = product.stock > 0 ? 'active' : 'out_of_stock';
            productDB.products[productId] = product;
    
            if (productDB.orders[khafaDepositId]) {
                productDB.orders[khafaDepositId].status = 'completed';
                productDB.orders[khafaDepositId].updated_at = new Date().toISOString();
                productDB.orders[khafaDepositId].delivered = true;
                productDB.orders[khafaDepositId].khafa_status = statusData.status;
            }
            
            saveDataProduct(productDB);
      
            userSelections.delete(userId);
           
            await notifyChannelProductSuccess(
                userId,
                product,
                khafaDepositId,
                product.price
            );
           
            await sendProductFileToUser(chatId, userId, product, khafaDepositId);
            
        } else if (statusData.status === 'pending') {
            setTimeout(() => {
                checkProductPaymentStatus(chatId, khafaDepositId, productId, userId);
            }, 30000);
            
        } else if (statusData.status === 'expired' || statusData.status === 'failed' || statusData.status === 'cancel') {
            userSelections.delete(userId);
            
            if (productDB.orders[khafaDepositId]) {
                productDB.orders[khafaDepositId].status = statusData.status;
                productDB.orders[khafaDepositId].khafa_status = statusData.status;
                saveDataProduct(productDB);
            }
            
            const statusText = statusData.status === 'expired' ? 'KADALUARSA' : 
                             statusData.status === 'failed' ? 'GAGAL' : 
                             statusData.status === 'cancel' ? 'DIBATALKAN' : statusData.status;
            
            await sendNewMessage(chatId,
                `<b>❌ PEMBAYARAN ${statusText}</b>

━━━━━━━━━━━━━━━━━━━

Order ID: <code>${khafaDepositId}</code>

━━━━━━━━━━━━━━━━━━━

Silakan coba lagi.`,
                {
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { text: "🔄 Coba Lagi", callback_data: "menu_products" },
                                { text: "🏠 Menu Utama", callback_data: "main_menu" }
                            ]
                        ]
                    }
                }
            );
        }
    } catch (error) {
        console.error('Error checking payment status:', error);
        
        setTimeout(() => {
            checkProductPaymentStatus(chatId, khafaDepositId, productId, userId);
        }, 60000);
    }
}

async function handleCancelProductPayment(chatId, khafaDepositId, userId, messageId, callbackQueryId) {
    try {
        try {
            await bot.deleteMessage(chatId, messageId);
        } catch (error) {}
        
        const processingMsg = await sendNewMessage(chatId,
            "<b>🔄 Membatalkan pembayaran...</b>",
            { parse_mode: "HTML" }
        );
        
        const cancelResult = await khafaService.cancelDeposit(khafaDepositId);
        
        try {
            await bot.deleteMessage(chatId, processingMsg.message_id);
        } catch (e) {}
        
        if (cancelResult && cancelResult.success) {
            userSelections.delete(userId);
            
            const productDB = loadDataProduct();
            if (productDB.orders[khafaDepositId]) {
                productDB.orders[khafaDepositId].status = 'cancelled';
                saveDataProduct(productDB);
            }

            await sendNewMessage(chatId,
                `<b>✅ PEMBAYARAN DIBATALKAN</b>

━━━━━━━━━━━━━━━━━━━

<b>🆔 Order ID:</b> <code>${khafaDepositId}</code>

━━━━━━━━━━━━━━━━━━━

Transaksi deposit telah dibatalkan.`,
                {
                    parse_mode: "HTML",
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { text: "🛒 Belanja Lagi", callback_data: "menu_products" },
                                { text: "🏠 Menu Utama", callback_data: "main_menu" }
                            ]
                        ]
                    }
                }
            );
        } else {
            const errorMessage = cancelResult?.message || 'Terjadi kesalahan internal saat membatalkan deposit.';
            const isServerError = errorMessage.includes('500') || errorMessage.includes('status code 500');
            
            if (isServerError) {
                await sendNewMessage(chatId,
                    `<b>⚠️ PERHATIAN</b>

━━━━━━━━━━━━━━━━━━━

Gagal terhubung ke server pembayaran.

<b>🆔 Order ID:</b> <code>${khafaDepositId}</code>

━━━━━━━━━━━━━━━━━━━

<b>📋 TINDAKAN</b>
1. Deposit akan otomatis expired dalam 20 menit
2. Silakan buat order baru nanti
3. Hubungi CS jika saldo terpotong

━━━━━━━━━━━━━━━━━━━

<b>⏰ STATUS</b>
Pembayaran akan kadaluarsa otomatis.`,
                    { 
                        parse_mode: "HTML",
                        reply_markup: {
                            inline_keyboard: [
                                [
                                    { text: "🛒 Belanja Lagi", callback_data: "menu_products" }
                                ],
                                [
                                    { text: "💬 CS", url: `https://t.me/${usernamelu.replace('@','')}` }
                                ]
                            ]
                        }
                    }
                );
            } else {
                await sendNewMessage(chatId,
                    `<b>❌ GAGAL MEMBATALKAN</b>

━━━━━━━━━━━━━━━━━━━

${errorMessage}`,
                    { 
                        parse_mode: "HTML",
                        reply_markup: {
                            inline_keyboard: [
                                [
                                    { text: "🔄 Coba Lagi", callback_data: `cancel_product_${khafaDepositId}` }
                                ]
                            ]
                        }
                    }
                );
            }
        }
    } catch (error) {
        await sendNewMessage(chatId,
            `<b>❌ ERROR SISTEM</b>

━━━━━━━━━━━━━━━━━━━

${error.message || 'Terjadi kesalahan sistem'}

━━━━━━━━━━━━━━━━━━━

<b>🆔 Order ID:</b> <code>${khafaDepositId}</code>

━━━━━━━━━━━━━━━━━━━

Silakan hubungi CS untuk bantuan.`,
            { 
                parse_mode: "HTML",
                reply_markup: {
                    inline_keyboard: [
                        [
                            { text: "💬 CS", url: `https://t.me/${usernamelu.replace('@','')}` }
                        ]
                    ]
                }
            }
        );
    }
}

async function showMainMenu(chatId, userId, user, messageId = null) {
  try {
    userSelections.delete(userId);
    balanceCache.delete(userId.toString());

    const userBalance = getUserBalance(userId);
    const pointsData = royaltySystem.getUserPoints(userId);   
    const botInfo = await bot.getMe();
    const data = loadData();
    const transactions = loadTransactions();
    const totalUsers = data.users?.length || 0;
    const allOrders = transactions.nokos_orders || [];
    const successfulOrders = allOrders.filter(o => {
    const status = o.status || o.data?.status;
    const otpReceived = o.data?.otp_received === true;
    const otpCode = o.data?.otp_code;
      
      return (
        status === 'success' || 
        status === 'completed' ||
        otpReceived ||
        (otpCode && otpCode !== '-' && otpCode !== '') ||
        (o.data?.otp_received === true)
      );
    });

    const allDeposits = [
      ...(transactions.rumahotp_deposits || []),
      ...(transactions.khafa_deposits || [])
    ];
    
    const successfulDeposits = allDeposits.filter(deposit => {
      const status = deposit.status || deposit.data?.status;
      return (
        status === 'success' || 
        status === 'paid' ||
        deposit.data?.status === 'success' ||
        deposit.data?.status === 'paid'
      );
    });
    
    const totalDeposits = successfulDeposits.length;
    const totalOrders = successfulOrders.length;
    const username = user.username ? `@${user.username}` : 'tidak ada';
    const firstName = user.first_name || 'User';
    const botUsername = botInfo.username; 
    const botFirstName = botInfo.first_name; 
    const statsCacheKey = 'global_stats';
    const statsCache = {
      orders: totalOrders,
      deposits: totalDeposits,
      users: totalUsers,
      timestamp: Date.now()
    };
    
    const CACHE_TTL = 5 * 60 * 1000;     
    const message = `
Halo <a href="tg://user?id=${user.id}">${firstName}</a> 👋
<a href="https://t.me/${botUsername}">${botFirstName}</a> siap membantumu order nokos dan berbagai produk digital lainnya!

🛍️ <b>HannStore || Auto Order Nokos</b>

👤<b>PROFIL ANDA</b>
Nama: ${firstName}
ID: <code>${userId}</code>
Username: ${username}
Saldo: ${formatCurrency(userBalance)}
Points: ${pointsData.points}

📊 <b>STATISTIK BOT</b>
Total User: ${totalUsers}
Deposit Sukses: ${totalDeposits}x

📋 <b>Syarat dan ketentuan!.</b>
<a href="https://telegra.ph/PENYEBAB-KODE-OTP-SUSAH--TIDAK-MASUK-12-18">BACA DI SINI</a> ketentuanya!.
`;

const keyboard = [
    [
        { text: "🛒 Beli Nokos", callback_data: "nokos_menu" },
        { text: "💰 Topup Saldo", callback_data: "deposit_main" }
    ],
    [
        { text: "🛍️ Beli Script", callback_data: "menu_products" },
        { text: "🎁 Royalty Point", callback_data: "points_menu" }
    ],
    [
        { text: "📜 Riwayat", callback_data: "history_menu" }, 
        { text: "🎟️ Voucher Saya", callback_data: "voucher_menu" }
    ]
];

if (owner_ids.includes(userId.toString())) {
    keyboard.push([
        { text: '👑 Owner Menu', callback_data: 'owner_menu' }
    ]);
}

    const options = {
      reply_markup: { inline_keyboard: keyboard },
      parse_mode: 'HTML',
      disable_web_page_preview: true
    };

    if (messageId) {
      await editMessage(chatId, messageId, null, message, options);
    } else {
      await sendNewMessage(chatId, message, options);
    }
    
  } catch (error) {
    console.error('Error in showMainMenu:', error);
  }
}

async function showHistoryMenu(chatId, userId, messageId, callbackQueryId) {
    try {
        const userBalance = getUserBalance(userId);
        const pointsData = royaltySystem.getUserPoints(userId);
        
        const message = `<b>📜 MENU RIWAYAT & RANKING</b>

Saldo Anda: ${formatCurrency(userBalance)}
Poin Anda: ${pointsData.points}

<b>📋 PILIH JENIS RIWAYAT:</b>
Pilih salah satu untuk melihat detail:`;

        const keyboard = [
            [
                { text: "📋 Riwayat Order", callback_data: "order_history" },
                { text: "💰 Riwayat Deposit", callback_data: "deposit_history" }
            ],
            [
                { text: "🏆 Top Saldo", callback_data: "top_saldo_public" },
                { text: "📊 Top Order", callback_data: "top_order_public" }
            ],
            [
                { text: "⭐ Top Point", callback_data: "top_point_public" }
            ],
            [
                { text: "🔙 Menu Utama", callback_data: "main_menu" }
            ]
        ];

        const options = {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        };

        if (messageId) {
            await editMessage(chatId, messageId, callbackQueryId, message, options);
        } else {
            await sendNewMessage(chatId, message, options);
        }
        
    } catch (error) {
        console.error('Error in showHistoryMenu:', error);
        await sendNewMessage(chatId,
            '<b>❌ GAGAL MEMUAT MENU RIWAYAT</b>\n\nSilakan coba lagi nanti.',
            { parse_mode: 'HTML' }
        );
    }
}

async function showTopSaldoPublic(chatId, userId, messageId, callbackQueryId) {
    try {
        const balances = loadBalances();
        const allUsers = Object.entries(balances)
            .sort((a, b) => b[1] - a[1])
            .slice(0, 10);
        
        if (allUsers.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId,
                `<b>🏆 TOP 10 SALDO TERTINGGI</b>
                
Belum ada user dengan saldo.`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        let message = `<b>🏆 TOP 10 SALDO TERTINGGI</b>\n\n`;
        
        for (let i = 0; i < allUsers.length; i++) {
            const [userId, balance] = allUsers[i];
            const medal = i === 0 ? '🥇' : i === 1 ? '🥈' : i === 2 ? '🥉' : `${i + 1}.`;
            
            try {
                const user = await bot.getChat(userId);
                const username = user.username ? `@${user.username}` : user.first_name || `User ${userId}`;
                
                message += `${medal} ${username}\n`;
                message += `   Saldo: ${formatCurrency(balance)}\n\n`;
                
            } catch {
                message += `${medal} User ${userId}\n`;
                message += `   Saldo: ${formatCurrency(balance)}\n\n`;
            }
        }
        
        const userBalance = getUserBalance(userId);
        const userRank = Object.entries(balances)
            .sort((a, b) => b[1] - a[1])
            .findIndex(([id]) => id === userId.toString()) + 1;
        
        message += `<b>📊 POSISI ANDA:</b>\n`;
        message += `Peringkat: ${userRank > 0 ? userRank : '-'}\n`;
        message += `Saldo: ${formatCurrency(userBalance)}\n`;
        
        const keyboard = [
            [{ text: "📜 Menu Riwayat", callback_data: "history_menu" }],
            [{ text: "🔙 Menu Utama", callback_data: "main_menu" }]
        ];

        await editMessage(chatId, messageId, callbackQueryId, message, { 
            parse_mode: 'HTML',
            reply_markup: { inline_keyboard: keyboard },
            disable_web_page_preview: true 
        });
        
    } catch (error) {
        console.error('Error in showTopSaldoPublic:', error);
        await editMessage(chatId, messageId, callbackQueryId,
            `<b>❌ GAGAL MEMUAT DATA TOP SALDO</b>\n\nSilakan coba lagi nanti.`,
            { parse_mode: 'HTML' }
        );
    }
}

async function showTopOrderPublic(chatId, userId, messageId, callbackQueryId) {
    try {
        const transactions = loadTransactions();
        const allOrders = transactions.nokos_orders || [];
        const userOrderCount = {};
        allOrders.forEach(order => {
            const userId = order.userId || order.data?.userId;
            if (userId) {
                userOrderCount[userId] = (userOrderCount[userId] || 0) + 1;
            }
        });
        
        const sortedUsers = Object.entries(userOrderCount)
            .sort((a, b) => b[1] - a[1])
            .slice(0, 10);
        
        if (sortedUsers.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId,
                `<b>📊 TOP 10 ORDER TERBANYAK</b>
                
Belum ada order dari user.`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        let message = `<b>📊 TOP 10 ORDER TERBANYAK</b>\n\n`;
        
        for (let i = 0; i < sortedUsers.length; i++) {
            const [userId, count] = sortedUsers[i];
            const medal = i === 0 ? '🥇' : i === 1 ? '🥈' : i === 2 ? '🥉' : `${i + 1}.`;
            
            try {
                const user = await bot.getChat(userId);
                const username = user.username ? `@${user.username}` : user.first_name || `User ${userId}`;
                
                message += `${medal} ${username}\n`;
                message += `   Total Order: ${count}x\n\n`;
                
            } catch {
                message += `${medal} User ${userId}\n`;
                message += `   Total Order: ${count}x\n\n`;
            }
        }
        
        const userOrders = userOrderCount[userId.toString()] || 0;
        const userRank = sortedUsers.findIndex(([id]) => id === userId.toString()) + 1;
        
        message += `<b>📊 POSISI ANDA:</b>\n`;
        message += `Peringkat: ${userRank > 0 ? userRank : '-'}\n`;
        message += `Total Order: ${userOrders}x\n`;
        
        const keyboard = [
            [{ text: "📜 Menu Riwayat", callback_data: "history_menu" }],
            [{ text: "🔙 Menu Utama", callback_data: "main_menu" }]
        ];

        await editMessage(chatId, messageId, callbackQueryId, message, { 
            parse_mode: 'HTML',
            reply_markup: { inline_keyboard: keyboard },
            disable_web_page_preview: true 
        });
        
    } catch (error) {
        console.error('Error in showTopOrderPublic:', error);
        await editMessage(chatId, messageId, callbackQueryId,
            `<b>❌ GAGAL MEMUAT DATA TOP ORDER</b>\n\nSilakan coba lagi nanti.`,
            { parse_mode: 'HTML' }
        );
    }
}

async function showTopPointPublic(chatId, userId, messageId, callbackQueryId) {
    try {
        const leaderboard = royaltySystem.getPointsLeaderboard(10);
        
        if (!leaderboard || leaderboard.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId,
                `<b>⭐ TOP 10 POIN TERTINGGI</b>
                
Belum ada user dengan poin.`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        let message = `<b>⭐ TOP 10 POIN TERTINGGI</b>\n\n`;
        
        for (let i = 0; i < leaderboard.length; i++) {
            const userData = leaderboard[i];
            const medal = i === 0 ? '🥇' : i === 1 ? '🥈' : i === 2 ? '🥉' : `${i + 1}.`;
            
            try {
                const user = await bot.getChat(userData.userId);
                const username = user.username ? `@${user.username}` : user.first_name || `User ${userData.userId}`;
                
                message += `${medal} ${username}\n`;
                message += `   Poin: ${userData.points}\n`;
                message += `   Deposit: ${userData.depositCount || 0}x\n\n`;
                
            } catch {
                message += `${medal} User ${userData.userId}\n`;
                message += `   Poin: ${userData.points}\n`;
                message += `   Deposit: ${userData.depositCount || 0}x\n\n`;
            }
        }
        
        const userPointData = royaltySystem.getUserPoints(userId);
        const userRank = leaderboard.findIndex(data => data.userId === userId.toString()) + 1;
        
        message += `<b>📊 POSISI ANDA:</b>\n`;
        message += `Peringkat: ${userRank > 0 ? userRank : '-'}\n`;
        message += `Poin: ${userPointData.points}\n`;
        message += `Total Deposit: ${userPointData.depositCount || 0}x\n`;
        
        const keyboard = [
            [{ text: "📜 Menu Riwayat", callback_data: "history_menu" }],
            [{ text: "🔙 Menu Utama", callback_data: "main_menu" }]
        ];

        await editMessage(chatId, messageId, callbackQueryId, message, { 
            parse_mode: 'HTML',
            reply_markup: { inline_keyboard: keyboard },
            disable_web_page_preview: true 
        });
        
    } catch (error) {
        console.error('Error in showTopPointPublic:', error);
        await editMessage(chatId, messageId, callbackQueryId,
            `<b>❌ GAGAL MEMUAT DATA TOP POIN</b>\n\nSilakan coba lagi nanti.`,
            { parse_mode: 'HTML' }
        );
    }
}

async function showPointsMenu(chatId, userId, messageId, callbackQueryId) {
    try {
        const pointsData = royaltySystem.getUserPoints(userId);
        const userBalance = getUserBalance(userId);
        
        const message = `<b>🎁 Royalty Point</b>

<b>💰 POINTS ANDA</b>
Points: <b>${pointsData.points}</b>

<b>🎯 CARA DAPAT POINTS</b>
• Deposit 1x = 1 point

<b>💵 TUKAR POINTS</b>
Minimal: ${pointsData.neededPoints} points
Setara: ${formatCurrency(pointsData.redeemValue)}

<b>💰 SALDO</b>
${formatCurrency(userBalance)}`;

        const keyboard = [
            [
                { 
                    text: '💰 Tukar Points', 
                    callback_data: 'redeem_points' 
                }
            ],
            [
                { 
                    text: '🏠 Menu Utama', 
                    callback_data: 'main_menu' 
                }
            ]
        ];

        const options = {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        };

        if (messageId) {
            await editMessage(chatId, messageId, callbackQueryId, message, options);
        } else {
            await sendNewMessage(chatId, message, options);
        }
        
    } catch (error) {
        console.error('Error in showPointsMenu:', error);
        await sendNewMessage(chatId,
            '<b>❌ GAGAL MEMUAT DATA POINTS</b>\n\nSilakan coba lagi nanti.',
            { parse_mode: 'HTML' }
        );
    }
}

async function showVoucherMenu(chatId, userId, messageId, callbackQueryId) {
  try {
    const userVoucher = getUserVoucher(userId);
    
    let voucherInfo = '';
    if (userVoucher) {
      voucherInfo = `<b>🎫 VOUCHER AKTIF</b>
Kode: <code>${userVoucher.code}</code>
Diskon: ${userVoucher.discount}%
Berlaku untuk semua transaksi`;
    } else {
      voucherInfo = `<b>❌ TIDAK ADA VOUCHER</b>
Anda belum mengklaim voucher.`;
    }
    
    const message = `<b>🎟️ MENU VOUCHER</b>

${voucherInfo}

<b>💰 KEUNTUNGAN VOUCHER</b>
• Potongan harga langsung
• Berlaku semua transaksi
• Mudah digunakan

<b>🎯 CARA DAPATKAN</b>
1. Owner membuat voucher
2. Bagikan kode ke user
3. Klaim dengan /claim KODE

<b>📋 MENU</b>
Pilih aksi di bawah:`;

    const keyboard = [];
    
    if (userVoucher) {
      keyboard.push([
        { 
          text: '💰 Cek Diskon', 
          callback_data: 'check_voucher_discount' 
        }
      ]);
    } else {
      keyboard.push([
        { 
          text: '🎫 Klaim Voucher', 
          callback_data: 'show_claim_voucher' 
        }
      ]);
    }
    
    keyboard.push([
      { 
        text: '🔙 Kembali', 
        callback_data: 'main_menu' 
      }
    ]);

    const options = {
      reply_markup: { inline_keyboard: keyboard },
      parse_mode: 'HTML',
      disable_web_page_preview: true
    };

    if (messageId) {
      await editMessage(chatId, messageId, callbackQueryId, message, options);
    } else {
      await sendNewMessage(chatId, message, options);
    }
    
  } catch (error) {
    console.error('Error in showVoucherMenu:', error);
  }
}

async function showClaimVoucherInfo(chatId, userId, messageId, callbackQueryId) {
  const message = `<b>🎫 KLAIM VOUCHER</b>

<b>📋 CARA KLAIM</b>
Ketik: <code>/claim KODE_VOUCHER</code>
Contoh: <code>/claim DISKON50</code>

<b>🔰 PETUNJUK</b>
• Dapatkan kode voucher dari admin
• Satu voucher hanya bisa diklaim sekali
• Voucher berlaku untuk semua transaksi
• Tidak bisa ditransfer ke user lain

<b>🎁 CONTOH KODE</b>
• DISKON10 - Diskon 10%
• SPECIAL20 - Diskon 20%
• PROMO30 - Diskon 30%

<b>⚠️ CATATAN</b>
Pastikan kode voucher benar!`;

  const keyboard = [
    [
      { 
        text: '🔙 Kembali', 
        callback_data: 'voucher_menu' 
      }
    ]
  ];

  const options = {
    reply_markup: { inline_keyboard: keyboard },
    parse_mode: 'HTML',
    disable_web_page_preview: true
  };

  if (messageId) {
    await editMessage(chatId, messageId, callbackQueryId, message, options);
  } else {
    await sendNewMessage(chatId, message, options);
  }
}

async function showVoucherDiscount(chatId, userId, messageId, callbackQueryId) {
  const userVoucher = getUserVoucher(userId);
  
  if (!userVoucher) {
    await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ TIDAK ADA VOUCHER</b>

Anda belum mengklaim voucher.`,
      { parse_mode: 'HTML' }
    );
    return;
  }
  
  const message = `<b>💰 DISKON VOUCHER ANDA</b>

Kode: <code>${userVoucher.code}</code>
Diskon: ${userVoucher.discount}%
Sisa Kuota: ${userVoucher.remaining}

<b>🎯 CONTOH PENGGUNAAN</b>
Harga Rp 10.000 → Diskon ${userVoucher.discount}% = Rp ${userVoucher.discount * 100}
Total Bayar: Rp ${10000 - (userVoucher.discount * 100)}

<b>⚙️ SISTEM OTOMATIS</b>
• Diskon otomatis terhitung
• Tidak perlu input manual
• Berlaku semua transaksi

<b>⚠️ CATATAN</b>
• Voucher aktif sampai digunakan
• Tidak bisa dipindahtangankan
• Satu akun, satu voucher`;

  const keyboard = [
    [
      { 
        text: '🛒 Beli Nokos (Diskon Otomatis)', 
        callback_data: 'nokos_menu' 
      }
    ],
    [
      { 
        text: '🔙 Kembali', 
        callback_data: 'voucher_menu' 
      }
    ]
  ];

  const options = {
    reply_markup: { inline_keyboard: keyboard },
    parse_mode: 'HTML',
    disable_web_page_preview: true
  };

  if (messageId) {
    await editMessage(chatId, messageId, callbackQueryId, message, options);
  } else {
    await sendNewMessage(chatId, message, options);
  }
}

async function showOwnerMenu(chatId, userId, messageId) {
  try {
    if (!owner_ids.includes(userId.toString())) {
      return;
    }

    const message = `<b>💎 OWNER MENU</b>

👤 <b>USER INFO</b>
ID: <code>${userId}</code>
Role: <b>Owner</b>

📋 <b>COMMAND LIST</b>
⬡ /broadcast - Kirim pesan ke semua user
⬡ /stats - Lihat statistik bot
⬡ /setpay - Atur metode pembayaran
⬡ /cariuser - Cari user berdasarkan usernmae/id
⬡ /maintenance - Maintenance mode
⬡ /addsaldo - Tambah saldo user
⬡ /delsaldo - Hapus saldo user
⬡ /topsaldo - Tampilkan saldo user
⬡ /backup - Backup database
⬡ /addproduct - Tambah produk
⬡ /withdraw - Tarik saldo rumah otp
⬡ /addvc - Tambah voucher
⬡ /delvc - Hapus voucher
⬡ /listvc - Tampilkan voucher

📱 <b>PILIH MENU</b>
Gunakan tombol di bawah untuk akses cepat:`;

    const keyboard = [
      [
        { text: "🔙 Kembali", callback_data: "main_menu" }
      ]
    ];

    const options = {
      reply_markup: { inline_keyboard: keyboard },
      parse_mode: 'HTML',
      disable_web_page_preview: true
    };

    if (messageId) {
      await editMessage(chatId, messageId, null, message, options);
    } else {
      await sendNewMessage(chatId, message, options);
    }
    
  } catch (error) {
    console.error('Error in showOwnerMenu:', error);
  }
}

async function redeemUserPoints(chatId, userId, messageId, callbackQueryId) {
    try {
        const pointsData = royaltySystem.getUserPoints(userId);
        const redeemValueFormatted = formatCurrency(pointsData.redeemableCash);
        const neededPoints = pointsData.neededPoints;
        
        if (pointsData.points < neededPoints) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ POINTS TIDAK CUKUP</b>

Points Anda: ${pointsData.points}
Minimal tukar: ${neededPoints} points

Setiap ${neededPoints} points = ${redeemValueFormatted}`,
                {
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { text: '💰 Deposit', callback_data: 'deposit_main' },
                                { text: '🔙 Kembali', callback_data: 'points_menu' }
                            ]
                        ]
                    }
                }
            );
            return;
        }

        const redeemResult = royaltySystem.redeemPoints(userId);
        
        if (redeemResult && redeemResult.success) {
            const cashValue = Number(redeemResult.cashValue) || 0;
            if (cashValue > 0) {
                const success = addUserBalance(userId, cashValue);
                
                if (!success) {
                    await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MENAMBAH SALDO</b>

Silakan coba lagi atau hubungi admin.`,
                        {
                            parse_mode: 'HTML',
                            reply_markup: {
                                inline_keyboard: [
                                    [
                                        { text: '🔙 Kembali', callback_data: 'points_menu' }
                                    ]
                                ]
                            }
                        }
                    );
                    return;
                }
            }
            
            const newBalance = getUserBalance(userId);
            const remainingPoints = redeemResult.remainingPoints || pointsData.points - neededPoints;
            const cashValueFormatted = formatCurrency(redeemResult.cashValue || pointsData.redeemableCash);
            const newBalanceFormatted = formatCurrency(newBalance);
            
            await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ PENUKARAN BERHASIL</b>

Tukar: ${redeemResult.pointsRedeemed || neededPoints} points
Dapat: ${cashValueFormatted}
Sisa Points: ${remainingPoints}
Saldo +: ${cashValueFormatted}

<b>💰 SALDO SEKARANG</b>
${newBalanceFormatted}

<b>📝 INFO</b>
• Hanya bisa tukar ${neededPoints} points sekali klik
• Sisa points: ${remainingPoints}
• Tukar lagi jika masih cukup points`,
                {
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: remainingPoints >= neededPoints ? 
                                        '🔄 Tukar Lagi' : '💰 Deposit Lagi', 
                                    callback_data: remainingPoints >= neededPoints ? 
                                        'redeem_points' : 'deposit_main' 
                                },
                                { text: '🔙 Menu', callback_data: 'points_menu' }
                            ]
                        ]
                    }
                }
            );
        } else {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MENUKAR</b>

${redeemResult?.error || 'Terjadi kesalahan sistem'}

Silakan coba lagi.`,
                {
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { text: '🔄 Coba Lagi', callback_data: 'redeem_points' }
                            ],
                            [
                                { text: '🔙 Kembali', callback_data: 'points_menu' }
                            ]
                        ]
                    }
                }
            );
        }
    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ TERJADI KESALAHAN</b>

${error.message || 'Silakan coba lagi nanti.'}`,
            {
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [
                            { text: '🔄 Coba Lagi', callback_data: 'redeem_points' }
                        ],
                        [
                            { text: '🔙 Kembali', callback_data: 'points_menu' }
                        ]
                    ]
                }
            }
        );
    }
}

async function showServerList(chatId, userId, numberId, countryName, messageId, callbackQueryId) {
    try {
        let userSelection = userSelections.get(userId);
        
        if (!userSelection || !userSelection.serviceId) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ SESI TIDAK LENGKAP</b>

Status: Data Tidak Lengkap
Error: Data layanan tidak ditemukan

<b>⚠️ TINDAKAN</b>
Silakan pilih layanan dari awal.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔙 Mulai Dari Awal', 
                                callback_data: 'nokos_menu' 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
 
        await editMessage(chatId, messageId, callbackQueryId,
            '<b>⏳ Memuat data...</b>',
            { parse_mode: 'HTML' }
        );
        
        const countriesData = await api.getCountries(userSelection.serviceId);
        if (!countriesData || !countriesData.success) {
            await editMessage(chatId, messageId, null,
`<b>❌ GAGAL MEMUAT DATA</b>

Status: Gagal Terhubung
Error: Tidak dapat mengambil data server

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔄 Coba Lagi', 
                                callback_data: `nokos_service_${userSelection.serviceId}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        const countries = countriesData.data || [];
        const selectedCountry = countries.find(c => c.number_id == numberId);
        
        if (!selectedCountry || !selectedCountry.pricelist || selectedCountry.pricelist.length === 0) {
            await editMessage(chatId, messageId, null,
`<b>❌ SERVER TIDAK TERSEDIA</b>

Negara: ${countryName}
Status: Tidak Ada Server

<b>⚠️ INFORMASI</b>
Tidak ada server tersedia untuk negara ini.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '📍 Pilih Negara Lain', 
                                callback_data: `nokos_service_${userSelection.serviceId}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        let servers = selectedCountry.pricelist;
        servers.sort((a, b) => a.price - b.price);

        userSelection.step = 'nokos_server';
        userSelection.numberId = numberId;
        userSelection.countryName = countryName;
        userSelection.countryData = selectedCountry;
        userSelections.set(userId, userSelection);
        
        const countryCode = getCountryCode(selectedCountry.iso_code);
        const countryEmoji = countryCode || '🌍';
        
        const message = `<b>${countryEmoji} PILIH SERVER - ${countryName.toUpperCase()}</b>

Layanan: ${userSelection.serviceName}
Negara: ${countryEmoji} ${countryName}
Stok: ${selectedCountry.stock_total} nomor
Server: ${servers.length} tersedia

<b>📋 DAFTAR SERVER TERSEDIA</b>
Pilih server untuk melanjutkan:`;

        const keyboard = [];
        const buttonsPerRow = 3;
        const maxButtons = 15;
        const serversToShow = servers.slice(0, maxButtons);
        
        for (let i = 0; i < serversToShow.length; i += buttonsPerRow) {
            const row = [];
            for (let j = 0; j < buttonsPerRow; j++) {
                if (serversToShow[i + j]) {
                    const server = serversToShow[i + j];
                    const serverNumber = i + j + 1;
                    const buttonText = `🖥️ S${serverNumber}`;
                    const callbackData = `nokos_server_${server.provider_id}_${server.price}_${server.rate}_${server.stock}`;
                    
                    row.push({ 
                        text: buttonText, 
                        callback_data: callbackData
                    });
                }
            }
            if (row.length > 0) {
                keyboard.push(row);
            }
        }
        
        keyboard.push([
            { 
                text: '🔙 Kembali', 
                callback_data: `nokos_service_${userSelection.serviceId}` 
            },
            { 
                text: '🏠 Menu', 
                callback_data: 'main_menu' 
            }
        ]);

        await editMessage(chatId, messageId, null, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });
        
    } catch (error) {
        console.error('Error in showServerList:', error);
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ TERJADI KESALAHAN</b>

Status: Error Sistem
Error: Terjadi kesalahan teknis

<b>⚠️ TINDAKAN</b>
Silakan coba lagi atau hubungi CS.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔄 Coba Lagi', 
                            callback_data: `nokos_service_${userSelections.get(userId)?.serviceId || 'nokos_menu'}` 
                        }],
                        [{ 
                            text: '💬 CS', 
                            url: `https://t.me/${usernamelu.replace('@','')}` 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function showServerListEnhanced(chatId, userId, numberId, countryName, messageId, callbackQueryId, startIndex = 0) {
    try {
        let userSelection = userSelections.get(userId);
        
        if (!userSelection || !userSelection.serviceId) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ SESI TIDAK LENGKAP</b>

Status: Data Tidak Lengkap

<b>⚠️ TINDAKAN</b>
Silakan pilih layanan dari awal.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔙 Mulai Dari Awal', 
                                callback_data: 'nokos_menu' 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        await editMessage(chatId, messageId, callbackQueryId,
            '<b>⏳ Memuat data server...</b>',
            { parse_mode: 'HTML' }
        );
        
        const countriesData = await api.getCountries(userSelection.serviceId);
        if (!countriesData || !countriesData.success) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MEMUAT DATA</b>

Status: Gagal Terhubung

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔄 Coba Lagi', 
                                callback_data: `nokos_service_${userSelection.serviceId}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        const countries = countriesData.data || [];
        const selectedCountry = countries.find(c => c.number_id == numberId);
        
        if (!selectedCountry || !selectedCountry.pricelist || selectedCountry.pricelist.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ SERVER TIDAK TERSEDIA</b>

Negara: ${countryName}
Status: Tidak Ada Server

<b>⚠️ INFORMASI</b>
Tidak ada server tersedia untuk negara ini.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '📍 Pilih Negara Lain', 
                                callback_data: `nokos_service_${userSelection.serviceId}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        let servers = selectedCountry.pricelist;
        servers.sort((a, b) => a.price - b.price);

        userSelection.step = 'nokos_server';
        userSelection.numberId = numberId;
        userSelection.countryName = countryName;
        userSelection.countryData = selectedCountry;
        userSelections.set(userId, userSelection);
        
        const flagEmoji = getFlagEmoji(selectedCountry.iso_code) || '🌍';
        const serversPerPage = 9;
        const currentPage = Math.floor(startIndex / serversPerPage) + 1;
        const totalPages = Math.ceil(servers.length / serversPerPage);
        const displayStart = (currentPage - 1) * serversPerPage;
        const displayEnd = displayStart + serversPerPage;
        const displayServers = servers.slice(displayStart, displayEnd);
        
        const message = `<b>${flagEmoji} DAFTAR SERVER - ${countryName.toUpperCase()}</b>

Layanan: ${userSelection.serviceName}
Negara: ${flagEmoji} ${countryName}
Stok: ${selectedCountry.stock_total} nomor
Total Server: ${servers.length} server
Halaman: ${currentPage}/${totalPages}

<b>📋 PILIHAN SERVER</b>
Klik tombol untuk memilih server:`;

        const rowsPerGrid = 3;
        for (let row = 0; row < rowsPerGrid; row++) {
            const rowStart = row * rowsPerGrid;
            const rowServers = displayServers.slice(rowStart, rowStart + rowsPerGrid);
            
            if (rowServers.length === 0) break;

            message += `<b>`;
            rowServers.forEach((server, colIndex) => {
                const serverNumber = displayStart + rowStart + colIndex + 1;
                message += `S${serverNumber}  `;
            });
            message += `</b>\n`;
            
            rowServers.forEach((server, colIndex) => {
                message += `💰 ${formatCurrency(server.price)}  `;
            });
            message += `\n`;

            rowServers.forEach((server, colIndex) => {
                const rateEmoji = server.rate >= 90 ? '✅' : server.rate >= 70 ? '⚠️' : '❌';
                message += `${rateEmoji} ${server.rate}%  `;
            });
            message += `\n\n`;
        }
        
        const keyboard = [];
        
        for (let row = 0; row < rowsPerGrid; row++) {
            const rowStart = row * rowsPerGrid;
            const rowServers = displayServers.slice(rowStart, rowStart + rowsPerGrid);
            
            if (rowServers.length === 0) break;
            
            const buttonRow = [];
            rowServers.forEach((server, colIndex) => {
                const serverNumber = displayStart + rowStart + colIndex + 1;
                const buttonText = `🖥️ S${serverNumber}`;
                const callbackData = `nokos_server_${server.provider_id}_${server.price}_${server.rate}_${server.stock}`;
                
                buttonRow.push({ 
                    text: buttonText, 
                    callback_data: callbackData 
                });
            });
            
            if (buttonRow.length > 0) {
                keyboard.push(buttonRow);
            }
        }
        
        const navButtons = [];
        
        if (currentPage > 1) {
            navButtons.push({ 
                text: '<', 
                callback_data: `server_prev_${numberId}_${encodeURIComponent(countryName)}_${displayStart - serversPerPage}` 
            });
        } else {
            navButtons.push({ 
                text: '<', 
                callback_data: 'no_action' 
            });
        }
        
        navButtons.push({ 
            text: `📄 ${currentPage}/${totalPages}`, 
            callback_data: 'no_action' 
        });
        
        if (currentPage < totalPages) {
            navButtons.push({ 
                text: '>', 
                callback_data: `server_next_${numberId}_${encodeURIComponent(countryName)}_${displayStart + serversPerPage}` 
            });
        } else {
            navButtons.push({ 
                text: '>', 
                callback_data: 'no_action' 
            });
        }
        
        keyboard.push(navButtons);
        
        keyboard.push([
            { 
                text: '🔙 Kembali', 
                callback_data: `nokos_service_${userSelection.serviceId}` 
            },
            { 
                text: '🏠 Menu', 
                callback_data: 'main_menu' 
            }
        ]);
        
        await editMessage(chatId, messageId, callbackQueryId, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });
        
    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ TERJADI KESALAHAN</b>

Status: Error Sistem

<b>⚠️ TINDAKAN</b>
Silakan coba lagi atau hubungi CS.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔄 Coba Lagi', 
                            callback_data: `nokos_service_${userSelections.get(userId)?.serviceId || 'nokos_menu'}` 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function showOperatorMenu(chatId, userId, numberId, price, countryName, messageId, callbackQueryId) {
    try {
        const userSelection = userSelections.get(userId);
        if (!userSelection) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ SESI TIDAK DITEMUKAN</b>

Status: Sesi Kadaluarsa

<b>⚠️ TINDAKAN</b>
Silakan mulai kembali dari menu utama.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🏠 Menu', 
                                callback_data: 'main_menu' 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        userSelection.step = 'nokos_operator';
        userSelection.numberId = numberId;
        userSelection.price = price;
        userSelection.countryName = countryName;
        userSelections.set(userId, userSelection);

        await editMessage(chatId, messageId, callbackQueryId,
            '<b>⏳ Memuat data...</b>',
            { parse_mode: 'HTML' }
        );

        const countriesData = await api.getCountries(userSelection.serviceId);
        
        if (!countriesData || !countriesData.success) {
            await editMessage(chatId, messageId, null,
`<b>❌ GAGAL MENDAPATKAN DATA</b>

Status: Gagal Terhubung

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔄 Coba Lagi', 
                                callback_data: `nokos_server_list_${numberId}_${encodeURIComponent(countryName)}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const countries = countriesData.data || [];
        const selectedCountry = countries.find(c => c.number_id == numberId);
        
        if (!selectedCountry) {
            await editMessage(chatId, messageId, null,
`<b>❌ DATA NEGARA TIDAK DITEMUKAN</b>

Negara: ${countryName}
Status: Tidak Ditemukan

<b>⚠️ INFORMASI</b>
Data negara tidak ditemukan di sistem.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔙 Kembali', 
                                callback_data: `nokos_service_${userSelection.serviceId}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        if (!selectedCountry.pricelist || selectedCountry.pricelist.length === 0) {
            await editMessage(chatId, messageId, null,
`<b>❌ OPERATOR TIDAK TERSEDIA</b>

Negara: ${countryName}
Status: Tidak Ada Operator

<b>⚠️ INFORMASI</b>
Tidak ada operator tersedia untuk negara ini.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '📍 Pilih Negara Lain', 
                                callback_data: `nokos_service_${userSelection.serviceId}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const providerId = userSelection.providerId || selectedCountry.pricelist[0].provider_id;
        userSelection.providerId = providerId;
        userSelections.set(userId, userSelection);

        const operatorsData = await api.getOperators(selectedCountry.name, providerId);
        
        if (!operatorsData || !operatorsData.success) {
            const errorMsg = operatorsData?.message || 'Gagal terhubung ke server operator';
            await editMessage(chatId, messageId, null,
`<b>❌ GAGAL MENDAPATKAN OPERATOR</b>

Status: Gagal Terhubung
Error: ${errorMsg}

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔙 Kembali', 
                                callback_data: `nokos_server_list_${numberId}_${encodeURIComponent(countryName)}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const operators = operatorsData.data || [];
        
        if (operators.length === 0) {
            await editMessage(chatId, messageId, null,
`<b>❌ BELUM ADA OPERATOR</b>

Negara: ${countryName}
Status: Tidak Ada Operator

<b>⚠️ INFORMASI</b>
Belum ada operator yang tersedia untuk negara ini.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '📍 Pilih Negara Lain', 
                                callback_data: `nokos_service_${userSelection.serviceId}` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const flagEmoji = getFlagEmoji(selectedCountry.iso_code) || '🌍';
        const formattedPrice = formatCurrency(price);
        
        const message = `<b>📡 PILIH OPERATOR - ${countryName.toUpperCase()}</b>

Layanan: ${userSelection.serviceName}
Negara: ${flagEmoji} ${countryName}
Harga: ${formattedPrice}
Operator: ${operators.length} tersedia

<b>📋 DAFTAR OPERATOR</b>
Pilih operator untuk melanjutkan:`;

        const keyboard = [];

        for (let i = 0; i < operators.length; i += 2) {
            const row = [];
            
            if (operators[i]) {
                const op = operators[i];
                const buttonText = op.name ? `${op.name.substring(0, 12)}` : `Operator ${i+1}`;
                row.push({ 
                    text: `📱 ${buttonText}`, 
                    callback_data: `nokos_operator_${op.id}_${providerId}_${price}` 
                });
            }
            
            if (operators[i + 1]) {
                const op = operators[i + 1];
                const buttonText = op.name ? `${op.name.substring(0, 12)}` : `Operator ${i+2}`;
                row.push({ 
                    text: `📱 ${buttonText}`, 
                    callback_data: `nokos_operator_${op.id}_${providerId}_${price}` 
                });
            }
            
            if (row.length > 0) {
                keyboard.push(row);
            }
        }

        keyboard.push([
            { 
                text: '🔙 Kembali', 
                callback_data: `nokos_server_list_${numberId}_${encodeURIComponent(countryName)}` 
            },
            { 
                text: '🏠 Menu', 
                callback_data: 'main_menu' 
            }
        ]);

        await editMessage(chatId, messageId, null, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });

    } catch (error) {
        console.error('Error in showOperatorMenu:', error);
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ TERJADI KESALAHAN</b>

Status: Error Sistem

<b>⚠️ TINDAKAN</b>
Silakan coba lagi atau hubungi CS.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔄 Coba Lagi', 
                            callback_data: `nokos_server_list_${numberId}_${encodeURIComponent(countryName)}` 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function showNokosMenu(chatId, userId, messageId, callbackQueryId) {
  try {
    const servicesData = await getServicesCached();
    
    if (!servicesData || !servicesData.success) {
      await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MENDAPATKAN LAYANAN</b>

Status: Gagal Terhubung

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
        { 
          parse_mode: 'HTML',
          disable_web_page_preview: true 
        }
      );
      return;
    }

    const services = servicesData.data;

    const message = `<b>📱 MENU LAYANAN NOKOS</b>

Total Layanan: ${services.length}

<b>📋 LAYANAN POPULER</b>
Pilih layanan untuk order nomor OTP:`;

    const popularServiceNames = ['whatsapp', 'telegram', 'instagram', 'facebook', 'gojek', 'gopay', 'ovo', 'dana', 'tiktok', 'twitter'];
    const popularServices = services.filter(service => 
        popularServiceNames.some(name => service.service_name.toLowerCase().includes(name))
    ).slice(0, 6);

    const keyboard = [];
    
    for (let i = 0; i < popularServices.length; i += 2) {
        const row = [];
        
        if (popularServices[i]) {
            const serviceName = popularServices[i].service_name;
            const buttonText = serviceName.length > 12 ? serviceName.substring(0, 12) + '...' : serviceName;
            row.push({ 
                text: `📱 ${buttonText}`, 
                callback_data: `nokos_service_${popularServices[i].service_code}` 
            });
        }
        
        if (popularServices[i + 1]) {
            const serviceName = popularServices[i + 1].service_name;
            const buttonText = serviceName.length > 12 ? serviceName.substring(0, 12) + '...' : serviceName;
            row.push({ 
                text: `📱 ${buttonText}`, 
                callback_data: `nokos_service_${popularServices[i + 1].service_code}` 
            });
        }
        
        if (row.length > 0) {
            keyboard.push(row);
        }
    }

    keyboard.push([
        { 
            text: '🔍 Cari Layanan', 
            callback_data: 'search_services_input' 
        },
        { 
            text: '📋 Semua Layanan', 
            callback_data: 'nokos_all_services' 
        }
    ]);

    keyboard.push([
        { 
            text: '🏠 Menu', 
            callback_data: 'main_menu' 
        },
        { 
            text: '🔄 Refresh', 
            callback_data: 'nokos_menu' 
        }
    ]);

    await editMessage(chatId, messageId, callbackQueryId, message, {
      reply_markup: { inline_keyboard: keyboard },
      parse_mode: 'HTML',
      disable_web_page_preview: true
    });

  } catch (error) {
    await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MEMUAT MENU</b>

Status: Error Sistem

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
      { 
        parse_mode: 'HTML',
        reply_markup: {
          inline_keyboard: [
            [{ 
              text: '🔄 Coba Lagi', 
              callback_data: 'nokos_menu' 
            }]
          ]
        },
        disable_web_page_preview: true
      }
    );
  }
}

async function showAllServices(chatId, userId, messageId, callbackQueryId, page = 0) {
    try {
        const servicesData = await getServicesCached();
        
        if (!servicesData || !servicesData.success) {
            await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MENDAPATKAN LAYANAN</b>

Status: Gagal Terhubung

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    disable_web_page_preview: true 
                }
            );
            return;
        }

        const allServices = servicesData.data || [];
        
        if (allServices.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ TIDAK ADA LAYANAN</b>

Status: Tidak Ada Layanan

<b>⚠️ INFORMASI</b>
Tidak ada layanan yang tersedia.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔙 Kembali', 
                                callback_data: 'nokos_menu' 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const itemsPerPage = 10;
        const totalPages = Math.ceil(allServices.length / itemsPerPage);
        
        if (page < 0) page = 0;
        if (page >= totalPages) page = totalPages - 1;

        const startIndex = page * itemsPerPage;
        const endIndex = startIndex + itemsPerPage;
        const currentServices = allServices.slice(startIndex, endIndex);

        const message = `<b>📋 SEMUA LAYANAN</b>

Total: ${allServices.length} layanan
Halaman: ${page + 1}/${totalPages}

<b>📱 DAFTAR LAYANAN</b>
Pilih layanan untuk order nomor OTP:`;
        
        const keyboard = [];
        
        for (let i = 0; i < currentServices.length; i += 2) {
            const row = [];
            
            if (currentServices[i]) {
                const service = currentServices[i];
                const serviceName = service.service_name;
                const buttonText = serviceName.length > 12 ? serviceName.substring(0, 12) + '...' : serviceName;
                row.push({ 
                    text: `📱 ${buttonText}`, 
                    callback_data: `nokos_service_${service.service_code}` 
                });
            }
            
            if (currentServices[i + 1]) {
                const service = currentServices[i + 1];
                const serviceName = service.service_name;
                const buttonText = serviceName.length > 12 ? serviceName.substring(0, 12) + '...' : serviceName;
                row.push({ 
                    text: `📱 ${buttonText}`, 
                    callback_data: `nokos_service_${service.service_code}` 
                });
            }
            
            if (row.length > 0) {
                keyboard.push(row);
            }
        }

        const navButtons = [];
        
        if (totalPages > 1) {
            if (page > 0) {
                navButtons.push({ 
                    text: '<', 
                    callback_data: `all_services_page_${page - 1}` 
                });
            }

            if (page < totalPages - 1) {
                navButtons.push({ 
                    text: '>', 
                    callback_data: `all_services_page_${page + 1}` 
                });
            }
            
            if (navButtons.length > 0) {
                keyboard.push(navButtons);
            }
        }

        keyboard.push([
            { 
                text: '🔍 Cari Layanan', 
                callback_data: 'search_services_input' 
            },
            { 
                text: '🔙 Kembali', 
                callback_data: 'nokos_menu' 
            }
        ]);

        await editMessage(chatId, messageId, callbackQueryId, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });

    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MEMUAT LAYANAN</b>

Status: Error Sistem

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔄 Coba Lagi', 
                            callback_data: 'nokos_menu' 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function showSearchResults(chatId, userId, searchQuery, messageId, callbackQueryId, page = 0) {
    try {
        const servicesData = await getServicesCached();
        
        if (!servicesData || !servicesData.success) {
            await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MENDAPATKAN LAYANAN</b>

Status: Gagal Terhubung

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    disable_web_page_preview: true 
                }
            );
            return;
        }

        const allServices = servicesData.data || [];
        const searchResults = searchServices(searchQuery, allServices);
        
        if (searchResults.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId, 
`<b>🔍 HASIL PENCARIAN</b>

Kata kunci: "${searchQuery}"
Hasil: Tidak ditemukan

<b>📋 TINDAKAN</b>
Coba kata kunci lain atau lihat semua layanan.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔍 Cari Lain', 
                                    callback_data: 'search_services_input' 
                                },
                                { 
                                    text: '📋 Semua Layanan', 
                                    callback_data: 'nokos_all_services' 
                                }
                            ],
                            [
                                { 
                                    text: '🔙 Kembali', 
                                    callback_data: 'nokos_menu' 
                                }
                            ]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const itemsPerPage = 10;
        const totalPages = Math.ceil(searchResults.length / itemsPerPage);
        
        if (page < 0) page = 0;
        if (page >= totalPages) page = totalPages - 1;

        const startIndex = page * itemsPerPage;
        const endIndex = startIndex + itemsPerPage;
        const currentResults = searchResults.slice(startIndex, endIndex);

        const message = `<b>🔍 HASIL PENCARIAN</b>

Kata kunci: "${searchQuery}"
Ditemukan: ${searchResults.length} layanan
Halaman: ${page + 1}/${totalPages}

<b>📱 LAYANAN YANG COCOK</b>
Pilih layanan untuk order nomor OTP:`;
        
        const keyboard = [];
        
        for (let i = 0; i < currentResults.length; i += 2) {
            const row = [];
            
            if (currentResults[i]) {
                const service = currentResults[i];
                const serviceName = service.service_name;
                const buttonText = serviceName.length > 12 ? serviceName.substring(0, 12) + '...' : serviceName;
                row.push({ 
                    text: `📱 ${buttonText}`, 
                    callback_data: `nokos_service_${service.service_code}` 
                });
            }
            
            if (currentResults[i + 1]) {
                const service = currentResults[i + 1];
                const serviceName = service.service_name;
                const buttonText = serviceName.length > 12 ? serviceName.substring(0, 12) + '...' : serviceName;
                row.push({ 
                    text: `📱 ${buttonText}`, 
                    callback_data: `nokos_service_${service.service_code}` 
                });
            }
            
            if (row.length > 0) {
                keyboard.push(row);
            }
        }

        const navButtons = [];
        
        if (totalPages > 1) {
            if (page > 0) {
                navButtons.push({ 
                    text: '<', 
                    callback_data: `search_results_${encodeURIComponent(searchQuery)}_${page - 1}` 
                });
            }

            if (page < totalPages - 1) {
                navButtons.push({ 
                    text: '>', 
                    callback_data: `search_results_${encodeURIComponent(searchQuery)}_${page + 1}` 
                });
            }
            
            if (navButtons.length > 0) {
                keyboard.push(navButtons);
            }
        }

        keyboard.push([
            { 
                text: '🔍 Cari Lain', 
                callback_data: 'search_services_input' 
            },
            { 
                text: '📋 Semua Layanan', 
                callback_data: 'nokos_all_services' 
            }
        ]);

        keyboard.push([
            { 
                text: '🔙 Menu Layanan', 
                callback_data: 'nokos_menu' 
            }
        ]);

        await editMessage(chatId, messageId, callbackQueryId, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });

    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MENCARI LAYANAN</b>

Status: Error Sistem

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔄 Coba Lagi', 
                            callback_data: 'nokos_menu' 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function cancelOrder(chatId, userId, orderId, messageId, callbackQueryId) {
  const orderLockKey = `order_cancel_${orderId}`;
  
  if (balanceLocks.has(orderLockKey)) {
    const lockTime = balanceLocks.get(orderLockKey);
    if (Date.now() - lockTime < 10000) {
      await bot.answerCallbackQuery(callbackQueryId, {
        text: '⏳ Order sedang diproses',
        show_alert: true
      });
      return;
    } else {
      balanceLocks.delete(orderLockKey);
    }
  }
  
  balanceLocks.set(orderLockKey, Date.now());

  try {
    await editMessage(chatId, messageId, callbackQueryId,
      '<b>⏳ Membatalkan order...</b>',
      { parse_mode: 'HTML' }
    );

    const transactions = loadTransactions();
    let order = transactions.nokos_orders?.find(o => o.id === orderId || o.data?.orderId === orderId);
    
    if (!order) {
      const orderData = await api.getOrderStatus(orderId);
      
      if (orderData && orderData.success) {
        await editMessage(chatId, messageId, callbackQueryId,
          '<b>🔍 Order ditemukan di sistem, memproses...</b>',
          { parse_mode: 'HTML' }
        );
        
        const otpCode = orderData.data?.otp_code;
        const otpReceived = otpCode && otpCode !== '-' && otpCode !== '' && otpCode !== null;
        
        if (otpReceived) {
          updateTransactionStatus('nokos_orders', orderId, 'completed');
          
          const newTransaction = {
            userId: userId,
            id: orderId,
            data: {
              orderId: orderId,
              phoneNumber: orderData.data?.phone_number || '-',
              otp_code: otpCode,
              otp_received: true,
              status: 'completed',
              total: orderData.data?.total || 0,
              refunded: false,
              processed: true
            },
            timestamp: new Date().toISOString(),
            status: 'completed'
          };
          
          addTransaction('nokos_orders', newTransaction.data);
          
          await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ OTP SUDAH DITERIMA</b>

Kode OTP: <code>${otpCode}</code>
Status: Order sudah selesai
Saldo sudah terpakai.`,
            { parse_mode: 'HTML' }
          );
          setTimeout(() => {
            balanceLocks.delete(orderLockKey);
          }, 5000);
          return;
        }
        
        const orderTime = new Date(orderData.data?.timestamp || Date.now()).getTime();
        const currentTime = Date.now();
        const threeMinutes = 3 * 60 * 1000;

        if (currentTime - orderTime < threeMinutes) {
          const remainingSeconds = Math.ceil((threeMinutes - (currentTime - orderTime)) / 1000);
          const remainingMinutes = Math.floor(remainingSeconds / 60);
          const remainingSecs = remainingSeconds % 60;
          
          await editMessage(chatId, messageId, callbackQueryId,
`<b>⏳ TUNGGU ${remainingMinutes}m ${remainingSecs}s</b>

ID Order: <code>#${orderId}</code>
Status: Masih dalam proses awal

<b>⚠️ MINIMAL 3 MENIT</b>
• Tunggu ${remainingMinutes}m ${remainingSecs}s untuk batalkan
• Auto refund: 20 menit dari order
• Jika OTP tidak masuk, auto refund 100%

<b>📋 TINDAKAN</b>
Silakan tunggu waktu minimum terpenuhi.`,
            { 
              parse_mode: 'HTML',
              reply_markup: {
                inline_keyboard: [
                  [
                    { 
                      text: `🔄 Cek OTP (${remainingMinutes}m)`, 
                      callback_data: `nokos_check_${orderId}` 
                    }
                  ]
                ]
              },
              disable_web_page_preview: true
            }
          );
          setTimeout(() => {
            balanceLocks.delete(orderLockKey);
          }, 5000);
          return;
        }
        
        const cancelResult = await api.setOrderStatus(orderId, 'cancel');
        
        const totalPrice = orderData.data?.total || 0;
        
        if (cancelResult && cancelResult.success) {
          updateTransactionStatus('nokos_orders', orderId, 'cancelled');
          
          if (totalPrice > 0) {
            const success = addUserBalance(userId, totalPrice);
            if (success) {
              await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ REFUND BERHASIL</b>

ID Order: <code>#${orderId}</code>
Jumlah: ${formatCurrency(totalPrice)}
Refund: 100%`,
                { parse_mode: 'HTML' }
              );
              
              setTimeout(async () => {
                const finalCheck = await api.getOrderStatus(orderId);
                if (finalCheck && finalCheck.success) {
                  const finalOtp = finalCheck.data?.otp_code;
                  const hasFinalOtp = finalOtp && finalOtp !== '-' && finalOtp !== '';
                  
                  if (hasFinalOtp) {
                    const transactions = loadTransactions();
                    const orderIndex = transactions.nokos_orders?.findIndex(o => 
                      o.id === orderId || o.data?.orderId === orderId
                    );
                    
                    if (orderIndex !== -1) {
                      transactions.nokos_orders[orderIndex].data.otp_received = true;
                      transactions.nokos_orders[orderIndex].data.otp_code = finalOtp;
                      transactions.nokos_orders[orderIndex].data.status = 'completed';
                      transactions.nokos_orders[orderIndex].data.refunded = false;
                      saveTransactions(transactions);
                      
                      deductUserBalance(userId, totalPrice);
                      
                      await sendNewMessage(chatId,
`<b>⚠️ OTP MASUK SETELAH REFUND</b>

ID Order: <code>#${orderId}</code>
Kode OTP: <code>${finalOtp}</code>
Nomor: ${finalCheck.data?.phone_number}

Status: OTP diterima setelah refund
Saldo dikembalikan: ${formatCurrency(totalPrice)}`,
                        { parse_mode: 'HTML' }
                      );
                    }
                  }
                }
              }, 30000);
            }
          }
        }
        setTimeout(() => {
          balanceLocks.delete(orderLockKey);
        }, 5000);
        return;
      }
      
      await editMessage(chatId, messageId, callbackQueryId,
        '<b>❌ ORDER TIDAK DITEMUKAN</b>',
        { parse_mode: 'HTML' }
      );
      setTimeout(() => {
        balanceLocks.delete(orderLockKey);
      }, 5000);
      return;
    }

    const orderTime = new Date(order.timestamp).getTime();
    const currentTime = Date.now();
    const threeMinutes = 3 * 60 * 1000;

    if (currentTime - orderTime < threeMinutes) {
      const remainingSeconds = Math.ceil((threeMinutes - (currentTime - orderTime)) / 1000);
      const remainingMinutes = Math.floor(remainingSeconds / 60);
      const remainingSecs = remainingSeconds % 60;
      
      await editMessage(chatId, messageId, callbackQueryId,
`<b>⏳ TUNGGU ${remainingMinutes}m ${remainingSecs}s</b>

ID Order: <code>#${orderId}</code>
Waktu Order: ${new Date(orderTime).toLocaleTimeString('id-ID')}
Status: ⏳ Masih dalam proses awal

<b>⚠️ MINIMAL 3 MENIT</b>
• Tunggu ${remainingMinutes}m ${remainingSecs}s untuk batalkan`,
        { 
          parse_mode: 'HTML',
          reply_markup: {
            inline_keyboard: [
              [
                { 
                  text: `🔄 Cek OTP (${remainingMinutes}m)`, 
                  callback_data: `nokos_check_${orderId}` 
                }
              ]
            ]
          },
          disable_web_page_preview: true
        }
      );
      setTimeout(() => {
        balanceLocks.delete(orderLockKey);
      }, 5000);
      return;
    }

    const statusResult = await api.getOrderStatus(orderId);
    
    let otpReceived = false;
    let otpCode = null;
    
    if (statusResult && statusResult.success && statusResult.data) {
      const orderData = statusResult.data;
      otpCode = orderData.otp_code;
      otpReceived = otpCode && otpCode !== '-' && otpCode !== '' && otpCode !== null;
    }

    const dbOtpReceived = order?.data?.otp_received === true;
    const dbOtpCode = order?.data?.otp_code;
    
    if (otpReceived || dbOtpReceived) {
        const actualOtpCode = otpCode || dbOtpCode || '-';
        
        updateTransactionStatus('nokos_orders', orderId, 'completed');

        if (statusResult && statusResult.success && statusResult.data && statusResult.data.otp_code) {
            const orderIndex = transactions.nokos_orders.findIndex(o => o.id === orderId || o.data?.orderId === orderId);
            if (orderIndex !== -1) {
                transactions.nokos_orders[orderIndex].data.otp_code = statusResult.data.otp_code;
                transactions.nokos_orders[orderIndex].data.otp_received = true;
                transactions.nokos_orders[orderIndex].data.processed = true;
                saveTransactions(transactions);
            }
        }
        
        await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ OTP DITERIMA - ORDER SELESAI</b>

ID Order: <code>#${orderId}</code>
Nomor: <b>${order.data?.phoneNumber || '-'}</b>
Kode OTP: <code>${actualOtpCode}</code>
Status: ✅ OTP Sudah Diterima

<b>⚠️ INFORMASI</b>
• Saldo sudah terpakai
• Tidak dapat direfund`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [
                            { 
                                text: '🏠 Menu', 
                                callback_data: 'main_menu' 
                            }
                        ]
                    ]
                },
                disable_web_page_preview: true
            }
        );
        setTimeout(() => {
          balanceLocks.delete(orderLockKey);
        }, 5000);
        return;
    }
    
    const cancelResult = await api.setOrderStatus(orderId, 'cancel');

    updateTransactionStatus('nokos_orders', orderId, 'cancelled');

    const totalPrice = order.data?.total || 0;
    
    if (totalPrice > 0 && !otpReceived && !dbOtpReceived) {
      if (!order.data?.refunded && !order.data?.processed) {
        const success = addUserBalance(userId, totalPrice);
        
        if (success) {
          if (transactions.nokos_orders) {
            const orderIndex = transactions.nokos_orders.findIndex(o => o.id === orderId || o.data?.orderId === orderId);
            if (orderIndex !== -1) {
              transactions.nokos_orders[orderIndex].data.refunded = true;
              transactions.nokos_orders[orderIndex].data.processed = true;
              saveTransactions(transactions);
            }
          }
          
          await sendRefundNotification(chatId, orderId, totalPrice, 'manual');
          
          setTimeout(async () => {
            const finalCheck = await api.getOrderStatus(orderId);
            if (finalCheck && finalCheck.success) {
              const finalOtp = finalCheck.data?.otp_code;
              const hasFinalOtp = finalOtp && finalOtp !== '-' && finalOtp !== '';
              
              if (hasFinalOtp) {
                const transactions = loadTransactions();
                const orderIndex = transactions.nokos_orders?.findIndex(o => 
                  o.id === orderId || o.data?.orderId === orderId
                );
                
                if (orderIndex !== -1) {
                  transactions.nokos_orders[orderIndex].data.otp_received = true;
                  transactions.nokos_orders[orderIndex].data.otp_code = finalOtp;
                  transactions.nokos_orders[orderIndex].data.status = 'completed';
                  transactions.nokos_orders[orderIndex].data.refunded = false;
                  saveTransactions(transactions);
                  
                  deductUserBalance(userId, totalPrice);
                  
                  await sendNewMessage(chatId,
`<b>⚠️ OTP MASUK SETELAH REFUND</b>

ID Order: <code>#${orderId}</code>
Kode OTP: <code>${finalOtp}</code>
Nomor: ${finalCheck.data?.phone_number}

Status: OTP diterima setelah refund
Saldo dikembalikan: ${formatCurrency(totalPrice)}`,
                    { parse_mode: 'HTML' }
                  );
                }
              }
            }
          }, 30000);
        }
      }
    }

    await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ ORDER DIBATALKAN</b>

ID Order: <code>#${orderId}</code>
Nomor: <b>${order.data?.phoneNumber || '-'}</b>
Status: Dibatalkan
Refund: ${formatCurrency(totalPrice)} (100%)`,
      { 
        parse_mode: 'HTML',
        reply_markup: {
          inline_keyboard: [
            [
              { 
                text: '🏠 Menu', 
                callback_data: 'main_menu' 
              }
            ]
          ]
        },
        disable_web_page_preview: true
      }
    );
    
    setTimeout(() => {
      balanceLocks.delete(orderLockKey);
    }, 5000);
    
  } catch (error) {
    await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MEMBATALKAN ORDER</b>
Status: Error Sistem
Error: ${error.message || 'Tidak dapat terhubung ke server'}

<b>⚠️ TINDAKAN DIBUTUHKAN</b>
Silakan coba lagi dalam 1 menit.`,
      { 
        parse_mode: 'HTML',
        disable_web_page_preview: true 
      }
    );
    setTimeout(() => {
      balanceLocks.delete(orderLockKey);
    }, 5000);
  }
}

bot.on('message', async (msg) => {

    if (!msg || !msg.from) return;
    
    const chatId = msg.chat.id;
    const userId = msg.from.id.toString();
    const text = msg.text || ''; 
    
    if (msg.from.is_bot || text.startsWith('/')) return;
    
    const userSelection = userSelections.get(userId);
    
    if (userSelection && userSelection.step === 'search_country') {
    const searchQuery = text.trim();
    const serviceId = userSelection.serviceId;
    
    if (searchQuery.length < 2) {
        await sendNewMessage(chatId,
`<b>❌ KATA KUNCI TERLALU PENDEK</b>

Minimal 2 karakter
Anda: "${searchQuery}" (${searchQuery.length} karakter)

<b>🔰 SILAKAN COBA LAGI</b>
Masukkan kata kunci yang lebih spesifik:`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [
                            { 
                                text: '🔙 Batalkan Pencarian', 
                                callback_data: `nokos_service_${serviceId}` 
                            }
                        ]
                    ]
                }
            }
        );
        return;
    }
    
    try {
        await bot.deleteMessage(chatId, msg.message_id);
    } catch (error) {}
    
    userSelections.delete(userId);
    
    const processingMsg = await sendNewMessage(chatId,
`<b>🔍 MENCARI NEGARA...</b>

Kata kunci: "${searchQuery}"
Status: Mencari...`,
        { parse_mode: 'HTML' }
    );
    
    await showSearchCountryResults(chatId, userId, serviceId, searchQuery, processingMsg.message_id, null);
    
    return;
}

    if (userSelection && userSelection.step === 'search_services') {
        const searchQuery = text.trim();
        
        if (searchQuery.length < 2) {
            await sendNewMessage(chatId,
`<b>❌ KATA KUNCI TERLALU PENDEK</b>

Minimal 2 karakter
Anda: "${searchQuery}" (${searchQuery.length} karakter)

<b>🔰 SILAKAN COBA LAGI</b>
Masukkan kata kunci yang lebih spesifik:`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔙 Batalkan Pencarian', 
                                    callback_data: 'nokos_menu' 
                                }
                            ]
                        ]
                    }
                }
            );
            return;
        }
        
        try {
            await bot.deleteMessage(chatId, msg.message_id);
        } catch (error) {}
        
        userSelections.delete(userId);
        
        const processingMsg = await sendNewMessage(chatId,
`<b>🔍 MENCARI LAYANAN...</b>

Kata kunci: "${searchQuery}"
Status: Mencari...`,
            { parse_mode: 'HTML' }
        );
        
        await showSearchResults(chatId, userId, searchQuery, processingMsg.message_id, null);
        
        return;
    }
    
    if (userSelection && userSelection.step === 'custom_deposit_waiting_amount') {
        const cleanText = text.replace(/[^\d]/g, '');
        const amount = parseInt(cleanText);
        
        if (isNaN(amount) || amount < 2000) {
            await sendNewMessage(chatId,
`<b>❌ JUMLAH TIDAK VALID</b>

Minimal: Rp 2.000
Anda: ${text || 'Tidak ada input'}

<b>⚠️ FORMAT YANG BENAR</b>
Angka saja (contoh: 25000)

<b>🔰 SILAKAN COBA LAGI</b>
Masukkan jumlah yang valid:`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔙 Kembali ke Menu Deposit', 
                                    callback_data: 'deposit_main' 
                                }
                            ]
                        ]
                    }
                }
            );
            userSelections.delete(userId); 
            return;
        }
        
        if (amount > 5000000) {
            await sendNewMessage(chatId,
`<b>❌ JUMLAH TERLALU BESAR</b>

Maksimal: Rp 5.000.000
Anda: Rp ${amount.toLocaleString('id-ID')}

<b>🔰 SILAKAN COBA LAGI</b>
Masukkan jumlah yang valid:`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔙 Kembali ke Menu Deposit', 
                                    callback_data: 'deposit_main' 
                                }
                            ]
                        ]
                    }
                }
            );
            userSelections.delete(userId); 
            return;
        }
        
        userSelections.delete(userId); 
        
        try {
            await bot.deleteMessage(chatId, msg.message_id);
        } catch (error) {}

        const processingMsg = await sendNewMessage(chatId,
`<b>⏳ MEMPROSES DEPOSIT CUSTOM</b>

Jumlah: Rp ${amount.toLocaleString('id-ID')}
Status: Membuat QR Code...`,
            { parse_mode: 'HTML' }
        );

        await handleDeposit(chatId, userId, amount); 
        
        try {
            await bot.deleteMessage(chatId, processingMsg.message_id);
        } catch (error) {}
        
        return;
    }
    
    if (userSelection && userSelection.step === 'rumahotp_deposit_amount') {
        const cleanText = text.replace(/[^\d]/g, '');
        const amount = parseInt(cleanText);
        
        if (isNaN(amount) || amount < 2000) {
            await sendNewMessage(chatId,
`<b>❌ JUMLAH TIDAK VALID</b>

Minimal: Rp 2.000
Anda: ${text}

<b>⚠️ FORMAT YANG BENAR</b>
Angka saja (contoh: 25000)`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔙 Kembali ke Menu Deposit', 
                                    callback_data: 'deposit_main' 
                                }
                            ]
                        ]
                    }
                }
            );
            userSelections.delete(userId);
            return;
        }
        
        if (amount > 5000000) {
            await sendNewMessage(chatId,
`<b>❌ JUMLAH TERLALU BESAR</b>

Maksimal: Rp 5.000.000
Anda: Rp ${amount.toLocaleString('id-ID')}`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔙 Kembali ke Menu Deposit', 
                                    callback_data: 'deposit_main' 
                                }
                            ]
                        ]
                    }
                }
            );
            userSelections.delete(userId);
            return;
        }
        
        userSelections.delete(userId);
        await handleDeposit(chatId, userId, amount);
        return;
    }
});

async function showDepositMenu(chatId, userId, messageId, callbackQueryId) {
    const userBalance = getUserBalance(userId);
    const paymentMethod = getPaymentMethod();
    
    const message = `<b>💰 MENU TOPUP SALDO</b>

User ID: <code>${userId}</code>
Saldo Saat Ini: ${formatCurrency(userBalance)}

<b>📋 INFORMASI TOPUP</b>
Metode: QRIS
Minimal: Rp 2.000
Maksimal: Rp 5.000.000

<b>💰 PILIH NOMINAL</b>
Pilih nominal untuk topup saldo:`;

    userSelections.delete(userId); 
    
    await editMessage(chatId, messageId, callbackQueryId, message, {
        reply_markup: { 
            inline_keyboard: [
                [
                    { 
                        text: '💰 2K', 
                        callback_data: 'deposit_amount_2000' 
                    },
                    { 
                        text: '💰 5K', 
                        callback_data: 'deposit_amount_5000' 
                    },
                    { 
                        text: '💰 10K', 
                        callback_data: 'deposit_amount_10000' 
                    }
                ],
                [
                    { 
                        text: '💰 20K', 
                        callback_data: 'deposit_amount_20000' 
                    },
                    { 
                        text: '💰 50K', 
                        callback_data: 'deposit_amount_50000' 
                    },
                    { 
                        text: '💰 100K', 
                        callback_data: 'deposit_amount_100000' 
                    }
                ],
                [
                    { 
                        text: '💰 200K', 
                        callback_data: 'deposit_amount_200000' 
                    },
                    { 
                        text: '💰 500K', 
                        callback_data: 'deposit_amount_500000' 
                    },
                    { 
                        text: '💰 1 JT', 
                        callback_data: 'deposit_amount_1000000' 
                    }
                ],
                [
                    { 
                        text: '🔢 Custom', 
                        callback_data: 'deposit_custom' 
                    }
                ],
                [
                    { 
                        text: '🔙 Kembali', 
                        callback_data: 'main_menu' 
                    }
                ]
            ] 
        },
        parse_mode: 'HTML',
        disable_web_page_preview: true
    });
}

async function showOtherServices(chatId, userId, messageId, callbackQueryId) {
    try {
        const servicesData = await getServicesCached();
        
        if (!servicesData || !servicesData.success) {
            await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MENDAPATKAN LAYANAN</b>

Status: Gagal Terhubung

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    disable_web_page_preview: true 
                }
            );
            return;
        }

        const services = servicesData.data;

        const popularServiceNames = [
            'whatsapp', 'telegram', 'instagram', 'facebook', 
            'gojek', 'gopay', 'ovo', 'dana', 'tiktok', 'twitter'
        ];
        
        const otherServices = [];
        for (const service of services) {
            const serviceNameLower = service.service_name.toLowerCase();
            let isPopular = false;
            
            for (const popularName of popularServiceNames) {
                if (serviceNameLower.includes(popularName)) {
                    isPopular = true;
                    break;
                }
            }
            
            if (!isPopular) {
                otherServices.push(service);
            }
        }
        
        const displayServices = otherServices.slice(0, 20);

        if (displayServices.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId, 
`<b>📋 LAYANAN LAINNYA</b>

Status: Tidak Ada Layanan

<b>⚠️ INFORMASI</b>
Tidak ada layanan lainnya tersedia.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔙 Kembali', 
                                callback_data: 'nokos_menu' 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const message = `<b>📋 LAYANAN LAINNYA</b>

Total Layanan: ${displayServices.length}

<b>📱 DAFTAR LAYANAN</b>
Pilih layanan untuk order nomor OTP:`;
        
        const keyboard = [];
        
        for (let i = 0; i < displayServices.length; i += 2) {
            const row = [];
            
            if (displayServices[i]) {
                const serviceName = displayServices[i].service_name;
                const buttonText = serviceName.substring(0, 12);
                row.push({ 
                    text: `📱 ${buttonText}`, 
                    callback_data: `nokos_service_${displayServices[i].service_code}` 
                });
            }
            
            if (displayServices[i + 1]) {
                const serviceName = displayServices[i + 1].service_name;
                const buttonText = serviceName.substring(0, 12);
                row.push({ 
                    text: `📱 ${buttonText}`, 
                    callback_data: `nokos_service_${displayServices[i + 1].service_code}` 
                });
            }
            
            if (row.length > 0) {
                keyboard.push(row);
            }
        }

        keyboard.push([
            { 
                text: '🔙 Kembali', 
                callback_data: 'nokos_menu' 
            },
            { 
                text: '🏠 Menu', 
                callback_data: 'main_menu' 
            }
        ]);

        await editMessage(chatId, messageId, callbackQueryId, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });

    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MEMUAT LAYANAN</b>

Status: Error Sistem

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔄 Coba Lagi', 
                            callback_data: 'nokos_menu' 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function showCountryMenu(chatId, userId, serviceId, serviceName, messageId, callbackQueryId, page = 0) {
    try {
        const itemsPerPage = 6; 
        userSelections.set(userId, {
            step: 'nokos_country',
            serviceId: serviceId,
            serviceName: serviceName
        });

        await editMessage(chatId, messageId, callbackQueryId,
            '<b>⏳ Memuat data...</b>',
            { parse_mode: 'HTML' }
        );

        const countriesData = await api.getCountries(serviceId);
        
        if (!countriesData || !countriesData.success) {
            await editMessage(chatId, messageId, null,
`<b>❌ GAGAL MENDAPATKAN NEGARA</b>

Status: Gagal Terhubung

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🔙 Kembali', 
                                callback_data: `nokos_menu` 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const allCountries = countriesData.data || [];
        
        if (allCountries.length === 0) {
            await editMessage(chatId, messageId, null,
`<b>❌ NEGARA TIDAK TERSEDIA</b>

Layanan: ${serviceName}
Status: Tidak Ada Negara

<b>⚠️ INFORMASI</b>
Tidak ada negara tersedia untuk layanan ini.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '📱 Pilih Lain', 
                                callback_data: 'nokos_menu' 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
 
        const indonesiaCountries = [];
        const otherCountries = [];
        
        for (const country of allCountries) {
            const countryNameLower = country.name.toLowerCase();
            if (countryNameLower.includes('indonesia') || countryNameLower.includes('indo')) {
                indonesiaCountries.push(country);
            } else {
                otherCountries.push(country);
            }
        }
        
        otherCountries.sort((a, b) => {
            return a.name.localeCompare(b.name);
        });
        
        const sortedCountries = [...indonesiaCountries, ...otherCountries];

        const totalPages = Math.ceil(sortedCountries.length / itemsPerPage);
        if (page < 0) page = 0;
        if (page >= totalPages) page = totalPages - 1;

        const startIndex = page * itemsPerPage;
        const endIndex = startIndex + itemsPerPage;
        const currentCountries = sortedCountries.slice(startIndex, endIndex);

        const message = `<b>🌍 PILIH NEGARA - ${serviceName.toUpperCase()}</b>

Layanan: ${serviceName}
Total Negara: ${sortedCountries.length}
Halaman: ${page + 1}/${totalPages}

<b>📋 DAFTAR NEGARA</b>
Pilih negara untuk melanjutkan:`;
        
        const keyboard = [];
       
        for (let i = 0; i < currentCountries.length; i += 2) {
            const row = [];
            
            if (currentCountries[i]) {
                const country = currentCountries[i];
                const countryFlag = getFlagEmoji(country.iso_code) || '📍';
                let countryText = country.name;
                if (countryText.length > 10) {
                    countryText = countryText.substring(0, 10);
                }
                
                row.push({ 
                    text: `${countryFlag} ${countryText}`, 
                    callback_data: `nokos_server_list_${country.number_id}_${encodeURIComponent(country.name)}` 
                });
            }
            
            if (currentCountries[i + 1]) {
                const country = currentCountries[i + 1];
                const countryFlag = getFlagEmoji(country.iso_code) || '📍';
                let countryText = country.name;
                if (countryText.length > 10) {
                    countryText = countryText.substring(0, 10);
                }
                
                row.push({ 
                    text: `${countryFlag} ${countryText}`, 
                    callback_data: `nokos_server_list_${country.number_id}_${encodeURIComponent(country.name)}` 
                });
            }
            
            if (row.length > 0) {
                keyboard.push(row);
            }
        }

        keyboard.push([
            { 
                text: '🔍 Cari Negara', 
                callback_data: `search_country_input_${serviceId}` 
            }
        ]);

        const navButtons = [];
        
        if (totalPages > 1) {
            if (page > 0) {
                navButtons.push({ 
                    text: '<', 
                    callback_data: `nokos_country_page_${serviceId}_${page - 1}` 
                });
            }

            if (page < totalPages - 1) {
                navButtons.push({ 
                    text: '>', 
                    callback_data: `nokos_country_page_${serviceId}_${page + 1}` 
                });
            }
            
            if (navButtons.length > 0) {
                keyboard.push(navButtons);
            }
        }

        keyboard.push([
            { 
                text: '🔙 Kembali', 
                callback_data: `nokos_menu` 
            },
            { 
                text: '🏠 Menu', 
                callback_data: 'main_menu' 
            }
        ]);

        await editMessage(chatId, messageId, null, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });

    } catch (error) {
        console.error('Error in showCountryMenu:', error);
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ TERJADI KESALAHAN</b>

Status: Error Sistem

<b>⚠️ TINDAKAN</b>
Silakan coba lagi atau hubungi CS.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔄 Coba Lagi', 
                            callback_data: `nokos_service_${serviceId}` 
                        }],
                        [{ 
                            text: '🏠 Menu', 
                            callback_data: 'main_menu' 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function showSearchCountryResults(chatId, userId, serviceId, searchQuery, messageId, callbackQueryId, page = 0) {
    try {
        const countriesData = await api.getCountries(serviceId);
        
        if (!countriesData || !countriesData.success) {
            await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MENDAPATKAN NEGARA</b>

Status: Gagal Terhubung

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
                { 
                    parse_mode: 'HTML',
                    disable_web_page_preview: true 
                }
            );
            return;
        }

        const allCountries = countriesData.data || [];
        const searchResults = searchCountries(searchQuery, allCountries);
        
        if (searchResults.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId, 
`<b>🔍 HASIL PENCARIAN NEGARA</b>

Kata kunci: "${searchQuery}"
Hasil: Tidak ditemukan

<b>📋 TINDAKAN</b>
Coba kata kunci lain atau lihat semua negara.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔍 Cari Negara Lain', 
                                    callback_data: `search_country_input_${serviceId}` 
                                },
                                { 
                                    text: '📍 Semua Negara', 
                                    callback_data: `nokos_service_${serviceId}` 
                                }
                            ],
                            [
                                { 
                                    text: '🔙 Kembali', 
                                    callback_data: `nokos_service_${serviceId}` 
                                }
                            ]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const itemsPerPage = 6;
        const totalPages = Math.ceil(searchResults.length / itemsPerPage);
        
        if (page < 0) page = 0;
        if (page >= totalPages) page = totalPages - 1;

        const startIndex = page * itemsPerPage;
        const endIndex = startIndex + itemsPerPage;
        const currentResults = searchResults.slice(startIndex, endIndex);

        const message = `<b>🔍 HASIL PENCARIAN NEGARA</b>

Kata kunci: "${searchQuery}"
Ditemukan: ${searchResults.length} negara
Halaman: ${page + 1}/${totalPages}

<b>📍 NEGARA YANG COCOK</b>
Pilih negara untuk melanjutkan:`;
        
        const keyboard = [];
        
        for (let i = 0; i < currentResults.length; i += 2) {
            const row = [];
            
            if (currentResults[i]) {
                const country = currentResults[i];
                const countryFlag = getFlagEmoji(country.iso_code) || '📍';
                let countryText = country.name;
                if (countryText.length > 10) {
                    countryText = countryText.substring(0, 10);
                }
                
                row.push({ 
                    text: `${countryFlag} ${countryText}`, 
                    callback_data: `nokos_server_list_${country.number_id}_${encodeURIComponent(country.name)}` 
                });
            }
            
            if (currentResults[i + 1]) {
                const country = currentResults[i + 1];
                const countryFlag = getFlagEmoji(country.iso_code) || '📍';
                let countryText = country.name;
                if (countryText.length > 10) {
                    countryText = countryText.substring(0, 10);
                }
                
                row.push({ 
                    text: `${countryFlag} ${countryText}`, 
                    callback_data: `nokos_server_list_${country.number_id}_${encodeURIComponent(country.name)}` 
                });
            }
            
            if (row.length > 0) {
                keyboard.push(row);
            }
        }

        const navButtons = [];
        
        if (totalPages > 1) {
            if (page > 0) {
                navButtons.push({ 
                    text: '<', 
                    callback_data: `search_country_results_${serviceId}_${encodeURIComponent(searchQuery)}_${page - 1}` 
                });
            }

            if (page < totalPages - 1) {
                navButtons.push({ 
                    text: '>', 
                    callback_data: `search_country_results_${serviceId}_${encodeURIComponent(searchQuery)}_${page + 1}` 
                });
            }
            
            if (navButtons.length > 0) {
                keyboard.push(navButtons);
            }
        }

        keyboard.push([
            { 
                text: '🔍 Cari Negara Lain', 
                callback_data: `search_country_input_${serviceId}` 
            }
        ]);

        keyboard.push([
            { 
                text: '🔙 Kembali ke Layanan', 
                callback_data: `nokos_service_${serviceId}` 
            }
        ]);

        await editMessage(chatId, messageId, callbackQueryId, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });

    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId, 
`<b>❌ GAGAL MENCARI NEGARA</b>

Status: Error Sistem

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔄 Coba Lagi', 
                            callback_data: `nokos_service_${serviceId}` 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function showOrderConfirmation(chatId, userId, operatorId, providerId, price, messageId, callbackQueryId) {
    try {
        const userSelection = userSelections.get(userId);
        if (!userSelection) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ SESI TIDAK DITEMUKAN</b>

Status: Sesi Kadaluarsa

<b>⚠️ TINDAKAN</b>
Silakan mulai kembali dari menu utama.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ 
                                text: '🏠 Menu', 
                                callback_data: 'main_menu' 
                            }]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const numPrice = Number(price);
        const userVoucher = getUserVoucher(userId);
        let discountAmount = 0;
        let finalPrice = numPrice;
        let voucherInfo = '';
        
        if (userVoucher) {
            discountAmount = (numPrice * userVoucher.discount) / 100;
            finalPrice = numPrice - discountAmount;
            voucherInfo = `\n🎟️ Diskon Voucher: -${formatCurrency(discountAmount)} (${userVoucher.discount}%)`;
        }
        
        const totalPrice = finalPrice;
        const userBalance = getUserBalance(userId);
        const canOrder = userBalance >= totalPrice;
        const formattedPrice = formatCurrency(numPrice);
        const formattedDiscount = formatCurrency(discountAmount);
        const formattedFinal = formatCurrency(finalPrice);
        const formattedTotal = formatCurrency(totalPrice);
        const formattedBalance = formatCurrency(userBalance);
        
        if (!userSelection.serviceName) {
            userSelection.serviceName = 'Layanan Nokos';
        }
        if (!userSelection.countryName) {
            userSelection.countryName = 'Negara';
        }

        const message = `<b>✅ KONFIRMASI ORDER</b>

Layanan: ${userSelection.serviceName}
Negara: ${userSelection.countryName}
Harga Asli: ${formattedPrice}${voucherInfo}
Harga Final: ${formattedFinal}
Total: ${formattedTotal}

📋 <b>Syarat dan ketentuan!.</b>
<a href="https://telegra.ph/PENYEBAB-KODE-OTP-SUSAH--TIDAK-MASUK-12-18">BACA DI SINI</a> ketentuanya!.

<b>💰 INFORMASI SALDO</b>
Saldo Anda: ${formattedBalance}
Status: ${canOrder ? '✅ Cukup' : '❌ Kurang'}
${canOrder ? '✅ Siap diproses' : '❌ Tidak dapat diproses'}

<b>⚠️ KONFIRMASI</b>
${canOrder ? 
    'Klik BELI SEKARANG untuk melanjutkan.' : 
    'Saldo tidak cukup. Deposit terlebih dahulu.'}`;

        userSelection.operatorId = operatorId;
        userSelection.providerId = providerId;
        userSelection.price = price;
        userSelection.discountAmount = discountAmount;
        userSelection.finalPrice = finalPrice;
        userSelections.set(userId, userSelection);

        const keyboard = [
            [
                { 
                    text: canOrder ? '✅ Beli Sekarang' : '💰 Deposit', 
                    callback_data: canOrder ? 
                        `nokos_confirm_${userSelection.numberId}_${providerId}_${operatorId}_${price}_${discountAmount}_${finalPrice}` : 
                        'deposit_main' 
                }
            ],
            [
                { 
                    text: '🔙 Kembali', 
                    callback_data: `nokos_server_list_${userSelection.numberId}_${encodeURIComponent(userSelection.countryName)}` 
                },
                { 
                    text: '🏠 Menu', 
                    callback_data: 'main_menu' 
                }
            ]
        ];

        await editMessage(chatId, messageId, callbackQueryId, message, {
            reply_markup: { inline_keyboard: keyboard },
            parse_mode: 'HTML',
            disable_web_page_preview: true
        });

    } catch (error) {
        console.error('Error in showOrderConfirmation:', error);
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MENAMPILKAN KONFIRMASI</b>

Status: Error Sistem
Error: ${error.message || 'Unknown error'}

<b>⚠️ TINDAKAN</b>
Silakan coba lagi nanti.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ 
                            text: '🔙 Kembali', 
                            callback_data: 'nokos_menu' 
                        }]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function processNokosOrder(chatId, userId, numberId, providerId, operatorId, price, messageId, callbackQueryId) {
    let totalPrice = 0;
    let discountAmount = 0;
    let finalPrice = 0;

    const balanceLockKey = `balance_lock_${userId}`;
    
    if (balanceLocks.has(balanceLockKey)) {
        const lockTime = balanceLocks.get(balanceLockKey);
        if (Date.now() - lockTime < 10000) {
            await editMessage(
                chatId,
                messageId,
                callbackQueryId,
                '<b>⏳ Transaksi sedang diproses, tunggu sebentar...</b>',
                { parse_mode: 'HTML' }
            );
            return;
        } else {
            balanceLocks.delete(balanceLockKey);
        }
    }
    
    balanceLocks.set(balanceLockKey, Date.now());

    try {
        const userSelection = userSelections.get(userId);
        const userVoucher = getUserVoucher(userId);
        if (userVoucher) {
            discountAmount = (Number(price) * userVoucher.discount) / 100;
            finalPrice = Number(price) - discountAmount;
        } else {
            finalPrice = Number(price);
        }

        const orderKey = `${userId}_${Date.now()}_${Math.floor(Math.random() * 1000)}`;

        if (isOrderProcessing(orderKey)) {
            await editMessage(
                chatId,
                messageId,
                callbackQueryId,
                '<b>⏳ Order sedang diproses</b>',
                { parse_mode: 'HTML' }
            );
            setTimeout(() => {
                balanceLocks.delete(balanceLockKey);
            }, 5000);
            return;
        }

        setOrderProcessing(orderKey, true);

        const gatewayFee = 0;
        const additionalFee = Number(nokos_fee) || 0;
        const priceNumber = finalPrice;

        if (isNaN(priceNumber)) {
            await editMessage(
                chatId,
                messageId,
                callbackQueryId,
                `<b>❌ HARGA TIDAK VALID</b>\n\nSilakan ulangi order.`,
                { parse_mode: 'HTML' }
            );
            setOrderProcessing(orderKey, false);
            setTimeout(() => {
                balanceLocks.delete(balanceLockKey);
            }, 5000);
            return;
        }

        const totalFee = gatewayFee + additionalFee;
        totalPrice = priceNumber + totalFee;

        const userBalance = Number(getUserBalance(userId));

        if (userBalance < totalPrice) {
            await editMessage(
                chatId,
                messageId,
                callbackQueryId,
`<b>❌ SALDO TIDAK CUKUP</b>

Saldo Anda : ${formatCurrency(userBalance)}
Harga      : ${formatCurrency(priceNumber)}
${discountAmount > 0 ? `Diskon     : -${formatCurrency(discountAmount)}\n` : ''}Admin Fee  : ${formatCurrency(additionalFee)}
Total Bayar: ${formatCurrency(totalPrice)}`,
                {
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [{ text: '💰 Deposit', callback_data: 'deposit_main' }]
                        ]
                    }
                }
            );
            setOrderProcessing(orderKey, false);
            setTimeout(() => {
                balanceLocks.delete(balanceLockKey);
            }, 5000);
            return;
        }

        const deducted = deductUserBalance(userId, totalPrice);
        if (!deducted) {
            await editMessage(
                chatId,
                messageId,
                callbackQueryId,
                `<b>❌ GAGAL MEMOTONG SALDO</b>\n\nSilakan hubungi admin.`,
                { parse_mode: 'HTML' }
            );
            setOrderProcessing(orderKey, false);
            setTimeout(() => {
                balanceLocks.delete(balanceLockKey);
            }, 5000);
            return;
        }

        const orderResult = await api.createOrder(
            numberId,
            providerId,
            operatorId
        );

        if (!orderResult || !orderResult.success) {
            const errorMsg =
                orderResult?.error?.message ||
                orderResult?.message ||
                orderResult?.data?.message ||
                'Error dari API';

            addUserBalance(userId, totalPrice);

            await editMessage(
                chatId,
                messageId,
                callbackQueryId,
`<b>❌ GAGAL MEMBUAT ORDER</b>

Error: ${errorMsg}

<b>✅ SALDO DIKEMBALIKAN</b>
${formatCurrency(totalPrice)}`,
                {
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                {
                                    text: '🔄 Coba Lagi',
                                    callback_data: `nokos_confirm_${numberId}_${providerId}_${operatorId}_${price}`
                                }
                            ],
                            [{ text: '🏠 Menu', callback_data: 'main_menu' }]
                        ]
                    }
                }
            );
            setOrderProcessing(orderKey, false);
            setTimeout(() => {
                balanceLocks.delete(balanceLockKey);
            }, 5000);
            return;
        }

        const orderData = orderResult.data;
        const expiresInMinutes = 20;
        const expiresAt = Date.now() + expiresInMinutes * 60 * 1000;

        addTransaction('nokos_orders', {
            userId,
            orderId: orderData.order_id,
            phoneNumber: orderData.phone_number,
            service: orderData.service,
            country: orderData.country,
            operator: orderData.operator,
            original_price: Number(price),
            discount_amount: discountAmount,
            discounted_price: priceNumber,
            gateway_fee: gatewayFee,
            additional_fee: additionalFee,
            fee: totalFee,
            total: totalPrice,
            status: 'active',
            expiresAt,
            expiresInMinutes,
            otp_received: false,
            otp_code: null,
            refunded: false,
            processed: true,
            raw_data: orderResult,
            timestamp: new Date().toISOString()
        });

        const discountInfo = discountAmount > 0 ? 
            `\n💎 Diskon Voucher: -${formatCurrency(discountAmount)}` : '';

        const message = `<b>✅ ORDER BERHASIL DIPROSES</b>

<b>📋 ORDER DETAILS</b>
• ID Order: <code>#${orderData.order_id}</code>
• Nomor: ${orderData.phone_number}
• Layanan: ${orderData.service}
• Negara: ${orderData.country}
• Operator: ${orderData.operator}

<b>💰 PAYMENT INFORMATION</b>
• Harga Asli: ${formatCurrency(Number(price))}${discountInfo}
• Harga Final: ${formatCurrency(priceNumber)}
• Admin Fee: ${formatCurrency(additionalFee)}
• Total Bayar: <b>${formatCurrency(totalPrice)}</b>

<b>⏰ TIME INFORMATION</b>
• Durasi OTP: ${expiresInMinutes} menit
• Batalkan manual: Minimal 3 menit
• Auto refund: Jika OTP tidak masuk

<b>📱 INSTRUCTIONS</b>
1. Gunakan nomor untuk registrasi
2. Tunggu SMS OTP
3. Cek OTP dengan tombol di bawah
4. Jika gagal, auto refund 100%

<b>⚠️ NOTES</b>
• Notifikasi otomatis saat OTP masuk
• Saldo kembali otomatis jika gagal
• Support tersedia jika ada masalah`;

        await editMessage(chatId, messageId, callbackQueryId, message, {
            parse_mode: 'HTML',
            reply_markup: {
                inline_keyboard: [
                    [
                        {
                            text: '🔐 Cek OTP',
                            callback_data: `nokos_check_${orderData.order_id}`
                        },
                        {
                            text: '❌ Batalkan',
                            callback_data: `nokos_cancel_${orderData.order_id}`
                        }
                    ]
                ]
            }
        });
        
        setTimeout(() => {
            transactionAutoBackup();
        }, 2000);

        try {
            const user = await bot.getChat(userId);
            await notifyOrderSuccess(user, orderData, totalPrice, false);
        } catch (notifError) {
        }

        setTimeout(() => {
            monitorOTP(
                chatId,
                userId,
                orderData.order_id,
                totalPrice,
                expiresInMinutes
            );
        }, 5000);
        
        setOrderProcessing(orderKey, false);
        
        setTimeout(() => {
            balanceLocks.delete(balanceLockKey);
        }, 10000);

    } catch (error) {
        try {
            if (totalPrice > 0) {
                addUserBalance(userId, totalPrice);
            }
        } catch {}

        await editMessage(
            chatId,
            messageId,
            callbackQueryId,
`<b>❌ ERROR SISTEM</b>

${error.message || 'Silakan coba lagi'}`,
            {
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [{ text: '🏠 Menu', callback_data: 'main_menu' }]
                    ]
                }
            }
        );

        setOrderProcessing(`${userId}`, false);
        
        setTimeout(() => {
            balanceLocks.delete(balanceLockKey);
        }, 5000);
    }
}

async function monitorOTP(chatId, userId, orderId, totalPrice, expiresInMinutes = 20) {
    const monitorLockKey = `monitor_otp_${orderId}`;
    
    if (balanceLocks.has(monitorLockKey)) {
        const lockTime = balanceLocks.get(monitorLockKey);
        if (Date.now() - lockTime < 30000) {
            return;
        } else {
            balanceLocks.delete(monitorLockKey);
        }
    }
    
    balanceLocks.set(monitorLockKey, Date.now());
    
    try {
        const maxTime = expiresInMinutes * 60 * 1000;
        const startTime = Date.now();
        let errorCount = 0;
        const maxErrors = 3;
        
        const monitorInterval = setInterval(async () => {
            try {
                const currentTime = Date.now();
                const elapsedTime = currentTime - startTime;
                
                if (elapsedTime >= maxTime) {
                    clearInterval(monitorInterval);
                    
                    const statusResult = await api.getOrderStatus(orderId);
                    let otpReceived = false;
                    
                    if (statusResult && statusResult.success && statusResult.data) {
                        const orderData = statusResult.data;
                        otpReceived = orderData.otp_code && orderData.otp_code !== '-' && orderData.otp_code !== '';
                    }

                    if (otpReceived) {
                        updateTransactionStatus('nokos_orders', orderId, 'completed');
                        
                        const transactions = loadTransactions();
                        const orderIndex = transactions.nokos_orders?.findIndex(o => 
                            o.id === orderId || o.data?.orderId === orderId
                        );
                        
                        if (orderIndex !== -1) {
                            transactions.nokos_orders[orderIndex].data.otp_received = true;
                            transactions.nokos_orders[orderIndex].data.otp_code = statusResult.data.otp_code;
                            transactions.nokos_orders[orderIndex].data.status = 'completed';
                            transactions.nokos_orders[orderIndex].data.refunded = false;
                            saveTransactions(transactions);
                            
                            await sendNewMessage(chatId,
`<b>✅ OTP BERHASIL DITERIMA</b>

<b>📋 ORDER INFORMATION</b>
• ID Order: <code>#${orderId}</code>
• Nomor: ${statusResult.data.phone_number}
• Kode OTP: <code>${statusResult.data.otp_code}</code>
• Total Pembayaran: ${formatCurrency(totalPrice)}

<b>📱 SERVICE STATUS</b>
• Status: ✅ Order Selesai
• OTP: ✅ Valid dan Aktif
• Transaksi: ✅ Berhasil`,
                                { parse_mode: 'HTML' }
                            );
                            
                            try {
                                const user = await bot.getChat(userId).catch(() => ({ 
                                    id: userId, 
                                    first_name: 'User' 
                                }));
                                await notifyOrderSuccess(user, statusResult.data, totalPrice, true);
                            } catch {}
                        }
                        setTimeout(() => {
                            balanceLocks.delete(monitorLockKey);
                        }, 5000);
                        return;
                    }
                    
                    await api.setOrderStatus(orderId, 'cancel').catch(() => {});
                    
                    updateTransactionStatus('nokos_orders', orderId, 'expired');
                    
                    const transactions = loadTransactions();
                    const orderIndex = transactions.nokos_orders?.findIndex(o => 
                        o.id === orderId || o.data?.orderId === orderId
                    );
                    
                    if (orderIndex !== -1) {
                        const order = transactions.nokos_orders[orderIndex];
                        
                        if (!order.data?.refunded && !order.data?.otp_received) {
                            addUserBalance(userId, totalPrice);
                            
                            transactions.nokos_orders[orderIndex].data.refunded = true;
                            transactions.nokos_orders[orderIndex].data.status = 'expired';
                            transactions.nokos_orders[orderIndex].data.auto_refunded = true;
                            saveTransactions(transactions);
                            
                            await sendRefundNotification(chatId, orderId, totalPrice, 'auto');
                        }
                    }
                    setTimeout(() => {
                        balanceLocks.delete(monitorLockKey);
                    }, 5000);
                    return;
                }
                
                const statusResult = await api.getOrderStatus(orderId);
                
                if (!statusResult || !statusResult.success) {
                    errorCount++;
                    if (errorCount >= maxErrors) {
                        clearInterval(monitorInterval);
                        setTimeout(() => {
                            balanceLocks.delete(monitorLockKey);
                        }, 5000);
                    }
                    return;
                }

                const orderData = statusResult.data;
                
                if (orderData.otp_code && orderData.otp_code !== '-') {
                    clearInterval(monitorInterval);

                    updateTransactionStatus('nokos_orders', orderId, 'completed');
                    
                    const transactions = loadTransactions();
                    const orderIndex = transactions.nokos_orders?.findIndex(o => 
                        o.id === orderId || o.data?.orderId === orderId
                    );
                    
                    if (orderIndex !== -1) {
                        const order = transactions.nokos_orders[orderIndex];
                        
                        transactions.nokos_orders[orderIndex].data.otp_received = true;
                        transactions.nokos_orders[orderIndex].data.otp_code = orderData.otp_code;
                        transactions.nokos_orders[orderIndex].data.status = 'completed';
                        transactions.nokos_orders[orderIndex].data.refunded = false;
                        saveTransactions(transactions);

                        await sendNewMessage(chatId,
`<b>✅ OTP DITERIMA</b>

<b>📋 ORDER DETAILS</b>
ID Order: <code>#${orderId}</code>
Nomor: ${orderData.phone_number}
Kode OTP: <code>${orderData.otp_code}</code>
Total: ${formatCurrency(totalPrice)}`,
                            { parse_mode: 'HTML' }
                        );
                        
                        try {
                            const user = await bot.getChat(userId).catch(() => ({ 
                                id: userId, 
                                first_name: 'User' 
                            }));
                            await notifyOrderSuccess(user, orderData, totalPrice, true);
                        } catch {}
                    }
                    setTimeout(() => {
                        balanceLocks.delete(monitorLockKey);
                    }, 5000);
                    return;
                }
                
                if (orderData.status === 'canceled' || orderData.status === 'expired' || orderData.status === 'failed') {
                    clearInterval(monitorInterval);
                    
                    updateTransactionStatus('nokos_orders', orderId, orderData.status);
                    
                    const transactions = loadTransactions();
                    const orderIndex = transactions.nokos_orders?.findIndex(o => 
                        o.id === orderId || o.data?.orderId === orderId
                    );
                    
                    if (orderIndex !== -1) {
                        const order = transactions.nokos_orders[orderIndex];
                        
                        if (!order.data?.refunded && !order.data?.otp_received) {
                            addUserBalance(userId, totalPrice);

                            transactions.nokos_orders[orderIndex].data.refunded = true;
                            saveTransactions(transactions);
                            
                            await sendRefundNotification(chatId, orderId, totalPrice, 'auto');
                        }
                    }
                    setTimeout(() => {
                        balanceLocks.delete(monitorLockKey);
                    }, 5000);
                    return;
                }
                
                errorCount = 0;
                
            } catch {
                errorCount++;
                if (errorCount >= maxErrors) {
                    clearInterval(monitorInterval);
                    setTimeout(() => {
                        balanceLocks.delete(monitorLockKey);
                    }, 5000);
                }
            }
        }, 30000);
        
        setTimeout(() => {
            clearInterval(monitorInterval);
            setTimeout(() => {
                balanceLocks.delete(monitorLockKey);
            }, 5000);
        }, maxTime + 60000);
        
    } catch (error) {
        setTimeout(() => {
            balanceLocks.delete(monitorLockKey);
        }, 5000);
    }
}

async function checkOTP(chatId, orderId, messageId, callbackQueryId) {
    try {
        await editMessage(chatId, messageId, callbackQueryId,
            '<b>⏳ Mengecek OTP...</b>',
            { parse_mode: 'HTML' }
        );

        const transactions = loadTransactions();
        const order = transactions.nokos_orders?.find(o => 
            o.id === orderId || o.data?.orderId === orderId
        );
    
        if (order) {
            const orderTime = new Date(order.timestamp).getTime();
            const currentTime = Date.now();
            const threeMinutes = 3 * 60 * 1000;
    
            if (currentTime - orderTime < threeMinutes) {
                const remainingSeconds = Math.ceil((threeMinutes - (currentTime - orderTime)) / 1000);
                const remainingMinutes = Math.floor(remainingSeconds / 60);
                const remainingSecs = remainingSeconds % 60;
                
                await editMessage(chatId, messageId, callbackQueryId,
`<b>⏳ MENUNGGU OTP</b>

<b>📋 ORDER INFORMATION</b>
• ID Order: <code>#${orderId}</code>
• Waktu Order: ${new Date(orderTime).toLocaleTimeString('id-ID')}
• Status: ⏳ Proses OTP

<b>⏰ TIME REQUIREMENTS</b>
• Minimal tunggu: ${remainingMinutes}:${remainingSecs.toString().padStart(2, '0')}
• Auto refund: 20 menit dari order`,
                    { 
                        parse_mode: 'HTML',
                        reply_markup: {
                            inline_keyboard: [
                                [
                                    { 
                                        text: `🔄 Cek Lagi (${remainingMinutes}m)`, 
                                        callback_data: `nokos_check_${orderId}` 
                                    }
                                ]
                            ]
                        }
                    }
                );
                return;
            }
        }

        const statusResult = await api.getOrderStatus(orderId);
        
        if (!statusResult || !statusResult.success) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MENGECEK OTP</b>

<b>📋 ORDER STATUS</b>
• ID Order: <code>#${orderId}</code>
• Status: ❌ Gagal Terhubung

<b>🔄 TROUBLESHOOTING</b>
• Coba lagi dalam beberapa menit
• Hubungi support jika masalah berlanjut`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔄 Coba Lagi', 
                                    callback_data: `nokos_check_${orderId}` 
                                }
                            ]
                        ]
                    }
                }
            );
            return;
        }

        const orderData = statusResult.data;
        
        if (orderData.otp_code && orderData.otp_code !== '-') {
            const orderIndex = transactions.nokos_orders?.findIndex(o => 
                o.id === orderId || o.data?.orderId === orderId
            );
            
            if (orderIndex !== -1) {
                transactions.nokos_orders[orderIndex].data.otp_received = true;
                transactions.nokos_orders[orderIndex].data.otp_code = orderData.otp_code;
                transactions.nokos_orders[orderIndex].data.status = 'completed';
                transactions.nokos_orders[orderIndex].data.refunded = false; 
                saveTransactions(transactions);
            }
            
            await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ OTP DITEMUKAN</b>

<b>📋 ORDER INFORMATION</b>
• ID Order: <code>#${orderId}</code>
• Kode OTP: <code>${orderData.otp_code}</code>

<b>📊 ORDER STATUS</b>
• Status: ✅ Selesai
• Order: ❌ Tidak dapat dibatalkan`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🏠 Menu', 
                                    callback_data: 'main_menu' 
                                }
                            ]
                        ]
                    }
                }
            );

            try {
                const userId = order.userId;
                const user = await bot.getChat(userId).catch(() => ({ 
                    id: userId, 
                    first_name: 'User' 
                }));
                const price = order.data?.price || 0;
                await notifyOrderSuccess(user, orderData, price, true);
            } catch (error) {}
            
        } else {
            const statusEmoji = orderData.status === 'active' ? '⏳' : 
                              orderData.status === 'completed' ? '✅' : 
                              orderData.status === 'canceled' ? '❌' : 
                              orderData.status === 'expired' ? '⏰' : '❓';
            
            const elapsedTime = Date.now() - new Date(order.timestamp).getTime();
            const canCancel = elapsedTime >= 3 * 60 * 1000;
            
            await editMessage(chatId, messageId, callbackQueryId,
`<b>⏳ MENUNGGU OTP</b>

<b>📋 ORDER DETAILS</b>
• ID Order: <code>#${orderId}</code>
• Status: ${statusEmoji} ${orderData.status || 'Active'}

<b>📊 STATUS OTP</b>
• OTP: ⏳ Belum diterima
• Auto refund: Aktif dalam 20 menit`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔄 Cek Lagi', 
                                    callback_data: `nokos_check_${orderId}` 
                                },
                                canCancel ? { 
                                    text: '❌ Batalkan', 
                                    callback_data: `nokos_cancel_${orderId}` 
                                } : { 
                                    text: '⏳ Tunggu 3m',
                                    callback_data: 'no_action'
                                }
                            ]
                        ]
                    }
                }
            );
        }
    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MENGECEK OTP</b>

• ID Order: <code>#${orderId}</code>
• Status: ❌ Error Sistem

Silakan hubungi CS untuk bantuan.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [
                            { 
                                text: '💬 CS', 
                                url: `https://t.me/${usernamelu.replace('@','')}` 
                            }
                        ]
                    ]
                }
            }
        );
    }
}

async function handleDeposit(chatId, userId, amount) {
    const depositKey = `${userId}_deposit`;

    try {
        if (depositProcessing.has(depositKey)) {
            const depositTime = depositProcessing.get(depositKey);
            if (Date.now() - depositTime < 30000) {
                await sendNewMessage(chatId,
`<b>⏳ DEPOSIT SEDANG DIPROSES</b>
Mohon tunggu 30 detik...`,
                    { parse_mode: 'HTML' }
                );
                return;
            } else {
                depositProcessing.delete(depositKey);
            }
        }
        
        depositProcessing.set(depositKey, Date.now());

        const lastReq = lastDepositRequestTime.get(userId) || 0;
        const now = Date.now();
        if (now - lastReq < 5000) {
            depositProcessing.delete(depositKey);
            return sendNewMessage(chatId,
`<b>⏳ TERLALU CEPAT</b>
Coba lagi sebentar.`,
                { parse_mode: 'HTML' }
            );
        }
        lastDepositRequestTime.set(userId, now);

        const amountValidation = validateAmount(amount);
        if (!amountValidation.valid) {
            depositProcessing.delete(depositKey);
            return sendNewMessage(chatId,
`<b>❌ JUMLAH TIDAK VALID</b>
${amountValidation.error}`,
                { parse_mode: 'HTML' }
            );
        }

        const depositAmount = amountValidation.amount;
        if (depositAmount < 2000 || depositAmount > 5000000) {
            depositProcessing.delete(depositKey);
            return sendNewMessage(chatId,
`<b>❌ JUMLAH DI LUAR BATAS</b>
Minimal Rp2.000 – Maksimal Rp5.000.000`,
                { parse_mode: 'HTML' }
            );
        }

        const adminFee = Number(deposit_fee) || 0;
        const requestedTotal = depositAmount + adminFee;

        const loading = await sendNewMessage(
            chatId,
            `<b>⏳ MEMBUAT QR DEPOSIT...</b>`,
            { parse_mode: 'HTML' }
        );

        const paymentMethod = getPaymentMethod();
        const isKhafa = paymentMethod === 'khafa';
        let depositResult;

        if (isKhafa) {
            depositResult = await khafaService.createDeposit(
                userId.toString(),
                requestedTotal
            );
        } else {
            depositResult = await api.createRumahOTPDeposit(
                requestedTotal
            );
        }

        if (!depositResult?.success) {
            depositProcessing.delete(depositKey);
            return editMessage(chatId, loading.message_id, null,
`<b>❌ GAGAL MEMBUAT DEPOSIT</b>
${depositResult?.message || 'Gateway error'}`,
                { parse_mode: 'HTML' }
            );
        }

        const depositData = depositResult.data;
        const depositId = depositData.id || depositData.no_inv;

        const totalToPay = Number(
            depositData.total ||
            depositData.totalAmount ||
            depositData.amount ||
            depositData.pay_amount ||
            requestedTotal
        );

        const realFee = totalToPay - depositAmount;
        
        await notifyOwnerDepositCreated(depositData, userId, depositAmount, 
            realFee - adminFee, totalToPay, depositAmount, paymentMethod);

        const transactionType = isKhafa ? 'khafa_deposits' : 'rumahotp_deposits';

        addTransaction(transactionType, {
            userId,
            id: depositId,
            amount: depositAmount,
            saldo_didapat: depositAmount,
            admin_fee: adminFee,
            gateway_fee: realFee - adminFee,
            total_fee: realFee,
            total_bayar: totalToPay,
            method: 'QRIS',
            status: 'pending',
            payment_method: paymentMethod,
            raw_data: depositResult,
            timestamp: new Date().toISOString(),
            calculation: {
                deposit: depositAmount,
                admin_fee: adminFee,
                total_fee: realFee,
                total_pay: totalToPay,
                received: depositAmount
            }
        });

        const message = `<b>💰 DEPOSIT DIPROSES</b>

<b>📋 TRANSACTION DETAILS</b>
• ID Deposit: <code>#${depositId}</code>
• Nominal: ${formatCurrency(depositAmount)}
• Admin Fee: ${formatCurrency(adminFee)}
• Total Bayar: <b>${formatCurrency(totalToPay)}</b>
• Saldo Masuk: ${formatCurrency(depositAmount)}
• Metode: QRIS
• Status: ⏳ Menunggu Pembayaran

<b>📱 PAYMENT INSTRUCTIONS</b>
1. Scan QR Code di bawah
2. Bayar sesuai nominal
3. Sistem verifikasi otomatis
4. Saldo masuk dalam 1-3 menit

<b>⏰ TIME LIMIT</b>
• Berlaku: 20 menit
• Expired: Auto dibatalkan
• Re-create: Deposit baru jika expired

<b>⚠️ NOTES</b>
• Bayar sesuai total yang ditampilkan
• Sudah termasuk biaya transaksi
• Pastikan pembayaran tepat waktu`;

        await bot.deleteMessage(chatId, loading.message_id).catch(() => {});

        const qrBuffer = await QRCode.toBuffer(depositData.qr_string, {
            width: 300,
            margin: 1
        });

        const sent = await bot.sendPhoto(chatId, qrBuffer, {
            caption: message,
            parse_mode: 'HTML',
            reply_markup: {
                inline_keyboard: [
                    [{ text: '🔍 Cek Status', callback_data: `deposit_status_${depositId}` }],
                    [{ text: '❌ Batalkan', callback_data: `deposit_cancel_${depositId}` }],
                    [
                        { text: '💰 Deposit Lagi', callback_data: 'deposit_main' },
                        { text: '🏠 Menu', callback_data: 'main_menu' }
                    ]
                ]
            }
        });

        userDepositMessages.set(`${userId}_${depositId}`, {
            messageId: sent.message_id,
            createdAt: Date.now(),
            paymentMethod
        });

        setTimeout(() => {
            checkDepositStatus(chatId, depositId, userId, sent.message_id);
        }, 5000);

        const nowJakarta = new Date(new Date().toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
        const minute = nowJakarta.getMinutes();
        
        setTimeout(() => {
            depositProcessing.delete(depositKey);
        }, 30000);

    } catch (err) {
        if (depositProcessing.has(`${userId}_deposit`)) {
            depositProcessing.delete(`${userId}_deposit`);
        }
        await sendNewMessage(chatId,
`<b>❌ ERROR SISTEM</b>
${err.message || 'Unknown error'}`,
            { parse_mode: 'HTML' }
        );
    }
}

async function checkDepositStatus(chatId, depositId, userId, messageId = null, retryCount = 0) {
    const depositLockKey = `deposit_lock_${depositId}`;
    
    if (balanceLocks.has(depositLockKey)) {
        const lockTime = balanceLocks.get(depositLockKey);
        if (Date.now() - lockTime < 30000) {
            return;
        } else {
            balanceLocks.delete(depositLockKey);
        }
    }
    
    balanceLocks.set(depositLockKey, Date.now());
    
    try {
        const maxRetries = 180;
        const transactions = loadTransactions();
        
        let depositData = null;
        let transactionType = null;
        
        const depositTypes = ['khafa_deposits', 'rumahotp_deposits'];
        for (const type of depositTypes) {
            if (transactions[type]) {
                const deposit = transactions[type].find(d => d.data.id === depositId);
                if (deposit) {
                    depositData = deposit;
                    transactionType = type;
                    break;
                }
            }
        }
        
        if (!depositData) {
            setTimeout(() => {
                balanceLocks.delete(depositLockKey);
            }, 5000);
            return;
        }
        
        if (depositData.data?.processed === true || depositData.status === 'success' || depositData.status === 'paid') {
            setTimeout(() => {
                balanceLocks.delete(depositLockKey);
            }, 5000);
            return;
        }
        
        const depositTime = new Date(depositData.timestamp).getTime();
        const currentTime = Date.now();
        const twentyMinutes = 20 * 60 * 1000;
        
        if (currentTime - depositTime > twentyMinutes) {
            if (depositData.status !== 'success' && depositData.status !== 'paid') {
                updateTransactionStatus(transactionType, depositData.id, 'expired');
                
                if (messageId) {
                    try {
                        await bot.deleteMessage(chatId, messageId);
                    } catch (error) {}
                }
                
                await sendNewMessage(chatId,
`<b>⏰ DEPOSIT EXPIRED</b>

<b>📋 TRANSACTION STATUS</b>
• ID Deposit: <code>#${depositId}</code>
• Status: ❌ Kadaluarsa
• Reason: Lebih dari 20 menit

<b>🔄 NEXT STEPS</b>
• Buat deposit baru dengan tombol di bawah
• Scan QR code yang baru
• Bayar sesuai nominal
• Saldo masuk otomatis

<b>⚠️ NOTES</b>
• Deposit expired otomatis dibatalkan
• Tidak ada pemotongan saldo
• Transaksi aman dan terjamin`,
                    { 
                        parse_mode: 'HTML',
                        reply_markup: {
                            inline_keyboard: [
                                [
                                    { 
                                        text: '💰 Buat Deposit Baru', 
                                        callback_data: 'deposit_main' 
                                    }
                                ]
                            ]
                        }
                    }
                );
                setTimeout(() => {
                    balanceLocks.delete(depositLockKey);
                }, 5000);
                return;
            }
        }
        
        const paymentMethod = depositData.data?.payment_method || getPaymentMethod();
        let statusResult = null;
        
        try {
            if (paymentMethod === 'khafa') {
                statusResult = await khafaService.checkDepositStatus(depositId);
            } else {
                statusResult = await api.checkRumahOTPDepositStatus(depositId);
            }
            
            if (statusResult) {
                const depositStatus = statusResult.data?.status || statusResult.status;
                const depositStatusLower = String(depositStatus).toLowerCase();
                
                if (depositStatusLower === 'success' || depositStatusLower === 'paid') {
                    if (depositData.data?.processed !== true && depositData.status !== 'success' && depositData.status !== 'paid') {
                        const amountToAdd = depositData.data?.saldo_didapat || 0;
                        
                        if (amountToAdd > 0) {
                            const addSuccess = addUserBalance(userId, amountToAdd);
                            
                            const pointsAdded = 1; 
                            royaltySystem.addPoints(userId, pointsAdded, 'deposit');
                            setTimeout(() => {
                                transactionAutoBackup();
                            }, 2000);
                        }
                        
                        const transactionsUpdate = loadTransactions();
                        const depositIndex = transactionsUpdate[transactionType]?.findIndex(d => d.data.id === depositId);
                        if (depositIndex !== -1) {
                            transactionsUpdate[transactionType][depositIndex].status = 'success';
                            transactionsUpdate[transactionType][depositIndex].data.status = 'success';
                            transactionsUpdate[transactionType][depositIndex].data.processed = true;
                            saveTransactions(transactionsUpdate);
                        }
                        
                        const newBalance = getUserBalance(userId);
                        
                        if (messageId) {
                            try {
                                await bot.deleteMessage(chatId, messageId);
                            } catch (error) {}
                        }
                        
                        await sendNewMessage(chatId,
`<b>✅ DEPOSIT BERHASIL</b>

<b>📋 TRANSACTION DETAILS</b>
• ID Deposit: <code>#${depositId}</code>
• Total Bayar: ${formatCurrency(depositData.data?.total_bayar || 0)}
• Saldo Masuk: ${formatCurrency(amountToAdd)}
• Saldo Baru: ${formatCurrency(newBalance)}
• Points: +1

<b>📊 ACCOUNT UPDATE</b>
• Status: ✅ Transaksi Sukses
• Saldo: ${formatCurrency(newBalance)}

<b>🎉 TERIMA KASIH</b>
Saldo berhasil ditambahkan ke akun Anda
Siap untuk digunakan untuk order!`,
                            { 
                                parse_mode: 'HTML',
                                reply_markup: {
                                    inline_keyboard: [
                                        [
                                            { 
                                                text: '🛒 Order Sekarang', 
                                                callback_data: 'nokos_menu' 
                                            },
                                            { 
                                                text: '💰 Deposit Lagi', 
                                                callback_data: 'deposit_main' 
                                            }
                                        ]
                                    ]
                                }
                            }
                        );
                        
                        try {
                            const now = new Date();
                            const nowJakarta = new Date(now.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
                            const waktu = nowJakarta.toLocaleString('id-ID');
                            
                            let userInfo = `User ${userId}`;
                            try {
                                const user = await bot.getChat(userId);
                                if (user.username) {
                                    userInfo = `@${user.username}`;
                                } else if (user.first_name) {
                                    userInfo = `${user.first_name}`;
                                }
                            } catch (error) {}
                            
                            await bot.sendMessage(channel,
`💰 <b>DEPOSIT BERHASIL</b>

👤 User: ${userInfo}
🆔 ID: <code>${userId}</code>
💳 Deposit ID: <code>#${depositId}</code>
💰 Jumlah: <b>${formatCurrency(amountToAdd)}</b>
🏦 Metode: QRIS 
💎 Saldo Baru: ${formatCurrency(newBalance)}
📅 Waktu: ${waktu}

✅ <b>STATUS</b>
• Pembayaran berhasil
• Saldo telah ditambahkan
• User dapat menggunakan saldo untuk transaksi

🎉 <b>TERIMA KASIH</b>
Terima kasih telah melakukan deposit di bot kami!`,
                                {
                                    parse_mode: 'HTML',
                                    disable_web_page_preview: true
                                }
                            );
                        } catch (error) {
                            console.error('Gagal mengirim notifikasi deposit ke channel:', error);
                        }
                        
                        setTimeout(() => {
                            balanceLocks.delete(depositLockKey);
                        }, 5000);
                        return;
                    }
                }
                else if (depositStatusLower === 'pending' || depositStatusLower === 'waiting') {
                    if (retryCount < maxRetries) {
                        setTimeout(() => {
                            balanceLocks.delete(depositLockKey);
                            checkDepositStatus(chatId, depositId, userId, messageId, retryCount + 1);
                        }, 10000);
                    } else {
                        updateTransactionStatus(transactionType, depositData.id, 'expired');
                        
                        if (messageId) {
                            try {
                                await bot.deleteMessage(chatId, messageId);
                            } catch (error) {}
                        }
                        
                        await sendNewMessage(chatId,
`<b>⏰ DEPOSIT EXPIRED</b>

<b>📋 TRANSACTION STATUS</b>
• ID Deposit: <code>#${depositId}</code>
• Status: ❌ Kadaluarsa
• Reason: Tidak dibayar dalam 30 menit

<b>🔄 NEXT STEPS</b>
• Buat deposit baru dengan tombol di bawah
• Scan QR code yang baru
• Bayar sesuai nominal
• Saldo masuk otomatis

<b>⚠️ NOTES</b>
• Deposit expired otomatis dibatalkan
• Tidak ada pemotongan saldo
• Transaksi aman dan terjamin`,
                            { 
                                parse_mode: 'HTML',
                                reply_markup: {
                                    inline_keyboard: [
                                        [
                                            { 
                                                text: '💰 Buat Deposit Baru', 
                                                callback_data: 'deposit_main' 
                                            }
                                        ]
                                    ]
                                }
                            }
                        );
                        setTimeout(() => {
                            balanceLocks.delete(depositLockKey);
                        }, 5000);
                    }
                    return;
                }
                else if (depositStatusLower === 'cancelled' || depositStatusLower === 'expired' || depositStatusLower === 'failed' || depositStatusLower === 'cancel') {
                    const statusText = depositStatusLower === 'expired' ? 'KADALUARSA' : 
                                     depositStatusLower === 'cancelled' || depositStatusLower === 'cancel' ? 'DIBATALKAN' : 
                                     'GAGAL';
                    
                    updateTransactionStatus(transactionType, depositData.id, depositStatusLower);
                    
                    if (messageId) {
                        try {
                            await bot.deleteMessage(chatId, messageId);
                        } catch (error) {}
                    }
                    
                    await sendNewMessage(chatId,
`<b>❌ DEPOSIT ${statusText}</b>

<b>📋 TRANSACTION STATUS</b>
• ID Deposit: <code>#${depositId}</code>
• Status: ❌ ${statusText}

<b>🔄 NEXT STEPS</b>
• Buat deposit baru dengan tombol di bawah
• Scan QR code yang baru
• Bayar sesuai nominal

<b>⚠️ NOTES</b>
• Deposit sudah dibatalkan/expired
• Tidak ada pemotongan saldo
• Transaksi aman dan terjamin`,
                        { 
                            parse_mode: 'HTML',
                            reply_markup: {
                                inline_keyboard: [
                                    [
                                        { 
                                            text: '💰 Buat Deposit Baru', 
                                            callback_data: 'deposit_main' 
                                        }
                                    ]
                                ]
                            }
                        }
                    );
                    setTimeout(() => {
                        balanceLocks.delete(depositLockKey);
                    }, 5000);
                    return;
                }
            }
        } catch (error) {
            if (retryCount < maxRetries) {
                setTimeout(() => {
                    balanceLocks.delete(depositLockKey);
                    checkDepositStatus(chatId, depositId, userId, messageId, retryCount + 1);
                }, 10000);
            } else {
                setTimeout(() => {
                    balanceLocks.delete(depositLockKey);
                }, 5000);
            }
            return;
        }
        
        if (retryCount < maxRetries) {
            setTimeout(() => {
                balanceLocks.delete(depositLockKey);
                checkDepositStatus(chatId, depositId, userId, messageId, retryCount + 1);
            }, 10000);
        } else {
            setTimeout(() => {
                balanceLocks.delete(depositLockKey);
            }, 5000);
        }
        
    } catch (error) {
        setTimeout(() => {
            balanceLocks.delete(depositLockKey);
        }, 5000);
    }
}

async function cancelDeposit(chatId, userId, depositId, messageId, callbackQueryId) {
    try {
        const transactions = loadTransactions();
        
        let depositFound = null;
        let depositType = null;
        
        const depositTypes = ['khafa_deposits', 'rumahotp_deposits'];
        for (const type of depositTypes) {
            if (transactions[type]) {
                const deposit = transactions[type].find(d => d.data.id === depositId);
                if (deposit) {
                    depositFound = deposit;
                    depositType = type;
                    break;
                }
            }
        }
        
        if (!depositFound) {
            await sendNewMessage(chatId,
`<b>⚠️ DEPOSIT TIDAK DITEMUKAN</b>

ID Deposit: #${depositId}
Status: Data tidak ditemukan di database lokal.`,
                { parse_mode: 'HTML' }
            );
            return;
        }
        
        if (depositFound.status === 'success' || depositFound.status === 'paid') {
            await bot.answerCallbackQuery(callbackQueryId, {
                text: '❌ Deposit sudah dibayar, tidak bisa dibatalkan',
                show_alert: true
            });
            return;
        }
        
        if (depositFound.status === 'cancelled') {
            await bot.answerCallbackQuery(callbackQueryId, {
                text: '❌ Deposit sudah dibatalkan sebelumnya',
                show_alert: true
            });
            return;
        }
        
        await bot.answerCallbackQuery(callbackQueryId, {
            text: '⏳ Membatalkan deposit...',
            show_alert: false
        });
        
        try {
            await bot.deleteMessage(chatId, messageId);
        } catch (error) {}
        
        userDepositMessages.delete(`${userId}_${depositId}`);
        
        updateTransactionStatus(depositType, depositId, 'cancelled');
        
        await sendNewMessage(chatId,
`<b>✅ DEPOSIT DIBATALKAN</b>

ID Deposit: <code>#${depositId}</code>
Status: ❌ Dibatalkan`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [
                            { 
                                text: '💰 Deposit Lagi', 
                                callback_data: 'deposit_main' 
                            },
                            { 
                                text: '🏠 Menu', 
                                callback_data: 'main_menu' 
                            }
                        ]
                    ]
                }
            }
        );
        
    } catch (error) {
        await bot.answerCallbackQuery(callbackQueryId, {
            text: '❌ Gagal membatalkan deposit',
            show_alert: true
        });
    }
}

async function checkDepositStatusSilent(chatId, depositId, userId, messageId, callbackQueryId) {
    const transactions = loadTransactions();
    const deposit = ['khafa_deposits', 'rumahotp_deposits']
        .flatMap(type => transactions[type] || [])
        .find(d => d.data.id === depositId);
    
    const paymentMethod = deposit?.data?.payment_method || getPaymentMethod();
    
    try {
        let statusResult;
        let statusText = '';
        
        if (paymentMethod === 'khafa') {
            statusResult = await khafaService.checkDepositStatus(depositId);
            
            if (statusResult && statusResult.success) {
                const status = String(statusResult.data.status || '').toLowerCase();
                if (status === 'success' || status === 'paid') {
                    statusText = '✅ Sudah Di bayar';
                } else if (status === 'pending' || status === 'waiting') {
                    statusText = '⏳ Belum di bayar';
                } else if (status === 'expired') {
                    statusText = '⏰ Sudah Kadaluarsa';
                } else if (status === 'cancelled' || status === 'cancel' || status === 'failed') {
                    statusText = '❌ Sudah Di Batalkan';
                } else {
                    statusText = '❓ Status tidak diketahui';
                }
            }
        } else {
            statusResult = await api.checkRumahOTPDepositStatus(depositId);
            
            if (statusResult && statusResult.success) {
                const status = String(statusResult.data.status || '').toLowerCase();
                if (status === 'success' || status === 'paid') {
                    statusText = '✅ Sudah Di bayar';
                } else if (status === 'pending' || status === 'waiting') {
                    statusText = '⏳ Belum di bayar';
                } else if (status === 'expired') {
                    statusText = '⏰ Sudah Kadaluarsa';
                } else if (status === 'cancelled' || status === 'cancel' || status === 'failed') {
                    statusText = '❌ Sudah Di Batalkan';
                } else {
                    statusText = '❓ Status tidak diketahui';
                }
            }
        }
        
        if (!statusText) {
            if (deposit) {
                const dbStatus = String(deposit.status || deposit.data?.status || '').toLowerCase();
                if (dbStatus === 'success' || dbStatus === 'paid') {
                    statusText = '✅ Sudah Di bayar';
                } else if (dbStatus === 'pending' || dbStatus === 'waiting') {
                    statusText = '⏳ Belum di bayar';
                } else if (dbStatus === 'expired') {
                    statusText = '⏰ Sudah Kadaluarsa';
                } else if (dbStatus === 'cancelled' || dbStatus === 'cancel' || dbStatus === 'failed') {
                    statusText = '❌ Sudah Di Batalkan';
                } else {
                    statusText = '❓ Status tidak diketahui';
                }
            } else {
                statusText = '❌ Deposit tidak ditemukan';
            }
        }
        
        await bot.answerCallbackQuery(callbackQueryId, {
            text: statusText,
            show_alert: true
        });
        
    } catch (error) {
        await bot.answerCallbackQuery(callbackQueryId, {
            text: '❌ Error memeriksa status',
            show_alert: true
        });
    }
}

async function showOrderHistory(chatId, userId, messageId, callbackQueryId) {
    try {
        const transactions = loadTransactions();
        
        if (!transactions || typeof transactions !== 'object') {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ ERROR DATA TRANSAKSI</b>

Database transaksi tidak valid.
Silakan hubungi admin.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '📜 Menu Riwayat', 
                                    callback_data: 'history_menu' 
                                }
                            ]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        const allOrders = transactions.nokos_orders || [];
        
        const userOrders = allOrders.filter(order => {
            if (!order || !order.userId) return false;
            return String(order.userId) === String(userId);
        });
        
        if (userOrders.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>📋 RIWAYAT ORDER</b>

User ID: <code>${userId}</code>
Total Order: 0
Total Semua Order di Sistem: ${allOrders.length}
Status: Belum Ada Riwayat

<b>⚠️ INFORMASI</b>
Anda belum pernah melakukan order.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🛒 Buat Order', 
                                    callback_data: 'nokos_menu' 
                                }
                            ],
                            [
                                { 
                                    text: '📜 Menu Riwayat', 
                                    callback_data: 'history_menu' 
                                }
                            ]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const recentOrders = userOrders
            .sort((a, b) => {
                const timeA = a.timestamp ? new Date(a.timestamp).getTime() : 0;
                const timeB = b.timestamp ? new Date(b.timestamp).getTime() : 0;
                return timeB - timeA;
            })
            .slice(0, 20);
        
        let message = `<b>📋 RIWAYAT ORDER ANDA</b>

User ID: <code>${userId}</code>
Total Order Anda: ${userOrders.length}
Total Semua Order di Sistem: ${allOrders.length}
Ditampilkan: ${Math.min(recentOrders.length, 20)}/20 terbaru

<b>📱 DAFTAR ORDER</b>
Urutan dari terbaru:
`;
        
        recentOrders.forEach((order, index) => {
            if (!order) return;
            
            const orderData = order.data || order;
            const date = order.timestamp ? new Date(order.timestamp).toLocaleString('id-ID') : 'Tanpa tanggal';
            const maskedPhone = maskPhoneNumber(orderData.phoneNumber || orderData.phone_number || '0000000000');
            
            const status = order.status || orderData.status || 'unknown';
            const otpReceived = orderData.otp_received === true;
            const otpCode = orderData.otp_code || '-';
            
            let statusEmoji = '❓';
            let statusText = 'Unknown';
            
            if (status === 'completed' || otpReceived) {
                statusEmoji = '✅';
                statusText = 'Selesai';
            } else if (status === 'cancelled' || status === 'canceled') {
                statusEmoji = '❌';
                statusText = 'Dibatalkan';
            } else if (status === 'expired') {
                statusEmoji = '⏰';
                statusText = 'Expired';
            } else if (status === 'active' || status === 'pending') {
                statusEmoji = '⏳';
                statusText = 'Aktif';
            }
            
            const price = orderData.total || orderData.price || 0;
            const orderId = orderData.orderId || order.id || 'N/A';
            const serviceName = orderData.service || 'Nokos';
            
            message += `<b>${index + 1}. ${serviceName}</b>\n`;
            message += `ID: <code>#${orderId}</code>\n`;
            message += `Nomor: ${maskedPhone}\n`;
            message += `Harga: ${formatCurrency(price)}\n`;
            message += `Status: ${statusEmoji} ${statusText}\n`;
            message += `OTP: ${otpCode}\n`;
            message += `Tanggal: ${date}\n\n`;
        });

        await editMessage(chatId, messageId, callbackQueryId, message, {
            parse_mode: 'HTML',
            disable_web_page_preview: true,
            reply_markup: {
                inline_keyboard: [
                    [
                        { 
                            text: '🛒 Order Baru', 
                            callback_data: 'nokos_menu' 
                        },
                        { 
                            text: '🔄 Refresh', 
                            callback_data: 'order_history' 
                        }
                    ],
                    [
                        { 
                            text: '📜 Menu Riwayat', 
                            callback_data: 'history_menu' 
                        }
                    ]
                ]
            }
        });

    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MEMUAT RIWAYAT</b>

Error: ${error.message || 'Unknown error'}

<b>⚠️ TINDAKAN</b>
Silakan coba lagi atau hubungi CS.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [
                            { 
                                text: '🔄 Coba Lagi', 
                                callback_data: 'order_history' 
                            }
                        ],
                        [
                            { 
                                text: '📜 Menu Riwayat', 
                                callback_data: 'history_menu' 
                            }
                        ]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

async function showDepositHistory(chatId, userId, messageId, callbackQueryId) {
    try {
        const transactions = loadTransactions();
        
        if (!transactions || typeof transactions !== 'object') {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ ERROR DATA TRANSAKSI</b>

Database transaksi tidak valid.
Silakan hubungi admin.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '📜 Menu Riwayat', 
                                    callback_data: 'history_menu' 
                                }
                            ]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        const allDeposits = [
            ...(transactions.rumahotp_deposits || []),
            ...(transactions.khafa_deposits || [])
        ];
        
        const userDeposits = allDeposits.filter(deposit => {
            if (!deposit || !deposit.userId) return false;
            return String(deposit.userId) === String(userId);
        });
        
        const totalAllDeposits = allDeposits.length;
        const totalUserDeposits = userDeposits.length;
        
        if (userDeposits.length === 0) {
            await editMessage(chatId, messageId, callbackQueryId,
`<b>💰 RIWAYAT DEPOSIT</b>

User ID: <code>${userId}</code>
Total Deposit Anda: 0
Total Semua Deposit di Sistem: ${totalAllDeposits}
Status: Belum Ada Riwayat

<b>⚠️ INFORMASI</b>
Anda belum pernah melakukan deposit.`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '💰 Deposit', 
                                    callback_data: 'deposit_main' 
                                }
                            ],
                            [
                                { 
                                    text: '📜 Menu Riwayat', 
                                    callback_data: 'history_menu' 
                                }
                            ]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }

        const successfulDeposits = userDeposits.filter(deposit => {
            const status = deposit.status || (deposit.data && deposit.data.status);
            return status === 'success' || status === 'paid';
        });
        
        successfulDeposits.sort((a, b) => {
            const timeA = a.timestamp ? new Date(a.timestamp).getTime() : 0;
            const timeB = b.timestamp ? new Date(b.timestamp).getTime() : 0;
            return timeB - timeA;
        });
        
        const recentDeposits = successfulDeposits.slice(0, 20);
        
        let message = `<b>💰 RIWAYAT DEPOSIT ANDA</b>

User ID: <code>${userId}</code>
Total Deposit Anda: ${totalUserDeposits}
Total Sukses: ${successfulDeposits.length}
Total Semua Deposit di Sistem: ${totalAllDeposits}
Ditampilkan: ${Math.min(recentDeposits.length, 20)}/20 terbaru

<b>📋 DAFTAR DEPOSIT</b>
Urutan dari terbaru:
`;
        
        recentDeposits.forEach((deposit, index) => {
            if (!deposit) return;
            
            const depositData = deposit.data || deposit;
            const date = deposit.timestamp ? new Date(deposit.timestamp).toLocaleString('id-ID') : 'Tanpa tanggal';
            
            let amount = 0;
            let received = 0;
            
            if (depositData.saldo_didapat) {
                amount = depositData.saldo_didapat;
                received = depositData.saldo_didapat;
            } else if (depositData.amount) {
                amount = depositData.amount;
                received = depositData.amount;
            } else if (depositData.total) {
                amount = depositData.total;
                received = depositData.total;
            }
            
            if (amount === 0 || isNaN(amount)) {
                return;
            }
            
            const depositId = depositData.id || depositData.no_inv || deposit.id || 'N/A';
            const status = deposit.status || depositData.status || 'unknown';
            
            message += `<b>${index + 1}. Deposit ${formatCurrency(amount)}</b>\n`;
            message += `ID Deposit: #${depositId}\n`;
            message += `Jumlah: ${formatCurrency(amount)}\n`;
            message += `Diterima: ${formatCurrency(received)}\n`;
            message += `Status: ${status === 'success' || status === 'paid' ? '✅' : '❌'} ${status}\n`;
            message += `Tanggal: ${date}\n\n`;
        });

        await editMessage(chatId, messageId, callbackQueryId, message, {
            parse_mode: 'HTML',
            disable_web_page_preview: true,
            reply_markup: {
                inline_keyboard: [
                    [
                        { 
                            text: '💰 Deposit Lagi', 
                            callback_data: 'deposit_main' 
                        },
                        { 
                            text: '🔄 Refresh', 
                            callback_data: 'deposit_history' 
                        }
                    ],
                    [
                        { 
                            text: '📜 Menu Riwayat', 
                            callback_data: 'history_menu' 
                        }
                    ]
                ]
            }
        });

    } catch (error) {
        await editMessage(chatId, messageId, callbackQueryId,
`<b>❌ GAGAL MEMUAT RIWAYAT</b>

Error: ${error.message || 'Unknown error'}

<b>⚠️ TINDAKAN</b>
Silakan coba lagi atau hubungi CS.`,
            { 
                parse_mode: 'HTML',
                reply_markup: {
                    inline_keyboard: [
                        [
                            { 
                                text: '🔄 Coba Lagi', 
                                callback_data: 'deposit_history' 
                            }
                        ],
                        [
                            { 
                                text: '📜 Menu Riwayat', 
                                callback_data: 'history_menu' 
                            }
                        ]
                    ]
                },
                disable_web_page_preview: true
            }
        );
    }
}

bot.on('callback_query', async (callbackQuery) => {
    const msg = callbackQuery.message;
    const user = callbackQuery.from;
    const data = callbackQuery.data;
    const callbackQueryId = callbackQuery.id;
    
    if (!msg || !user || !data) {
        try {
            await bot.answerCallbackQuery(callbackQueryId, {
                text: 'Error: Data tidak valid',
                show_alert: true
            });
        } catch (e) {}
        return;
    }
    
    const userId = user.id.toString();
    const chatId = msg.chat.id;
    const messageId = msg.message_id;
    
    try {
        await bot.answerCallbackQuery(callbackQueryId, { 
            text: '',
            show_alert: false 
        });
        
        if (data === 'main_menu') {
            await showMainMenu(chatId, user.id, user, messageId);
            return;
        }
        
        if (data === 'nokos_menu') {
            await showNokosMenu(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'nokos_other_services') {
            await showOtherServices(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('nokos_service_')) {
            const serviceId = data.replace('nokos_service_', '');
            const servicesData = await getServicesCached(); 
            if (servicesData && servicesData.success) {
                const service = servicesData.data.find(s => s.service_code == serviceId);
                if (service) {
                    await showCountryMenu(chatId, user.id, serviceId, service.service_name, messageId, callbackQueryId);
                }
            }
            return;
        }
        
        if (data === 'nokos_all_services') {
            await showAllServices(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('all_services_page_')) {
            const page = parseInt(data.replace('all_services_page_', ''));
            await showAllServices(chatId, user.id, messageId, callbackQueryId, page);
            return;
        }
        
        if (data.startsWith('search_country_input_')) {
            const serviceId = data.replace('search_country_input_', '');
            userSelections.set(user.id.toString(), {
                step: 'search_country',
                serviceId: serviceId,
                chatId: chatId,
                messageId: messageId
            });
            
            await editMessage(chatId, messageId, callbackQueryId,
`<b>🔍 PENCARIAN NEGARA</b>

Masukkan nama negara yang ingin dicari
Contoh: indonesia, singapore, malaysia, dll

<b>⚠️ CATATAN</b>
• Pencarian tidak case-sensitive
• Cari berdasarkan nama negara
• Minimal 2 karakter

<b>❌ BATALKAN</b>
Ketik /start untuk membatalkan`,
                {
                    parse_mode: 'HTML',
                    disable_web_page_preview: true,
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔙 Kembali ke Daftar Negara', 
                                    callback_data: `nokos_service_${serviceId}` 
                                }
                            ]
                        ]
                    }
                }
            );
            return;
        }
        
        if (data.startsWith('search_country_results_')) {
            const parts = data.replace('search_country_results_', '').split('_');
            const serviceId = parts[0];
            const searchQuery = decodeURIComponent(parts[1]);
            const page = parseInt(parts[2]);
            await showSearchCountryResults(chatId, user.id, serviceId, searchQuery, messageId, callbackQueryId, page);
            return;
        }
        
        if (data === 'search_services_input') {
            userSelections.set(user.id.toString(), {
                step: 'search_services',
                chatId: chatId,
                messageId: messageId
            });
            
            await editMessage(chatId, messageId, callbackQueryId,
`<b>🔍 PENCARIAN LAYANAN</b>

Masukkan nama layanan yang ingin dicari
Contoh: gmail, whatsapp, telegram, tiktok, dll

<b>⚠️ CATATAN</b>
• Pencarian tidak case-sensitive
• Cari berdasarkan kata kunci
• Minimal 2 karakter

<b>❌ BATALKAN</b>
Ketik /start untuk membatalkan`,
                {
                    parse_mode: 'HTML',
                    disable_web_page_preview: true,
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔙 Kembali ke Menu Layanan', 
                                    callback_data: 'nokos_menu' 
                                }
                            ]
                        ]
                    }
                }
            );
            return;
        }
        
        if (data.startsWith('broadcast_')) {
            try {
                const parts = data.split('_');
                if (parts.length < 5) {
                    throw new Error('Format data broadcast tidak valid');
                }
                
                const mode = parts[1];
                const originalChatId = parts[2];
                const replyMsgId = parts[3];
                const ownerId = parts[4];
                const fromId = userId;
                
                if (fromId !== ownerId) {
                    return await bot.answerCallbackQuery(callbackQueryId, { 
                        text: '❌ Tombol ini bukan untuk kamu!', 
                        show_alert: true 
                    });
                }

                await bot.editMessageReplyMarkup(
                    { inline_keyboard: [] },
                    { chat_id: chatId, message_id: messageId }
                ).catch(() => {});
                
                await bot.answerCallbackQuery(callbackQueryId, { 
                    text: '⏳ Memproses broadcast...', 
                    show_alert: false 
                });

                const store = loadData();
                const uniqueUsers = [...new Set(store.users || [])];
                const total = uniqueUsers.length;
                
                if (total === 0) {
                    return await bot.sendMessage(chatId, 
`<b>❌ TIDAK ADA USER</b>

Total User: 0`,
                        { 
                            parse_mode: "HTML",
                            disable_web_page_preview: true 
                        }
                    ).catch(() => {});
                }

                let sukses = 0;
                let gagal = 0;
                let processed = 0;

                const statusMsg = await bot.sendMessage(
                    chatId,
                    `<b>📢 BROADCAST KE USER</b>

Total User: <code>${total}</code>
Status: <code>Memulai...</code>
Progress: <code>0/${total} (0%)</code>
Metode: <code>${mode === "copy" ? "Copy" : "Forward"}</code>

<b>📊 PROGRESS</b>
[░░░░░░░░░░] 0%`,
                    { 
                        parse_mode: "HTML",
                        disable_web_page_preview: true 
                    }
                );

                for (const targetUserId of uniqueUsers) {
                    try {
                        if (mode === "copy") {
                            await bot.copyMessage(targetUserId, originalChatId, parseInt(replyMsgId));
                        } else {
                            await bot.forwardMessage(targetUserId, originalChatId, parseInt(replyMsgId));
                        }
                        sukses++;
                    } catch (error) {
                        gagal++;
                    }
                    processed++;

                    if (processed % 5 === 0 || processed === total) {
                        const progress = Math.round((processed / total) * 100);
                        const progressBar = createProgressBar(progress);
                        try {
                            await bot.editMessageText(
                                `<b>📢 BROADCAST KE USER</b>

Total User: <code>${total}</code>
Status: <code>Berjalan...</code>
Progress: <code>${processed}/${total} (${progress}%)</code>
Berhasil: <code>${sukses}</code>
Gagal: <code>${gagal}</code>
Metode: <code>${mode === "copy" ? "Copy" : "Forward"}</code>

<b>📊 PROGRESS</b>
${progressBar} ${progress}%`,
                                {
                                    chat_id: chatId,
                                    message_id: statusMsg.message_id,
                                    parse_mode: "HTML",
                                    disable_web_page_preview: true
                                }
                            );
                        } catch (e) {}
                    }
                    
                    await new Promise((r) => setTimeout(r, 200));
                }

                const successRate = total > 0 ? Math.round((sukses / total) * 100) : 0;
                const successEmoji = successRate >= 80 ? '✅' : successRate >= 50 ? '⚠️' : '❌';

                await bot.editMessageText(
                    `<b>✅ BROADCAST SELESAI</b>

Total User: <code>${total}</code>
Berhasil: <code>${sukses}</code>
Gagal: <code>${gagal}</code>
Metode: <code>${mode === "copy" ? "Copy" : "Forward"}</code>

<b>📊 STATISTIK DETAIL</b>
📈 Success Rate: ${successEmoji} ${successRate}%
👤 Owner: ${user.first_name || 'Admin'}
🕐 Waktu: ${new Date().toLocaleString('id-ID')}

<i>Pesan terkirim ke ${sukses} user</i>`, 
                    {
                        chat_id: chatId,
                        message_id: statusMsg.message_id,
                        parse_mode: "HTML",
                        disable_web_page_preview: true
                    }
                );

                store.cooldowns = store.cooldowns || {};
                store.cooldowns.broadcast = store.cooldowns.broadcast || {};
                store.cooldowns.broadcast[userId] = Math.floor(Date.now() / 1000);
                saveData(store);

                return; 
                
            } catch (err) {
                await bot.sendMessage(chatId, 
                    `<b>❌ ERROR BROADCAST</b>
Status: <code>Proses gagal</code>
Error: ${err.message || 'Unknown error'}

Solusi: <code>Coba lagi nanti</code>`, 
                    { 
                        parse_mode: "HTML",
                        disable_web_page_preview: true 
                    }
                );
                return;
            }
        }
        
        if (data.startsWith('search_results_')) {
            const parts = data.replace('search_results_', '').split('_');
            const searchQuery = decodeURIComponent(parts[0]);
            const page = parseInt(parts[1]);
            await showSearchResults(chatId, user.id, searchQuery, messageId, callbackQueryId, page);
            return;
        }
        
        if (data === 'setpay_khafa') {
            if (!owner_ids.includes(user.id.toString())) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '<b>❌ No Permission</b>',
                    show_alert: true
                });
                return;
            }
            setPaymentMethod('khafa');
            await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ METODE PEMBAYARAN DIUBAH</b>

Rumah OTP: ❌ Nonaktif
Khafa: ✅ Aktif`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🏦 RUMAH OTP', 
                                    callback_data: 'setpay_rumahotp' 
                                },
                                { 
                                    text: '💳 KHAFA', 
                                    callback_data: 'setpay_khafa' 
                                }
                            ]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        if (data === 'setpay_rumahotp') {
            if (!owner_ids.includes(user.id.toString())) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '<b>❌ No Permission</b>',
                    show_alert: true
                });
                return;
            }
            setPaymentMethod('rumahotp');
            await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ METODE PEMBAYARAN DIUBAH</b>

Rumah OTP: ✅ Aktif
Khafa: ❌ Nonaktif`,
                { 
                    parse_mode: 'HTML',
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🏦 RUMAH OTP', 
                                    callback_data: 'setpay_rumahotp' 
                                },
                                { 
                                    text: '💳 KHAFA', 
                                    callback_data: 'setpay_khafa' 
                                }
                            ]
                        ]
                    },
                    disable_web_page_preview: true
                }
            );
            return;
        }
        
        if (data.startsWith('nokos_country_page_')) {
            const parts = data.replace('nokos_country_page_', '').split('_');
            const serviceId = parts[0];
            const page = parseInt(parts[1]);
            const servicesData = await getServicesCached();
            if (servicesData && servicesData.success) {
                const service = servicesData.data.find(s => s.service_code == serviceId);
                if (service) {
                    await showCountryMenu(chatId, user.id, serviceId, service.service_name, messageId, callbackQueryId, page);
                }
            }
            return;
        }
        
        if (data.startsWith('nokos_server_list_')) {
            try {
                const parts = data.replace('nokos_server_list_', '').split('_');
                if (parts.length < 2) {
                    throw new Error('Format data server tidak valid');
                }
                const numberId = parts[0];
                const countryName = decodeURIComponent(parts.slice(1).join('_'));
                await showServerList(chatId, user.id, numberId, countryName, messageId, callbackQueryId);
            } catch (error) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Error memproses pilihan server',
                    show_alert: true
                });
            }
            return;
        }
        
        if (data.startsWith('nokos_server_')) {
            try {
                const parts = data.replace('nokos_server_', '').split('_');
                if (parts.length < 3) {
                    throw new Error('Format data server tidak valid');
                }
                const providerId = parts[0];
                const price = parts[1];
                const rate = parts[2];
                const userSelection = userSelections.get(user.id) || {};
                userSelection.providerId = providerId;
                userSelection.price = price;
                userSelection.rate = rate;
                userSelections.set(user.id, userSelection);
                await showOperatorMenu(chatId, user.id, userSelection.numberId, price, userSelection.countryName, messageId, callbackQueryId);
            } catch (error) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Error memilih server',
                    show_alert: true
                });
            }
            return;
        }
        
        if (data.startsWith('nokos_operator_')) {
            const parts = data.replace('nokos_operator_', '').split('_');
            const operatorId = parts[0];
            const providerId = parts[1];
            const price = parts[2];
            await showOrderConfirmation(chatId, user.id, operatorId, providerId, price, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'owner_menu') {
            await showOwnerMenu(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('nokos_confirm_')) {
            const parts = data.replace('nokos_confirm_', '').split('_');
            
            if (parts.length >= 3) {
                const numberId = parts[0];
                const providerId = parts[1];
                const operatorId = parts[2];
                const price = parts[3];
                
                await processNokosOrder(chatId, user.id, numberId, providerId, operatorId, price, messageId, callbackQueryId);
            }
            return;
        }
        
        if (data === 'voucher_menu') {
            await showVoucherMenu(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'show_claim_voucher') {
            await showClaimVoucherInfo(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'check_voucher_discount') {
            await showVoucherDiscount(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('server_prev_')) {
            const parts = data.replace('server_prev_', '').split('_');
            const numberId = parts[0];
            const countryName = decodeURIComponent(parts.slice(1, parts.length - 1).join('_'));
            const startIndex = parseInt(parts[parts.length - 1]);
            await showServerListEnhanced(chatId, user.id, numberId, countryName, messageId, callbackQueryId, startIndex);
            return;
        }
        
        if (data.startsWith('server_next_')) {
            const parts = data.replace('server_next_', '').split('_');
            const numberId = parts[0];
            const countryName = decodeURIComponent(parts.slice(1, parts.length - 1).join('_'));
            const startIndex = parseInt(parts[parts.length - 1]);
            await showServerListEnhanced(chatId, user.id, numberId, countryName, messageId, callbackQueryId, startIndex);
            return;
        }
        
        if (data.startsWith('nokos_check_')) {
            const orderId = data.replace('nokos_check_', '');
            await checkOTP(chatId, orderId, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('nokos_cancel_')) {
            const orderId = data.replace('nokos_cancel_', '');
            await cancelOrder(chatId, user.id, orderId, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'deposit_main') {
            await showDepositMenu(chatId, user.id, messageId, callbackQueryId);
            return;
        }

if (data === 'history_menu') {
    await showHistoryMenu(chatId, user.id, messageId, callbackQueryId);
    return;
}

if (data === 'top_saldo_public') {
    await showTopSaldoPublic(chatId, user.id, messageId, callbackQueryId);
    return;
}

if (data === 'top_order_public') {
    await showTopOrderPublic(chatId, user.id, messageId, callbackQueryId);
    return;
}

if (data === 'top_point_public') {
    await showTopPointPublic(chatId, user.id, messageId, callbackQueryId);
    return;
}

        if (data === 'order_history') {
            await showOrderHistory(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'deposit_custom') {
            userSelections.set(user.id.toString(), {
                step: 'custom_deposit_waiting_amount',
                chatId: chatId,
                messageId: messageId
            });
            
            await editMessage(chatId, messageId, callbackQueryId,
`<b>🔢 DEPOSIT CUSTOM</b>

Masukkan jumlah deposit yang diinginkan
Format: Angka saja (contoh: 25000)

<b>📋 ATURAN</b>
Minimal: Rp 2.000
Maksimal: Rp 5.000.000

<b>❌ BATALKAN</b>
Ketik /start untuk membatalkan

<b>💡 CONTOH</b>
25000 (untuk Rp 25.000)`,
                {
                    parse_mode: 'HTML',
                    disable_web_page_preview: true,
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { 
                                    text: '🔙 Kembali ke Menu Deposit', 
                                    callback_data: 'deposit_main' 
                                }
                            ]
                        ]
                    }
                }
            );
            return;
        }
        
        if (data.startsWith('confirm_withdraw_')) {
            const withdrawData = data.replace('confirm_withdraw_', '');
            const [targetNumber, nominal] = withdrawData.split('_');
            await processWithdraw(chatId, user.id, targetNumber, parseInt(nominal), messageId, callbackQueryId);
            return;
        }
        
        if (data === 'menu_products') {
            await showProductsMenu(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('buy_')) {
            const productCode = data.replace('buy_', '');
            await showProductPaymentOptions(chatId, user.id, productCode, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('pay_product_')) {
            const parts = data.replace('pay_product_', '').split('_');
            const productCode = parts[0];
            const paymentMethod = parts[1];
            await processProductPayment(chatId, user.id, productCode, paymentMethod, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('cancel_product_')) {
            const paymentId = data.replace('cancel_product_', '');
            await handleCancelProductPayment(chatId, paymentId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('check_product_status_')) {
            const paymentId = data.replace('check_product_status_', '');
            await checkProductPaymentStatus(chatId, paymentId, null, userId);
            await bot.answerCallbackQuery(callbackQueryId, {
                text: '⏳ Memeriksa status pembayaran...',
                show_alert: false
            });
            return;
        }
        
        if (data.startsWith('confirm_product_')) {
            const parts = data.replace('confirm_product_', '').split('_');
            const productCode = parts[0];
            const paymentMethod = parts[1];
            await processProductPayment(chatId, user.id, productCode, paymentMethod, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('confirm_saldo_')) {
            const productCode = data.replace('confirm_saldo_', '');
            const productDB = loadDataProduct();
            let productFound = null;
            let productId = null;
            
            for (const [id, product] of Object.entries(productDB.products)) {
                if (product.buyCode.toLowerCase() === productCode.toLowerCase()) {
                    productFound = product;
                    productId = id;
                    break;
                }
            }
            
            if (!productFound) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Produk tidak ditemukan',
                    show_alert: true
                });
                return;
            }
            
            if (productFound.stock <= 0) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Stok habis',
                    show_alert: true
                });
                return;
            }
            
            const userBalance = getUserBalance(userId);
            const additionalFee = Number(product_fee) || 0;
            const totalPrice = productFound.price + additionalFee;
            
            if (userBalance < totalPrice) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Saldo tidak cukup',
                    show_alert: true
                });
                return;
            }
            
            const deductionSuccess = deductUserBalance(userId, totalPrice);
            
            if (!deductionSuccess) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Gagal memotong saldo',
                    show_alert: true
                });
                return;
            }
            
            const stockSuccess = await decreaseProductStock(productId);
            if (!stockSuccess) {
                addUserBalance(userId, totalPrice);
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Stok tidak tersedia',
                    show_alert: true
                });
                return;
            }
            
            const orderId = `SALDO_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`;
            
            await notifyOwnerProductCreated(
                userId,
                productFound.name,
                productFound.price,
                totalPrice,
                orderId,
                productFound.buyCode
            );
            
            await notifyChannelProductSuccess(
                userId,
                productFound,
                orderId,
                productFound.price
            );
            
            await editMessage(chatId, messageId, callbackQueryId,
`<b>✅ PEMBAYARAN BERHASIL</b>

━━━━━━━━━━━━━━━━━━━

<b>Produk:</b> ${productFound.name}
<b>Harga:</b> ${formatCurrency(productFound.price)}
<b>Admin Fee:</b> ${formatCurrency(additionalFee)}
<b>Total Bayar:</b> ${formatCurrency(totalPrice)}
<b>Kode:</b> <code>${productFound.buyCode}</code>
<b>Order ID:</b> <code>#${orderId}</code>

━━━━━━━━━━━━━━━━━━━

<b>💰 SALDO SEKARANG</b>
${formatCurrency(getUserBalance(userId))}

━━━━━━━━━━━━━━━━━━━

<b>🔄 Mengirim file...</b>`,
                { 
                    parse_mode: "HTML",
                    reply_markup: {
                        inline_keyboard: [
                            [
                                { text: "🛒 Belanja Lagi", callback_data: "menu_products" },
                                { text: "🏠 Menu Utama", callback_data: "main_menu" }
                            ]
                        ]
                    }
                }
            );
            
            await sendProductFileToUser(chatId, userId, productFound, orderId);
            return;
        }
        
        if (data === 'points_menu') {
            await showPointsMenu(chatId, userId, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'redeem_points') {
            await redeemUserPoints(chatId, userId, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'deposit_history') {
            await showDepositHistory(chatId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('deposit_status_')) {
            const depositId = data.replace('deposit_status_', '');
            await checkDepositStatusSilent(chatId, depositId, user.id, messageId, callbackQueryId);
            return;
        }
        
        if (data.startsWith('deposit_cancel_')) {
            const depositId = data.replace('deposit_cancel_', '');
            const transactions = loadTransactions();
            
            let depositFound = null;
            for (const type of ['khafa_deposits', 'rumahotp_deposits']) {
                if (transactions[type]) {
                    const deposit = transactions[type].find(d => d.data.id === depositId);
                    if (deposit) {
                        depositFound = deposit;
                        break;
                    }
                }
            }
            
            if (depositFound && (depositFound.status === 'success' || depositFound.status === 'paid')) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Deposit sudah dibayar, tidak bisa dibatalkan',
                    show_alert: true
                });
                return;
            }
            
            if (depositFound && depositFound.status === 'cancelled') {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '❌ Deposit sudah dibatalkan sebelumnya',
                    show_alert: true
                });
                return;
            }
            
            await bot.answerCallbackQuery(callbackQueryId, {
                text: '⏳ Membatalkan deposit...',
                show_alert: false
            });
            
            await cancelDeposit(chatId, user.id, depositId, messageId, callbackQueryId);
            return;
        }
        
        if (data === 'refresh_maintenance') {
            const maintenance = getMaintenanceInfo();
            
            if (maintenance.active) {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: `⛔ Masih dalam maintenance\nAlasan: ${maintenance.reason || 'Tidak ada alasan'}`,
                    show_alert: true
                });
            } else {
                await bot.answerCallbackQuery(callbackQueryId, {
                    text: '✅ Maintenance sudah selesai',
                    show_alert: true
                });
                
                try {
                    await bot.editMessageReplyMarkup(
                        { inline_keyboard: [] },
                        { chat_id: chatId, message_id: messageId }
                    );
                    
                    await bot.editMessageText(
                        `<b>✅ BOT SUDAH AKTIF KEMBALI</b>

⚙️ Status: <b>Tersedia</b>
✅ Anda sudah bisa menggunakan bot kembali.

<b>📞 Kontak Owner</b>
@${usernamelu.replace('@','')}`,
                        {
                            chat_id: chatId,
                            message_id: messageId,
                            parse_mode: 'HTML',
                            disable_web_page_preview: true
                        }
                    );
                } catch (error) {}
            }
            return;
        }
        
        if (data.startsWith('deposit_amount_')) {
            const amount = data.replace('deposit_amount_', '');
            userSelections.delete(user.id);
            await bot.deleteMessage(chatId, messageId).catch(() => {});
            await handleDeposit(chatId, user.id, parseInt(amount));
            return;
        }
        
        await bot.answerCallbackQuery(callbackQueryId, { 
            text: '❌ Tombol tidak dikenali', 
            show_alert: false 
        });
        
    } catch (error) {
        try {
            await bot.answerCallbackQuery(callbackQueryId, {
                text: '❌ Terjadi kesalahan, coba lagi',
                show_alert: true
            });
        } catch (e) {
            try {
                await sendNewMessage(chatId,
`<b>❌ TERJADI KESALAHAN</b>

${error.message || 'Unknown error'}`,
                    { 
                        parse_mode: 'HTML',
                        reply_markup: {
                            inline_keyboard: [
                                [
                                    { 
                                        text: '🔄 Coba Lagi', 
                                        callback_data: 'main_menu' 
                                    }
                                ]
                            ]
                        },
                        disable_web_page_preview: true
                    }
                );
            } catch (e) {}
        }
    }
});

const servicesCache = {
  data: null,
  timestamp: 0,
  ttl: 2 * 60 * 1000,
  loading: false
};

async function getServicesCached() {
  const now = Date.now();
  
  if (servicesCache.data && (now - servicesCache.timestamp < servicesCache.ttl)) {
    return servicesCache.data;
  }
  
  if (servicesCache.loading) {
    return servicesCache.data || { success: false, data: [] };
  }
  
  servicesCache.loading = true;
  
  try {
    const servicesData = await api.getServices();
    if (servicesData && servicesData.success) {
      servicesCache.data = servicesData;
      servicesCache.timestamp = now;
    }
    return servicesData;
  } catch (error) {
    return servicesCache.data || { success: false, data: [] };
  } finally {
    servicesCache.loading = false;
  }
}

async function preloadAllData() {
  try {
    await getServicesCached();
    
    const balances = loadBalances();
    Object.entries(balances).forEach(([userId, balance]) => {
      balanceCache.set(userId, parseInt(balance) || 0);
    });
    
    loadTransactions();
  } catch (error) {}
}

preloadAllData();

async function sendRefundNotification(chatId, orderId, refundAmount, refundType = 'auto') {
    try {
        const message = refundType === 'auto' ? 
`✅ <b>REFUND OTOMATIS</b>

Order: <code>#${orderId}</code>
Jumlah: ${formatCurrency(refundAmount)}

Alasan: OTP tidak diterima dalam 15 menit
Saldo sudah dikembalikan ke akun Anda.` : 
`✅ <b>REFUND MANUAL</b>

Order: <code>#${orderId}</code>
Jumlah: ${formatCurrency(refundAmount)}

Alasan: Dibatalkan oleh user
Saldo sudah dikembalikan ke akun Anda.`;

        await bot.sendMessage(chatId, message, {
            parse_mode: 'HTML',
            disable_web_page_preview: true,
            reply_markup: {
                inline_keyboard: [
                    [
                        { 
                            text: '🛒 Order Lagi', 
                            callback_data: 'nokos_menu' 
                        }
                    ]
                ]
            }
        });
        
    } catch (error) {
    }
}

async function notifyOwnerVoucherClaim(userId, voucherCode, discount) {
  try {
    const user = await bot.getChat(userId).catch(() => ({ 
      first_name: 'User',
      username: 'tidak ada'
    }));
    
    for (const ownerId of owner_ids) {
      await bot.sendMessage(ownerId,
`<b>🎟️ VOUCHER DIKLAIM</b>

<b>👤 USER</b>
ID: ${userId}
Nama: ${user.first_name}
Username: ${user.username || 'tidak ada'}

<b>🎫 VOUCHER</b>
Kode: ${voucherCode}
Diskon: ${discount}%

<b>🕐 WAKTU</b>
${new Date().toLocaleString('id-ID')}`,
        { parse_mode: 'HTML' }
      ).catch(() => {});
    }
  } catch (error) {
  }
}

async function notifyOwnerProductCreated(userId, productName, price, total, orderId, productCode, discountAmount = 0) {
    try {
        const user = await bot.getChat(userId).catch(() => ({ 
            first_name: 'User',
            username: 'tidak ada'
        }));
        
        const discountInfo = discountAmount > 0 ? 
            `\n💎 Diskon Voucher: ${formatCurrency(discountAmount)}` : '';
        
        for (const ownerId of owner_ids) {
            await bot.sendMessage(ownerId,
`<b>🛍️ PRODUK DIBELI</b>

<b>👤 PEMBELI</b>
ID: ${userId}
Nama: ${user.first_name}
Username: ${user.username || 'tidak ada'}

<b>📦 PRODUK</b>
Nama: ${productName}
Kode: ${productCode}
Harga: ${formatCurrency(price)}${discountInfo}
Total: ${formatCurrency(total)}
ID Order: <code>#${orderId}</code>

<b>💰 PEMBAYARAN</b>
Metode: Saldo Bot
Status: ✅ Berhasil

<b>🕐 WAKTU</b>
${new Date().toLocaleString('id-ID')}`,
                { parse_mode: 'HTML' }
            ).catch(() => {});
        }
    } catch (error) {
    }
}

async function notifyChannelNewProduct(productName, price, stock, description, productCode) {
    try {
        const dateStr = new Date().toLocaleString('id-ID', { 
            day: 'numeric', 
            month: 'short', 
            year: 'numeric', 
            hour: '2-digit', 
            minute: '2-digit' 
        });
        
        const channelMessage = `<b>🆕 PRODUK BARU TELAH DITAMBAHKAN!</b>

<b>NAMA PRODUK:</b> ${productName}
<b>HARGA:</b> ${formatCurrency(price)}
<b>STOK:</b> ${stock} unit
<b>DESKRIPSI:</b> ${description}
<b>KODE PRODUK:</b> <code>${productCode}</code>
<b>TANGGAL:</b> ${dateStr}

<b>🎯 CARA MEMBELI:</b>
1. Klik tombol dibawah
2. Pilih metode pembayaran`;

        const keyboard = {
            inline_keyboard: [
                [{ 
                    text: "🛒 Beli Sekarang", 
                    url: `https://t.me/${(await bot.getMe()).username}?start=product_${productCode}`
                }]
            ]
        };
        
        await bot.sendMessage(channel, channelMessage, {
            parse_mode: 'HTML',
            disable_web_page_preview: true,
            reply_markup: keyboard
        });
        
    } catch (error) {
        console.error('Gagal kirim notif produk baru ke channel:', error);
    }
}

async function notifyChannelProductSuccess(userId, product, orderId, productPrice) {
    try {
        const user = await bot.getChat(userId).catch(() => ({ 
            id: userId, 
            first_name: 'User' 
        }));
        
        const dateStr = new Date().toLocaleString('id-ID', { 
            day: 'numeric', 
            month: 'short', 
            year: 'numeric', 
            hour: '2-digit', 
            minute: '2-digit' 
        });
        
        const channelMessage = `<b>🛍️ ORDER PRODUK BERHASIL</b>

User: ${user.first_name || 'User'}
Produk: ${product.name}
Harga: ${formatCurrency(productPrice)}
Kode: <code>${product.buyCode}</code>
Order ID: <code>#${orderId}</code>
Tanggal: ${dateStr}

<b>📦 KATEGORI</b>
${product.desc || 'Produk Digital'}

<b>🎉 STATUS</b>
✅ Transaksi sukses - File dikirim otomatis`;
        
        try {
            await bot.sendMessage(channel, channelMessage, {
                parse_mode: 'HTML',
                disable_web_page_preview: true
            });
        } catch (error) {
            console.error('Gagal kirim notif produk ke channel:', error);
        }
        
    } catch (error) {
        console.error('Error di notifyChannelProductSuccess:', error);
    }
}

async function notifyOrderSuccess(user, orderData, price, hasOTP = false) {
    try {
        const orderId = orderData.order_id || orderData.id;
        const userId = user.id || user.userId;
        const firstName = user.first_name || user.firstName || 'User';
        const username = user.username ? `@${user.username}` : 'Tidak ada username';
        const phoneNumber = orderData.phone_number || orderData.phoneNumber || orderData.number || '-';
        const maskedPhone = maskPhoneNumber(phoneNumber);     
        const formattedPrice = formatCurrency(price);
        const serviceName = orderData.service || orderData.service_name || 'Layanan';

        if (!hasOTP) {
            const ownerMessage = `<b>📱 ORDER BARU - MENUNGGU OTP</b>
━━━━━━━━━━━━━━━━━━━

<b>👤 USER INFORMATION</b>
• Nama: ${firstName}
• User ID: <code>${userId}</code>
• Username: ${username}

<b>📋 ORDER DETAILS</b>
• ID Order: <code>#${orderId}</code>
• Nomor: ${maskedPhone}
• Layanan: ${serviceName}
• Harga: ${formattedPrice}
• Status: ⏳ Menunggu OTP

<b>🕐 TIME INFORMATION</b>
• ${new Date().toLocaleString('id-ID')}

<b>🔗 QUICK ACTION</b>
<a href="tg://user?id=${userId}">💬 Chat dengan user</a>`;
            
            for (const adminId of owner_ids) {
                try {
                    await bot.sendMessage(adminId, ownerMessage, {
                        parse_mode: 'HTML',
                        disable_web_page_preview: true
                    });
                } catch (error) {
                }
            }
            return;
        } 
        else {
            const otpCode = orderData.otp_code || '-';
            const maskedOTP = otpCode !== '-' ? '***' : '-';
            const now = new Date();
            const nowJakarta = new Date(now.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
            const dateStr = nowJakarta.toLocaleDateString('en-US', { 
                day: 'numeric', 
                month: 'short', 
                year: 'numeric' 
            });
            const timeStr = nowJakarta.toLocaleTimeString('id-ID');
            
            const channelMessage = `
<b>✅ OTP BERHASIL DITERIMA</b>
━━━━━━━━━━━━━━━━━━━

<b>📋 ORDER INFORMATION</b>
• ID Order: <code>#${orderId}</code>
• Nama User: ${firstName}
• Nomor Telepon: ${maskedPhone}
• Kode OTP: <code>${maskedOTP}</code>
• Nominal: ${formattedPrice}
• Tanggal: ${dateStr}
• Waktu: ${timeStr}

<b>📱 SERVICE INFORMATION</b>
• Layanan: ${serviceName}
• Status: ✅ OTP Telah Diterima
• Catatan: Kode OTP aman dan sudah terverifikasi

━━━━━━━━━━━━━━━━━━━`;
            
            try {
                await bot.sendMessage(channel, channelMessage, {
                    parse_mode: 'HTML',
                    disable_web_page_preview: true
                });
            } catch (error) {
            }
        }
    } catch (error) {
    }
}

async function notifyDepositSuccess(userId, amount, depositId, newBalance, paymentMethod) {
    try {
        const user = await bot.getChat(userId).catch(() => ({ 
            id: userId, 
            first_name: 'User' 
        }));
        
        const pointsData = royaltySystem.getUserPoints(userId);
        const now = new Date();
        const nowJakarta = new Date(now.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
        const dateStr = nowJakarta.toLocaleDateString('en-US', { 
            day: 'numeric', 
            month: 'short', 
            year: 'numeric' 
        });
        const timeStr = nowJakarta.toLocaleTimeString('id-ID');
        
        const botInfo = await bot.getMe();
        const botUsername = botInfo.username;
        
        const channelMessage = `
<b>💰 DEPOSIT BERHASIL</b>
━━━━━━━━━━━━━━━━━━━

<b>📋 TRANSACTION DETAILS</b>
• ID Deposit: #${depositId}
• Nama User: ${user.first_name || 'User'}
• Jumlah Deposit: ${formatCurrency(amount)}
• Metode Pembayaran: QRIS
• Points Earned: +${pointsData.points}
• Tanggal: ${dateStr}
• Waktu: ${timeStr}

<b>📊 USER STATISTICS</b>
• User ID: <code>${userId}</code>
• Saldo Total: ${formatCurrency(newBalance)}
• Status: ✅ Transaksi Sukses
• Sistem: Auto Processing

<b>🎯 ROYALTY SYSTEM</b>
• Total Points: ${pointsData.points}
• Deposit Count: ${pointsData.depositCount || 0}x
• Reward Status: Active

━━━━━━━━━━━━━━━━━━━`;
        
        const keyboard = {
            inline_keyboard: [
                [
                    { 
                        text: '🛒 Order Sekarang', 
                        url: `https://t.me/${botUsername}?start=order`
                    }
                ],
                [
                    { 
                        text: '📢 Join Channel', 
                        url: `https://t.me/${channel.replace('@','')}`
                    },
                    { 
                        text: '💬 Support', 
                        url: `https://t.me/${usernamelu.replace('@','')}`
                    }
                ]
            ]
        };
        
        try {
            await bot.sendMessage(channel, channelMessage, {
                parse_mode: 'HTML',
                disable_web_page_preview: true,
                reply_markup: keyboard
            });
        } catch (error) {
            for (const ownerId of owner_ids) {
                try {
                    await bot.sendMessage(ownerId,
`<b>❌ GAGAL KIRIM KE CHANNEL</b>
━━━━━━━━━━━━━━━━━━━

<b>⚠️ ERROR DETAILS</b>
• Deposit ID: #${depositId}
• User: ${user.first_name || 'User'}
• Metode: QRIS
• Jumlah: ${formatCurrency(amount)}
• Error: ${error.message}

<b>📋 MANUAL ACTION</b>
Silakan cek channel dan bot permissions.`,
                        { parse_mode: 'HTML' }
                    );
                } catch {}
            }
        }
        
    } catch (error) {
    }
}

async function notifyOwnerDepositCreated(depositData, userId, requestAmount, feeFromGateway, totalToPay, userGetSaldo, paymentMethod) {
    try {
        const user = await bot.getChat(userId).catch(() => ({ 
            id: userId, 
            first_name: 'User' 
        }));
        
        const now = new Date();
        const nowJakarta = new Date(now.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
        const dateStr = nowJakarta.toLocaleDateString('id-ID', { 
            day: 'numeric', 
            month: 'short', 
            year: 'numeric' 
        });
        const timeStr = nowJakarta.toLocaleTimeString('id-ID', { 
            hour: '2-digit', 
            minute: '2-digit' 
        });
        
        const depositId = depositData.id || depositData.no_inv || depositData.deposit_id; 
        const message = `<b>⏳ DEPOSIT MENUNGGU PEMBAYARAN</b>

<b>👤 USER INFORMATION</b>
• Nama: ${user.first_name || 'User'}
• Username: ${user.username ? '@' + user.username : '-'}
• User ID: <code>${user.id}</code>

<b>💰 TRANSACTION DETAILS</b>
• ID Deposit: <code>#${depositId}</code>
• Metode: ${paymentMethod.toUpperCase()}
• Jumlah Request: ${formatCurrency(requestAmount)}
• Biaya Gateway: ${formatCurrency(feeFromGateway)}
• Total Bayar: ${formatCurrency(totalToPay)}
• Saldo Masuk: ${formatCurrency(userGetSaldo)}

<b>📊 STATUS</b>
• Status: ⏳ Menunggu Pembayaran
• Batas Waktu: 20 menit
• Tanggal: ${dateStr}
• Waktu: ${timeStr}`;

        for (const ownerId of owner_ids) {
            try {
                await bot.sendMessage(ownerId, message, { 
                    parse_mode: 'HTML',
                    disable_web_page_preview: true 
                });
            } catch (error) {
            }
        }
    } catch (error) {
    }
}

async function notifyNewUser(user, initialBalance, chatId) {
    try {
        const userId = user.id;
        const firstName = user.first_name || 'User';
        const username = user.username ? `@${user.username}` : 'No Username';
        const userLink = `tg://user?id=${userId}`;
        
        const now = new Date();
        const nowJakarta = new Date(now.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
        
        const welcomeMessage = `
<b>🎉 USER BARU BERGABUNG!</b>
━━━━━━━━━━━━━━━━━━━

<b>👤 USER PROFILE</b>
• Nama: ${firstName}
• User ID: <code>${userId}</code>
• Username: ${username}
• Saldo Awal: ${formatCurrency(initialBalance)}

<b>📊 JOIN INFORMATION</b>
• Tanggal: ${nowJakarta.toLocaleDateString('id-ID')}
• Waktu: ${nowJakarta.toLocaleTimeString('id-ID')}
• Status: ✅ Terverifikasi
• Bot Access: Active

<b>🔗 QUICK ACTIONS</b>
• <a href="${userLink}">💬 Chat dengan User</a>
• <a href="tg://resolve?domain=${usernamelu.replace('@','')}">👑 Hubungi Owner</a>

━━━━━━━━━━━━━━━━━━━
<i>Total User: ${loadData().users?.length || 0} • © ${new Date().getFullYear()} ${config.bot_name || 'SKYZBOT'}</i>`;
        
        for (const ownerId of owner_ids) {
            try {
                await bot.sendMessage(ownerId, welcomeMessage, {
                    parse_mode: 'HTML',
                    disable_web_page_preview: true
                });
            } catch (error) {
            }
        }
        
    } catch (error) {
    }
}

async function addBalanceAdmin(chatId, adminId, commandText) {
    const parts = commandText.split(' ');
    if (parts.length < 3) {
        await bot.sendMessage(chatId,
`<b>❌ FORMAT SALAH</b>

Format: /addsaldo [user_id] [jumlah]
Contoh: /addsaldo 123456789 20000`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }

    const targetUserId = parts[1];
    const amount = parseInt(parts[2]);
    const userIdValidation = validateUserId(targetUserId);
    if (!userIdValidation.valid) {
        await bot.sendMessage(chatId,
`<b>❌ USER ID TIDAK VALID</b>

Error: ${userIdValidation.error}`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }

    const amountValidation = validateAmount(amount);
    if (!amountValidation.valid || amountValidation.amount < 1000) {
        await bot.sendMessage(chatId,
`<b>❌ JUMLAH TIDAK VALID</b>

Error: ${amountValidation.error || 'Minimal Rp 1.000'}`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }

    const numAmount = amountValidation.amount;

    if (numAmount > 5000000) {
        await bot.sendMessage(chatId,
`<b>❌ JUMLAH TERLALU BESAR</b>

Maksimal: Rp 5.000.000
Anda: ${formatCurrency(numAmount)}`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }

    const data = loadData();
    if (!data.users) data.users = [];
    
    const userExists = data.users.some(id => id === targetUserId);
    if (!userExists) {
        data.users.push(targetUserId);
        saveData(data);
    }
    
    balanceCache.delete(targetUserId);
    
    const oldBalance = getUserBalance(targetUserId);
    const success = addUserBalance(targetUserId, numAmount);
    const newBalance = getUserBalance(targetUserId);

    if (!success) {
        await bot.sendMessage(chatId,
`<b>❌ GAGAL MENAMBAH SALDO</b>

Terjadi kesalahan sistem`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
        return;
    }

    await bot.sendMessage(chatId,
`<b>✅ SALDO BERHASIL DITAMBAHKAN</b>

User ID: ${targetUserId}
Jumlah: ${formatCurrency(numAmount)}
Saldo Lama: ${formatCurrency(oldBalance)}
Saldo Baru: ${formatCurrency(newBalance)}
Admin: ${adminId}`,
        { 
            parse_mode: 'HTML',
            disable_web_page_preview: true 
        }
    );

    try {
        const user = await bot.getChat(targetUserId);
        await bot.sendMessage(targetUserId,
`<b>💰 SALDO ANDA DITAMBAHKAN</b>

Jumlah: ${formatCurrency(numAmount)}
Saldo Lama: ${formatCurrency(oldBalance)}
Saldo Baru: ${formatCurrency(newBalance)}
Oleh: Admin Sistem`,
            { 
                parse_mode: 'HTML',
                disable_web_page_preview: true 
            }
        );
    } catch {}
}

const lastNotificationTime = new Map();
let isCheckingPrices = false;
let isCheckingStock = false;

setInterval(monitorSpecificPrices, 15 * 60 * 1000); 
setInterval(monitorStockLevels, 30 * 60 * 1000);
scheduleDailySummary();

async function monitorSpecificPrices() {
  try {
    if (isCheckingPrices) return;
    isCheckingPrices = true;
    
    const servicesData = await getServicesCached();
    
    if (!servicesData || !servicesData.success) {
      isCheckingPrices = false;
      return;
    }

    const services = servicesData.data;
    const targetServices = [];
    
    for (const service of services) {
      const serviceName = service.service_name.toLowerCase();
      
      if (serviceName.includes('whatsapp') || serviceName.includes('telegram')) {
        targetServices.push(service);
      }
      
      if (targetServices.length >= 2) break;
    }
    
    for (const service of targetServices) {
      await checkServiceIndonesia(service);
      await new Promise(resolve => setTimeout(resolve, 5000));
    }
    
    isCheckingPrices = false;
  } catch (error) {
    isCheckingPrices = false;
  }
}

async function checkServiceIndonesia(service) {
  try {
    const countriesData = await api.getCountries(service.service_code);
    
    if (!countriesData || !countriesData.success) {
      return;
    }

    const countries = countriesData.data || [];
    
    for (const country of countries) {
      const countryName = country.name.toLowerCase();
      
      if (!countryName.includes('indonesia') && !countryName.includes('indo')) {
        continue;
      }
      
      if (!country.pricelist || country.pricelist.length === 0) {
        continue;
      }

      const cacheKey = `${service.service_code}_${country.number_id}`;
      const currentPrices = country.pricelist.map(server => ({
        provider_id: server.provider_id,
        price: server.price,
        rate: server.rate,
        stock: server.stock
      }));

      const previousPrices = priceCache.get(cacheKey);
      
      if (previousPrices) {
        const changes = detectPriceChanges(previousPrices, currentPrices, service, country);
        if (changes.length > 0) {
          await notifyPriceChanges(changes, service, country);
        }
      }
      
      priceCache.set(cacheKey, currentPrices);
    }
    
  } catch (error) {}
}

function detectPriceChanges(oldPrices, newPrices, service, country) {
  const changes = [];
  const notificationKey = `${service.service_code}_${country.number_id}`;
  const lastNotified = lastNotificationTime.get(notificationKey) || 0;
  const now = Date.now();
  
  if (now - lastNotified < 60 * 60 * 1000) {
    return changes;
  }

  for (let i = 0; i < Math.min(oldPrices.length, newPrices.length); i++) {
    const oldPrice = oldPrices[i];
    const newPrice = newPrices[i];
    
    if (oldPrice && newPrice && oldPrice.price !== newPrice.price) {
      const changeAmount = Math.abs(newPrice.price - oldPrice.price);
      const minChange = 500;
      
      if (changeAmount >= minChange) {
        const changePercent = ((newPrice.price - oldPrice.price) / oldPrice.price * 100).toFixed(1);
        
        changes.push({
          service: service.service_name,
          country: country.name,
          server: i + 1,
          oldPrice: oldPrice.price,
          newPrice: newPrice.price,
          change: parseInt(newPrice.price) - parseInt(oldPrice.price),
          changePercent: changePercent,
          rate: newPrice.rate,
          stock: newPrice.stock
        });
      }
    }
  }
  
  if (changes.length > 0) {
    lastNotificationTime.set(notificationKey, now);
  }
  
  return changes;
}

async function notifyPriceChanges(changes, service, country) {
  try {
    if (changes.length === 0) return;
    
    const priceDownChanges = changes.filter(c => c.change < 0);
    const priceUpChanges = changes.filter(c => c.change > 0);
    
    if (priceDownChanges.length === 0 && priceUpChanges.length === 0) return;
    
    const botInfo = await bot.getMe();
    const botUsername = botInfo.username;
    
    let message = `<b>📈 UPDATE HARGA LAYANAN</b>\n\n`;
    
    if (priceDownChanges.length > 0) {
      message += `<b>🟢 HARGA TURUN!</b>\n`;
      priceDownChanges.forEach(change => {
        const discount = Math.abs(change.change);
        message += `\n<b>${change.service} - ${change.country}</b>\n`;
        message += `• Server ${change.server}\n`;
        message += `💰 Rp${change.oldPrice.toLocaleString('id-ID')} → <b>Rp${change.newPrice.toLocaleString('id-ID')}</b>\n`;
        message += `📉 Turun Rp${discount.toLocaleString('id-ID')} (${Math.abs(change.changePercent)}%)\n`;
        message += `📊 Rate: ${change.rate}% | 📦 Stok: ${change.stock}\n`;
      });
    }
    
    if (priceUpChanges.length > 0) {
      if (priceDownChanges.length > 0) message += `\n`;
      message += `<b>🔴 HARGA NAIK!</b>\n`;
      priceUpChanges.forEach(change => {
        const increase = Math.abs(change.change);
        message += `\n<b>${change.service} - ${change.country}</b>\n`;
        message += `• Server ${change.server}\n`;
        message += `💰 Rp${change.oldPrice.toLocaleString('id-ID')} → <b>Rp${change.newPrice.toLocaleString('id-ID')}</b>\n`;
        message += `📈 Naik Rp${increase.toLocaleString('id-ID')} (${Math.abs(change.changePercent)}%)\n`;
        message += `📊 Rate: ${change.rate}% | 📦 Stok: ${change.stock}\n`;
      });
    }
    
    message += `\n<b>⏰ UPDATE</b>\n`;
    message += `${new Date().toLocaleString('id-ID')}\n\n`;
    
    const keyboard = {
      inline_keyboard: [
        [
          { 
            text: "🛒 Orders", 
            url: `https://t.me/${botUsername}?start=order`
          },
          { 
            text: "💬 Support", 
            url: `https://t.me/${usernamelu.replace('@', '')}`
          }
        ]
      ]
    };
    
    await bot.sendMessage(channel, message, {
      parse_mode: 'HTML',
      disable_web_page_preview: true,
      reply_markup: keyboard
    });
    
    savePriceChangeHistory({
      service: service.service_name,
      country: country.name,
      changes: changes,
      timestamp: new Date().toISOString()
    });
    
  } catch (error) {}
}

function savePriceChangeHistory(data) {
  try {
    const historyFile = path.join(dataDir, 'price_history.json');
    let history = [];
    
    if (fs.existsSync(historyFile)) {
      history = JSON.parse(fs.readFileSync(historyFile, 'utf8'));
    }
    
    history.unshift(data);
    
    if (history.length > 50) {
      history = history.slice(0, 50);
    }
    
    fs.writeFileSync(historyFile, JSON.stringify(history, null, 2));
  } catch (error) {}
}

async function monitorStockLevels() {
  try {
    const servicesData = await getServicesCached();
    
    if (!servicesData || !servicesData.success) {
      return;
    }

    const services = servicesData.data;
    
    for (const service of services) {
      const serviceName = service.service_name.toLowerCase();
      
      if (!serviceName.includes('whatsapp') && !serviceName.includes('telegram')) {
        continue;
      }
      
      const countriesData = await api.getCountries(service.service_code);
      
      if (!countriesData || !countriesData.success) {
        continue;
      }

      const countries = countriesData.data || [];
      
      for (const country of countries) {
        const countryName = country.name.toLowerCase();
        
        if (!countryName.includes('indonesia') && !countryName.includes('indo')) {
          continue;
        }
        
        if (!country.pricelist) continue;
        
        if (country.stock_total < 5) {
          await notifyLowStock(service, country);
        }
      }
    }
    
  } catch (error) {}
}

async function notifyLowStock(service, country) {
  try {
    const cacheKey = `lowstock_${service.service_code}_${country.number_id}`;
    const lastNotified = lastNotificationTime.get(cacheKey) || 0;
    const now = Date.now();
    
    if (now - lastNotified < 4 * 60 * 60 * 1000) {
      return;
    }
    
    const botInfo = await bot.getMe();
    const botUsername = botInfo.username;
    
    const message = `<b>⚠️ STOK MENIPIS!</b>\n\n` +
                   `<b>Layanan:</b> ${service.service_name}\n` +
                   `<b>Negara:</b> ${country.name}\n` +
                   `<b>Stok Tersisa:</b> ${country.stock_total}\n\n` +
                   `<i>Segera tambah stok!</i>`;
    
    const keyboard = {
      inline_keyboard: [
        [
          { 
            text: "📢 Admin", 
            url: `https://t.me/${usernamelu.replace('@', '')}`
          },
          { 
            text: "🛒 Bot", 
            url: `https://t.me/${botUsername}`
          }
        ]
      ]
    };
    
    await bot.sendMessage(channel, message, {
      parse_mode: 'HTML',
      disable_web_page_preview: true,
      reply_markup: keyboard
    });
    
    lastNotificationTime.set(cacheKey, now);
    
  } catch (error) {}
}

async function sendDailyPriceSummary() {
  try {
    const servicesData = await getServicesCached();
    
    if (!servicesData || !servicesData.success) {
      return;
    }

    const services = servicesData.data;
    const targetServices = [];
    
    for (const service of services) {
      const serviceName = service.service_name.toLowerCase();
      
      if (serviceName.includes('whatsapp') || serviceName.includes('telegram')) {
        targetServices.push(service);
      }
      
      if (targetServices.length >= 2) break;
    }
    
    if (targetServices.length === 0) return;
    
    const botInfo = await bot.getMe();
    const botUsername = botInfo.username;
    
    let message = `<b>📊 REKAP HARGA HARIAN</b>\n\n`;
    message += `${new Date().toLocaleDateString('id-ID', { 
      weekday: 'long', 
      year: 'numeric', 
      month: 'long', 
      day: 'numeric' 
    })}\n\n`;
    
    for (const service of targetServices) {
      const countriesData = await api.getCountries(service.service_code);
      
      if (!countriesData || !countriesData.success || !countriesData.data.length) {
        continue;
      }
      
      const indonesiaCountry = countriesData.data.find(c => 
        c.name.toLowerCase().includes('indonesia') || c.name.toLowerCase().includes('indo')
      );
      
      if (!indonesiaCountry || !indonesiaCountry.pricelist || !indonesiaCountry.pricelist.length) continue;
      
      const server = indonesiaCountry.pricelist[0];
      const minPrice = Math.min(...indonesiaCountry.pricelist.map(p => p.price));
      const maxPrice = Math.max(...indonesiaCountry.pricelist.map(p => p.price));
      
      message += `<b>${service.service_name} - Indonesia</b>\n`;
      message += `💰 Harga: Rp${minPrice.toLocaleString('id-ID')} - Rp${maxPrice.toLocaleString('id-ID')}\n`;
      message += `📊 Rate: ${server.rate}%\n`;
      message += `📦 Stok Total: ${indonesiaCountry.stock_total}\n`;
      message += `📡 Server: ${indonesiaCountry.pricelist.length}\n\n`;
    }
    
    message += `<i>Update otomatis setiap hari jam 09.00 WIB</i>`;
    
    const keyboard = {
      inline_keyboard: [
        [
          { 
            text: "🛒 Order Sekarang", 
            url: `https://t.me/${botUsername}`
          }
        ],
        [
          { 
            text: "📢 Channel Info", 
            url: `https://t.me/${channel.replace('@', '')}`
          },
          { 
            text: "💬 Support", 
            url: `https://t.me/${usernamelu.replace('@', '')}`
          }
        ]
      ]
    };
    
    await bot.sendMessage(channel, message, {
      parse_mode: 'HTML',
      disable_web_page_preview: true,
      reply_markup: keyboard
    });
    
  } catch (error) {}
}

function scheduleDailySummary() {
  const now = new Date();
  const target = new Date();
  target.setHours(9, 0, 0, 0);
  
  if (now > target) {
    target.setDate(target.getDate() + 1);
  }
  
  const timeUntilTarget = target.getTime() - now.getTime();
  
  setTimeout(() => {
    sendDailyPriceSummary();
    setInterval(sendDailyPriceSummary, 24 * 60 * 60 * 1000);
  }, timeUntilTarget);
}

setInterval(monitorSpecificPrices, 15 * 60 * 1000); 
setInterval(monitorStockLevels, 30 * 60 * 1000);
scheduleDailySummary();

setTimeout(() => {
  monitorSpecificPrices();
  monitorStockLevels();
}, 60 * 1000);

async function scheduledAutoBackup() {
    try {
        const now = new Date();
        const nowJakarta = new Date(now.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
        
        const dateStr = nowJakarta.toISOString().split('T')[0];
        const timeStr = nowJakarta.getHours().toString().padStart(2, '0') + '-' + 
                       nowJakarta.getMinutes().toString().padStart(2, '0') + '-' +
                       nowJakarta.getSeconds().toString().padStart(2, '0');
        
        const backupFileName = `auto_backup_${dateStr}_${timeStr}.zip`;
        
        const archive = archiver('zip', { zlib: { level: 9 } });
        const chunks = [];
        
        archive.on('data', (chunk) => chunks.push(chunk));
        
        const backupFiles = [
            { 
                name: 'database/balances.json', 
                path: balanceFile 
            },
            { 
                name: 'database/users.json', 
                path: datafile 
            },
            { 
                name: 'database/transactions.json', 
                path: transactionsFile 
            },
            { 
                name: 'database/settings.json', 
                path: settingsFile 
            },
            { 
                name: 'database/dataproduct.json', 
                path: dataProduct  
            }
        ];
        
        let fileCount = 0;
        let successCount = 0;
        
        for (const file of backupFiles) {
            fileCount++;
            try {
                if (fs.existsSync(file.path)) {
                    const fileBuffer = fs.readFileSync(file.path);
                    archive.append(fileBuffer, { name: file.name });
                    successCount++;
                }
            } catch (fileError) {}
        }
        
        await new Promise((resolve, reject) => {
            archive.on('end', resolve);
            archive.on('error', reject);
            archive.finalize();
        });
        
        const zipBuffer = Buffer.concat(chunks);
        const fileSizeKB = (zipBuffer.length / 1024).toFixed(2);
        
        for (const ownerId of config.owner_ids) {
            try {
                await bot.sendDocument(ownerId, zipBuffer, {
                    caption: `✅ AUTO BACKUP TERJADWAL (2 JAM)
📁 ${backupFileName}
📊 ${successCount}/${fileCount} file
💾 ${fileSizeKB} KB
🕐 ${nowJakarta.toLocaleString('id-ID')}
📍 Waktu: WIB (Indonesia)
📅 Auto backup setiap 2 jam`,
                    parse_mode: 'HTML',
                    filename: backupFileName
                });
            } catch (error) {}
        }
        
    } catch (error) {}
}

async function transactionAutoBackup() {
    try {
        const now = new Date();
        const nowJakarta = new Date(now.toLocaleString("en-US", { timeZone: "Asia/Jakarta" }));
        
        const dateStr = nowJakarta.toISOString().split('T')[0];
        const timeStr = nowJakarta.getHours().toString().padStart(2, '0') + '-' + 
                       nowJakarta.getMinutes().toString().padStart(2, '0') + '-' +
                       nowJakarta.getSeconds().toString().padStart(2, '0');
        
        const backupFileName = `tx_backup_${dateStr}_${timeStr}.zip`;
        
        const archive = archiver('zip', { zlib: { level: 9 } });
        const chunks = [];
        
        archive.on('data', (chunk) => chunks.push(chunk));
        
        const backupFiles = [
            { 
                name: 'database/balances.json', 
                path: balanceFile 
            },
            { 
                name: 'database/transactions.json', 
                path: transactionsFile 
            },
            { 
                name: 'database/users.json', 
                path: datafile 
            }
        ];
        
        let successCount = 0;
        let fileCount = 0;
        
        for (const file of backupFiles) {
            fileCount++;
            try {
                if (fs.existsSync(file.path)) {
                    const fileBuffer = fs.readFileSync(file.path);
                    archive.append(fileBuffer, { name: file.name });
                    successCount++;
                }
            } catch (fileError) {}
        }
        
        await new Promise((resolve, reject) => {
            archive.on('end', resolve);
            archive.on('error', reject);
            archive.finalize();
        });
        
        const zipBuffer = Buffer.concat(chunks);
        const fileSizeKB = (zipBuffer.length / 1024).toFixed(2);
        
        for (const ownerId of config.owner_ids) {
            try {
                await bot.sendDocument(ownerId, zipBuffer, {
                    caption: `💰 BACKUP SETELAH TRANSAKSI
📁 ${backupFileName}
📊 ${successCount}/${fileCount} file
💾 ${fileSizeKB} KB
🕐 ${nowJakarta.toLocaleString('id-ID')}
📍 Waktu: WIB (Indonesia)
📌 Trigger: Deposit/Order Nokos`,
                    parse_mode: 'HTML',
                    filename: backupFileName
                });
            } catch (error) {}
        }
        
    } catch (error) {}
}

console.log(
  chalk.hex("#FF4500").bold(`
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
${chalk.hex("#FFD700").bold("BOT SUCCESSFULLY STARTED")}
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
${chalk.hex("#00FF00").bold("DEVELOPER")}
• @KyzzXyz

${chalk.hex("#00FFFF").bold("CREATED")}
• 2025 - 2026

${chalk.hex("#FF69B4").bold("SUPPORT TEAM")}
• Tepz - Partner
• Khafa - Friends  
• Joo - Partner
• Fahz - Partner
• Xin - Partner
• All Buyers
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
`)
);