/* 

=========================================================================

  #- SKYZBOT 
   Telegram: https://t.me/SpeedyCode_Robot
   
  Suport By:
  - Skyzbot Development Team
  - Khafa My Friends 
  - Kalz My Partner 
  - MalzXyz My Friends 
  - Felix My Partner 
  - Tepz My Partner
  - Fahz My Partner 
  - Jooo My Partner 
  - All Buyers
  
  ⚠️ HAK CIPTA DILINDUNGI:
  Script ini dijual resmi oleh SKYZBOT.
  Dilarang keras membagikan secara gratis.
  © 2024 - 2026 SKYZBOTZ. All Rights Reserved.

=========================================================================

*/



const fs = require('fs');
const path = require('path');

class RoyaltySystem {
    constructor() {
        this.dataDir = path.join(__dirname, '../database');
        this.pointsFile = path.join(this.dataDir, 'points.json');
        this.ensureDataDir();
        this.loadData();
        
        this.POINTS_PER_DEPOSIT = 1;
        this.MIN_REDEEM_POINTS = 5; 
        this.REDEEM_VALUE = 8000;  
        this.POINTS_PER_RUPIAH = this.REDEEM_VALUE / this.MIN_REDEEM_POINTS; 
    }

    ensureDataDir() {
        if (!fs.existsSync(this.dataDir)) {
            fs.mkdirSync(this.dataDir, { recursive: true });
        }
    }

    loadData() {
        try {
            if (!fs.existsSync(this.pointsFile)) {
                this.data = {
                    users: {},  
                    history: [],
                    settings: {
                        pointsPerDeposit: this.POINTS_PER_DEPOSIT,
                        minRedeemPoints: this.MIN_REDEEM_POINTS,
                        redeemValue: this.REDEEM_VALUE
                    }
                };
                this.saveData();
                return;
            }
            this.data = JSON.parse(fs.readFileSync(this.pointsFile, 'utf8'));
        } catch (e) {
            this.data = {
                users: {},
                history: [],
                settings: {
                    pointsPerDeposit: this.POINTS_PER_DEPOSIT,
                    minRedeemPoints: this.MIN_REDEEM_POINTS,
                    redeemValue: this.REDEEM_VALUE
                }
            };
        }
    }

    saveData() {
        try {
            fs.writeFileSync(this.pointsFile, JSON.stringify(this.data, null, 2));
            return true;
        } catch (error) {
            console.error('Error saving points data:', error);
            return false;
        }
    }

    addPointsFromDeposit(userId, depositAmount) {
        const userIdStr = String(userId);
        
        if (!this.data.users[userIdStr]) {
            this.data.users[userIdStr] = {
                points: 0,
                totalEarned: 0,
                totalRedeemed: 0,
                depositCount: 0
            };
        }

        const pointsEarned = this.POINTS_PER_DEPOSIT;
        
        this.data.users[userIdStr].points += pointsEarned;
        this.data.users[userIdStr].totalEarned += pointsEarned;
        this.data.users[userIdStr].depositCount = (this.data.users[userIdStr].depositCount || 0) + 1;
        this.data.history.push({
            userId: userIdStr,
            type: 'earn',
            points: pointsEarned,
            source: 'deposit',
            depositAmount: depositAmount,
            timestamp: new Date().toISOString()
        });

        this.saveData();

        return {
            success: true,
            pointsEarned: pointsEarned,
            totalPoints: this.data.users[userIdStr].points,
            message: `🎉 Anda mendapatkan ${pointsEarned} point dari deposit!`
        };
    }

    addPoints(userId, points, reason = 'admin') {
        const userIdStr = String(userId);
        const pointsNum = parseInt(points);

        if (isNaN(pointsNum) || pointsNum <= 0) {
            return { success: false, error: 'Jumlah points tidak valid' };
        }

        if (!this.data.users[userIdStr]) {
            this.data.users[userIdStr] = {
                points: 0,
                totalEarned: 0,
                totalRedeemed: 0,
                depositCount: 0
            };
        }

        this.data.users[userIdStr].points += pointsNum;
        this.data.users[userIdStr].totalEarned += pointsNum;
        this.data.history.push({
            userId: userIdStr,
            type: 'earn',
            points: pointsNum,
            source: reason,
            timestamp: new Date().toISOString()
        });

        this.saveData();

        return {
            success: true,
            pointsAdded: pointsNum,
            totalPoints: this.data.users[userIdStr].points,
            message: `✅ Berhasil menambahkan ${pointsNum} points`
        };
    }

    redeemPoints(userId) {
        const userIdStr = String(userId);
        
        if (!this.data.users[userIdStr]) {
            return { success: false, error: 'User tidak ditemukan' };
        }

        const userPoints = this.data.users[userIdStr].points;

        if (userPoints < this.MIN_REDEEM_POINTS) {
            return { 
                success: false, 
                error: `Minimal penukaran ${this.MIN_REDEEM_POINTS} points. Anda memiliki ${userPoints} points` 
            };
        }

        const redeemableMultiples = Math.floor(userPoints / this.MIN_REDEEM_POINTS);
        const pointsToRedeem = redeemableMultiples * this.MIN_REDEEM_POINTS;
        const cashValue = redeemableMultiples * this.REDEEM_VALUE;
        this.data.users[userIdStr].points -= pointsToRedeem;
        this.data.users[userIdStr].totalRedeemed += pointsToRedeem;

        this.data.history.push({
            userId: userIdStr,
            type: 'redeem',
            points: pointsToRedeem,
            cashValue: cashValue,
            timestamp: new Date().toISOString()
        });

        this.saveData();

        return {
            success: true,
            pointsRedeemed: pointsToRedeem,
            cashValue: cashValue,
            remainingPoints: this.data.users[userIdStr].points,
            message: `✅ Berhasil menukar ${pointsToRedeem} points menjadi Rp ${cashValue.toLocaleString('id-ID')}`
        };
    }

    getUserPoints(userId) {
    const userIdStr = String(userId);
    
    if (!this.data.users[userIdStr]) {
        return {
            points: 0,
            totalEarned: 0,
            totalRedeemed: 0,
            depositCount: 0,
            redeemableCash: 0,
            neededPoints: this.MIN_REDEEM_POINTS,
            redeemValue: this.REDEEM_VALUE 
        };
    }

    const userData = this.data.users[userIdStr];
    const redeemableMultiples = Math.floor(userData.points / this.MIN_REDEEM_POINTS);
    const redeemableCash = redeemableMultiples * this.REDEEM_VALUE;

    return {
        points: userData.points,
        totalEarned: userData.totalEarned,
        totalRedeemed: userData.totalRedeemed,
        depositCount: userData.depositCount || 0,
        redeemableCash: redeemableCash,
        neededPoints: this.MIN_REDEEM_POINTS,
        redeemValue: this.REDEEM_VALUE
    };
}
    
    getPointsLeaderboard(limit = 10) {
        const usersArray = Object.entries(this.data.users)
            .map(([userId, data]) => ({
                userId,
                points: data.points,
                totalEarned: data.totalEarned,
                depositCount: data.depositCount || 0
            }))
            .sort((a, b) => b.points - a.points)
            .slice(0, limit);

        return usersArray;
    }

    getUserHistory(userId, limit = 10) {
        const userIdStr = String(userId);
        const userHistory = this.data.history
            .filter(record => record.userId === userIdStr)
            .sort((a, b) => new Date(b.timestamp) - new Date(a.timestamp))
            .slice(0, limit);

        return userHistory;
    }

    getAllData() {
        return this.data;
    }

    resetAllData() {
        this.data = {
            users: {},
            history: [],
            settings: {
                pointsPerDeposit: this.POINTS_PER_DEPOSIT,
                minRedeemPoints: this.MIN_REDEEM_POINTS,
                redeemValue: this.REDEEM_VALUE
            }
        };
        this.saveData();
        return { success: true };
    }
    
    updateSettings(newSettings) {
        if (newSettings.pointsPerDeposit) {
            this.data.settings.pointsPerDeposit = parseInt(newSettings.pointsPerDeposit);
            this.POINTS_PER_DEPOSIT = this.data.settings.pointsPerDeposit;
        }
        
        if (newSettings.minRedeemPoints) {
            this.data.settings.minRedeemPoints = parseInt(newSettings.minRedeemPoints);
            this.MIN_REDEEM_POINTS = this.data.settings.minRedeemPoints;
        }
        
        if (newSettings.redeemValue) {
            this.data.settings.redeemValue = parseInt(newSettings.redeemValue);
            this.REDEEM_VALUE = this.data.settings.redeemValue;
        }

        this.saveData();
        
        return {
            success: true,
            settings: this.data.settings
        };
    }

    formatCurrency(amount) {
        return 'Rp ' + new Intl.NumberFormat('id-ID', {
            minimumFractionDigits: 0,
            maximumFractionDigits: 0
        }).format(amount);
    }
}

module.exports = RoyaltySystem;